/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;

class WriteGroupedRecordsToFiles<DestinationT, ElementT>
extends DoFn<KV<ShardedKey<DestinationT>, Iterable<ElementT>>, WriteBundlesToFiles.Result<DestinationT>> {
    private final PCollectionView<String> tempFilePrefix;
    private final long maxFileSize;
    private final SerializableFunction<ElementT, TableRow> toRowFunction;

    WriteGroupedRecordsToFiles(PCollectionView<String> tempFilePrefix, long maxFileSize, SerializableFunction<ElementT, TableRow> toRowFunction) {
        this.tempFilePrefix = tempFilePrefix;
        this.maxFileSize = maxFileSize;
        this.toRowFunction = toRowFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, @DoFn.Element KV<ShardedKey<DestinationT>, Iterable<ElementT>> element, DoFn.OutputReceiver<WriteBundlesToFiles.Result<DestinationT>> o) throws Exception {
        String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
        try (TableRowWriter writer = new TableRowWriter(tempFilePrefix);){
            for (Object tableRow : (Iterable)element.getValue()) {
                if (writer.getByteSize() > this.maxFileSize) {
                    writer.close();
                    writer = new TableRowWriter(tempFilePrefix);
                    TableRowWriter.Result result = writer.getResult();
                    o.output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((ShardedKey)((KV)c.element()).getKey()).getKey()));
                }
                writer.write((TableRow)this.toRowFunction.apply(tableRow));
            }
        }
        TableRowWriter.Result result = writer.getResult();
        o.output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((ShardedKey)((KV)c.element()).getKey()).getKey()));
    }
}

