/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class PrepareWrite<T, DestinationT>
extends PTransform<PCollection<T>, PCollection<KV<DestinationT, TableRow>>> {
    private DynamicDestinations<T, DestinationT> dynamicDestinations;
    private SerializableFunction<T, TableRow> formatFunction;

    public PrepareWrite(DynamicDestinations<T, DestinationT> dynamicDestinations, SerializableFunction<T, TableRow> formatFunction) {
        this.dynamicDestinations = dynamicDestinations;
        this.formatFunction = formatFunction;
    }

    public PCollection<KV<DestinationT, TableRow>> expand(PCollection<T> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<T, KV<DestinationT, TableRow>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
                PrepareWrite.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
                ValueInSingleWindow element = ValueInSingleWindow.of((Object)context.element(), (Instant)context.timestamp(), (BoundedWindow)window, (PaneInfo)context.pane());
                Object tableDestination = PrepareWrite.this.dynamicDestinations.getDestination(element);
                Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getDestination() may not return null, but %s returned null on element %s", (Object)PrepareWrite.this.dynamicDestinations, (Object)element);
                TableRow tableRow = (TableRow)PrepareWrite.this.formatFunction.apply(context.element());
                Preconditions.checkArgument((tableRow != null ? 1 : 0) != 0, (String)"formatFunction may not return null, but %s returned null on element %s", (Object)PrepareWrite.this.formatFunction, (Object)context.element());
                context.output((Object)KV.of(tableDestination, (Object)tableRow));
            }
        }).withSideInputs(this.dynamicDestinations.getSideInputs()));
    }
}

