/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;

final class AutoValue_BigQueryIO_Write<T>
extends BigQueryIO.Write<T> {
    private final ValueProvider<String> jsonTableRef;
    private final SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;
    private final SerializableFunction<T, TableRow> formatFunction;
    private final DynamicDestinations<T, ?> dynamicDestinations;
    private final PCollectionView<Map<String, String>> schemaFromView;
    private final ValueProvider<String> jsonSchema;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final BigQueryIO.Write.WriteDisposition writeDisposition;
    private final String tableDescription;
    private final boolean validate;
    private final BigQueryServices bigQueryServices;
    private final Integer maxFilesPerBundle;
    private final Long maxFileSize;
    private final InsertRetryPolicy failedInsertRetryPolicy;

    private AutoValue_BigQueryIO_Write(@Nullable ValueProvider<String> jsonTableRef, @Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction, @Nullable SerializableFunction<T, TableRow> formatFunction, @Nullable DynamicDestinations<T, ?> dynamicDestinations, @Nullable PCollectionView<Map<String, String>> schemaFromView, @Nullable ValueProvider<String> jsonSchema, BigQueryIO.Write.CreateDisposition createDisposition, BigQueryIO.Write.WriteDisposition writeDisposition, @Nullable String tableDescription, boolean validate, BigQueryServices bigQueryServices, @Nullable Integer maxFilesPerBundle, @Nullable Long maxFileSize, @Nullable InsertRetryPolicy failedInsertRetryPolicy) {
        this.jsonTableRef = jsonTableRef;
        this.tableFunction = tableFunction;
        this.formatFunction = formatFunction;
        this.dynamicDestinations = dynamicDestinations;
        this.schemaFromView = schemaFromView;
        this.jsonSchema = jsonSchema;
        this.createDisposition = createDisposition;
        this.writeDisposition = writeDisposition;
        this.tableDescription = tableDescription;
        this.validate = validate;
        this.bigQueryServices = bigQueryServices;
        this.maxFilesPerBundle = maxFilesPerBundle;
        this.maxFileSize = maxFileSize;
        this.failedInsertRetryPolicy = failedInsertRetryPolicy;
    }

    @Override
    @Nullable
    ValueProvider<String> getJsonTableRef() {
        return this.jsonTableRef;
    }

    @Override
    @Nullable
    SerializableFunction<ValueInSingleWindow<T>, TableDestination> getTableFunction() {
        return this.tableFunction;
    }

    @Override
    @Nullable
    SerializableFunction<T, TableRow> getFormatFunction() {
        return this.formatFunction;
    }

    @Override
    @Nullable
    DynamicDestinations<T, ?> getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    @Override
    @Nullable
    PCollectionView<Map<String, String>> getSchemaFromView() {
        return this.schemaFromView;
    }

    @Override
    @Nullable
    ValueProvider<String> getJsonSchema() {
        return this.jsonSchema;
    }

    @Override
    BigQueryIO.Write.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    BigQueryIO.Write.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    @Nullable
    String getTableDescription() {
        return this.tableDescription;
    }

    @Override
    boolean getValidate() {
        return this.validate;
    }

    @Override
    BigQueryServices getBigQueryServices() {
        return this.bigQueryServices;
    }

    @Override
    @Nullable
    Integer getMaxFilesPerBundle() {
        return this.maxFilesPerBundle;
    }

    @Override
    @Nullable
    Long getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    @Nullable
    InsertRetryPolicy getFailedInsertRetryPolicy() {
        return this.failedInsertRetryPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryIO.Write) {
            BigQueryIO.Write that = (BigQueryIO.Write)((Object)o);
            return (this.jsonTableRef == null ? that.getJsonTableRef() == null : this.jsonTableRef.equals(that.getJsonTableRef())) && (this.tableFunction == null ? that.getTableFunction() == null : this.tableFunction.equals(that.getTableFunction())) && (this.formatFunction == null ? that.getFormatFunction() == null : this.formatFunction.equals(that.getFormatFunction())) && (this.dynamicDestinations == null ? that.getDynamicDestinations() == null : this.dynamicDestinations.equals(that.getDynamicDestinations())) && (this.schemaFromView == null ? that.getSchemaFromView() == null : this.schemaFromView.equals(that.getSchemaFromView())) && (this.jsonSchema == null ? that.getJsonSchema() == null : this.jsonSchema.equals(that.getJsonSchema())) && this.createDisposition.equals((Object)that.getCreateDisposition()) && this.writeDisposition.equals((Object)that.getWriteDisposition()) && (this.tableDescription == null ? that.getTableDescription() == null : this.tableDescription.equals(that.getTableDescription())) && this.validate == that.getValidate() && this.bigQueryServices.equals(that.getBigQueryServices()) && (this.maxFilesPerBundle == null ? that.getMaxFilesPerBundle() == null : this.maxFilesPerBundle.equals(that.getMaxFilesPerBundle())) && (this.maxFileSize == null ? that.getMaxFileSize() == null : this.maxFileSize.equals(that.getMaxFileSize())) && (this.failedInsertRetryPolicy == null ? that.getFailedInsertRetryPolicy() == null : this.failedInsertRetryPolicy.equals(that.getFailedInsertRetryPolicy()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.jsonTableRef == null ? 0 : this.jsonTableRef.hashCode();
        h *= 1000003;
        h ^= this.tableFunction == null ? 0 : this.tableFunction.hashCode();
        h *= 1000003;
        h ^= this.formatFunction == null ? 0 : this.formatFunction.hashCode();
        h *= 1000003;
        h ^= this.dynamicDestinations == null ? 0 : this.dynamicDestinations.hashCode();
        h *= 1000003;
        h ^= this.schemaFromView == null ? 0 : this.schemaFromView.hashCode();
        h *= 1000003;
        h ^= this.jsonSchema == null ? 0 : this.jsonSchema.hashCode();
        h *= 1000003;
        h ^= this.createDisposition.hashCode();
        h *= 1000003;
        h ^= this.writeDisposition.hashCode();
        h *= 1000003;
        h ^= this.tableDescription == null ? 0 : this.tableDescription.hashCode();
        h *= 1000003;
        h ^= this.validate ? 1231 : 1237;
        h *= 1000003;
        h ^= this.bigQueryServices.hashCode();
        h *= 1000003;
        h ^= this.maxFilesPerBundle == null ? 0 : this.maxFilesPerBundle.hashCode();
        h *= 1000003;
        h ^= this.maxFileSize == null ? 0 : this.maxFileSize.hashCode();
        h *= 1000003;
        return h ^= this.failedInsertRetryPolicy == null ? 0 : this.failedInsertRetryPolicy.hashCode();
    }

    @Override
    BigQueryIO.Write.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends BigQueryIO.Write.Builder<T> {
        private ValueProvider<String> jsonTableRef;
        private SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;
        private SerializableFunction<T, TableRow> formatFunction;
        private DynamicDestinations<T, ?> dynamicDestinations;
        private PCollectionView<Map<String, String>> schemaFromView;
        private ValueProvider<String> jsonSchema;
        private BigQueryIO.Write.CreateDisposition createDisposition;
        private BigQueryIO.Write.WriteDisposition writeDisposition;
        private String tableDescription;
        private Boolean validate;
        private BigQueryServices bigQueryServices;
        private Integer maxFilesPerBundle;
        private Long maxFileSize;
        private InsertRetryPolicy failedInsertRetryPolicy;

        Builder() {
        }

        private Builder(BigQueryIO.Write<T> source) {
            this.jsonTableRef = source.getJsonTableRef();
            this.tableFunction = source.getTableFunction();
            this.formatFunction = source.getFormatFunction();
            this.dynamicDestinations = source.getDynamicDestinations();
            this.schemaFromView = source.getSchemaFromView();
            this.jsonSchema = source.getJsonSchema();
            this.createDisposition = source.getCreateDisposition();
            this.writeDisposition = source.getWriteDisposition();
            this.tableDescription = source.getTableDescription();
            this.validate = source.getValidate();
            this.bigQueryServices = source.getBigQueryServices();
            this.maxFilesPerBundle = source.getMaxFilesPerBundle();
            this.maxFileSize = source.getMaxFileSize();
            this.failedInsertRetryPolicy = source.getFailedInsertRetryPolicy();
        }

        @Override
        BigQueryIO.Write.Builder<T> setJsonTableRef(@Nullable ValueProvider<String> jsonTableRef) {
            this.jsonTableRef = jsonTableRef;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setTableFunction(@Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
            this.tableFunction = tableFunction;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setFormatFunction(@Nullable SerializableFunction<T, TableRow> formatFunction) {
            this.formatFunction = formatFunction;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setDynamicDestinations(@Nullable DynamicDestinations<T, ?> dynamicDestinations) {
            this.dynamicDestinations = dynamicDestinations;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setSchemaFromView(@Nullable PCollectionView<Map<String, String>> schemaFromView) {
            this.schemaFromView = schemaFromView;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setJsonSchema(@Nullable ValueProvider<String> jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setCreateDisposition(BigQueryIO.Write.CreateDisposition createDisposition) {
            if (createDisposition == null) {
                throw new NullPointerException("Null createDisposition");
            }
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setWriteDisposition(BigQueryIO.Write.WriteDisposition writeDisposition) {
            if (writeDisposition == null) {
                throw new NullPointerException("Null writeDisposition");
            }
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setTableDescription(@Nullable String tableDescription) {
            this.tableDescription = tableDescription;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setBigQueryServices(BigQueryServices bigQueryServices) {
            if (bigQueryServices == null) {
                throw new NullPointerException("Null bigQueryServices");
            }
            this.bigQueryServices = bigQueryServices;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxFilesPerBundle(@Nullable Integer maxFilesPerBundle) {
            this.maxFilesPerBundle = maxFilesPerBundle;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxFileSize(@Nullable Long maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setFailedInsertRetryPolicy(@Nullable InsertRetryPolicy failedInsertRetryPolicy) {
            this.failedInsertRetryPolicy = failedInsertRetryPolicy;
            return this;
        }

        @Override
        BigQueryIO.Write<T> build() {
            String missing = "";
            if (this.createDisposition == null) {
                missing = missing + " createDisposition";
            }
            if (this.writeDisposition == null) {
                missing = missing + " writeDisposition";
            }
            if (this.validate == null) {
                missing = missing + " validate";
            }
            if (this.bigQueryServices == null) {
                missing = missing + " bigQueryServices";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryIO_Write(this.jsonTableRef, this.tableFunction, this.formatFunction, this.dynamicDestinations, this.schemaFromView, this.jsonSchema, this.createDisposition, this.writeDisposition, this.tableDescription, this.validate, this.bigQueryServices, this.maxFilesPerBundle, this.maxFileSize, this.failedInsertRetryPolicy);
        }
    }
}

