/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.UUID;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKey;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;

@VisibleForTesting
class TagWithUniqueIds
extends DoFn<KV<ShardedKey<String>, TableRow>, KV<ShardedKey<String>, TableRowInfo>> {
    private transient String randomUUID;
    private transient long sequenceNo = 0L;

    TagWithUniqueIds() {
    }

    @DoFn.StartBundle
    public void startBundle() {
        this.randomUUID = UUID.randomUUID().toString();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
        String uniqueId = this.randomUUID + this.sequenceNo++;
        context.output((Object)KV.of((Object)((KV)context.element()).getKey(), (Object)new TableRowInfo((TableRow)((KV)context.element()).getValue(), uniqueId)));
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
    }
}

