/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKey;

@VisibleForTesting
class ShardedKeyCoder<KeyT>
extends StructuredCoder<ShardedKey<KeyT>> {
    private final Coder<KeyT> keyCoder;
    private final VarIntCoder shardNumberCoder;

    public static <KeyT> ShardedKeyCoder<KeyT> of(Coder<KeyT> keyCoder) {
        return new ShardedKeyCoder<KeyT>(keyCoder);
    }

    protected ShardedKeyCoder(Coder<KeyT> keyCoder) {
        this.keyCoder = keyCoder;
        this.shardNumberCoder = VarIntCoder.of();
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder);
    }

    public void encode(ShardedKey<KeyT> key, OutputStream outStream) throws IOException {
        this.keyCoder.encode(key.getKey(), outStream);
        this.shardNumberCoder.encode(Integer.valueOf(key.getShardNumber()), outStream);
    }

    public ShardedKey<KeyT> decode(InputStream inStream) throws IOException {
        return new ShardedKey<Object>(this.keyCoder.decode(inStream), this.shardNumberCoder.decode(inStream));
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
    }
}

