/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Query;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;

final class AutoValue_DatastoreV1_Read
extends DatastoreV1.Read {
    private final String projectId;
    private final Query query;
    private final String namespace;
    private final int numQuerySplits;
    private final String localhost;

    private AutoValue_DatastoreV1_Read(@Nullable String projectId, @Nullable Query query, @Nullable String namespace, int numQuerySplits, @Nullable String localhost) {
        this.projectId = projectId;
        this.query = query;
        this.namespace = namespace;
        this.numQuerySplits = numQuerySplits;
        this.localhost = localhost;
    }

    @Override
    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public Query getQuery() {
        return this.query;
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int getNumQuerySplits() {
        return this.numQuerySplits;
    }

    @Override
    @Nullable
    public String getLocalhost() {
        return this.localhost;
    }

    @Override
    public String toString() {
        return "Read{projectId=" + this.projectId + ", query=" + this.query + ", namespace=" + this.namespace + ", numQuerySplits=" + this.numQuerySplits + ", localhost=" + this.localhost + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatastoreV1.Read) {
            DatastoreV1.Read that = (DatastoreV1.Read)((Object)o);
            return (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.query == null ? that.getQuery() == null : this.query.equals((Object)that.getQuery())) && (this.namespace == null ? that.getNamespace() == null : this.namespace.equals(that.getNamespace())) && this.numQuerySplits == that.getNumQuerySplits() && (this.localhost == null ? that.getLocalhost() == null : this.localhost.equals(that.getLocalhost()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h *= 1000003;
        h ^= this.query == null ? 0 : this.query.hashCode();
        h *= 1000003;
        h ^= this.namespace == null ? 0 : this.namespace.hashCode();
        h *= 1000003;
        h ^= this.numQuerySplits;
        h *= 1000003;
        return h ^= this.localhost == null ? 0 : this.localhost.hashCode();
    }

    @Override
    public DatastoreV1.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DatastoreV1.Read.Builder {
        private String projectId;
        private Query query;
        private String namespace;
        private Integer numQuerySplits;
        private String localhost;

        Builder() {
        }

        Builder(DatastoreV1.Read source) {
            this.projectId = source.getProjectId();
            this.query = source.getQuery();
            this.namespace = source.getNamespace();
            this.numQuerySplits = source.getNumQuerySplits();
            this.localhost = source.getLocalhost();
        }

        @Override
        public DatastoreV1.Read.Builder setProjectId(@Nullable String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public DatastoreV1.Read.Builder setQuery(@Nullable Query query) {
            this.query = query;
            return this;
        }

        @Override
        public DatastoreV1.Read.Builder setNamespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public DatastoreV1.Read.Builder setNumQuerySplits(int numQuerySplits) {
            this.numQuerySplits = numQuerySplits;
            return this;
        }

        @Override
        public DatastoreV1.Read.Builder setLocalhost(@Nullable String localhost) {
            this.localhost = localhost;
            return this;
        }

        @Override
        public DatastoreV1.Read build() {
            String missing = "";
            if (this.numQuerySplits == null) {
                missing = missing + " numQuerySplits";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DatastoreV1_Read(this.projectId, this.query, this.namespace, this.numQuerySplits, this.localhost);
        }
    }
}

