/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StandardCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TableRowJsonCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.options.BigQueryOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.FileIOChannelFactory;
import org.apache.beam.sdk.util.GcsIOChannelFactory;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.IOChannelFactory;
import org.apache.beam.sdk.util.IOChannelUtils;
import org.apache.beam.sdk.util.Reshuffle;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.Transport;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    private static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final String TABLE_REGEXP = "[-\\w$@]{1,1024}";
    private static final String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s):)?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{4,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@]{1,1024}");
    private static final Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    private static final String RESOURCE_NOT_FOUND_ERROR = "BigQuery %1$s not found for table \"%2$s\" . Please create the %1$s before pipeline execution. If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";
    private static final String UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR = "Unable to confirm BigQuery %1$s presence for table \"%2$s\". If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";

    public static TableReference parseTableSpec(String tableSpec) {
        Matcher match = TABLE_SPEC.matcher(tableSpec);
        if (!match.matches()) {
            throw new IllegalArgumentException("Table reference is not in [project_id]:[dataset_id].[table_id] format: " + tableSpec);
        }
        TableReference ref = new TableReference();
        ref.setProjectId(match.group("PROJECT"));
        return ref.setDatasetId(match.group("DATASET")).setTableId(match.group("TABLE"));
    }

    public static String toTableSpec(TableReference ref) {
        StringBuilder sb = new StringBuilder();
        if (ref.getProjectId() != null) {
            sb.append(ref.getProjectId());
            sb.append(":");
        }
        sb.append(ref.getDatasetId()).append('.').append(ref.getTableId());
        return sb.toString();
    }

    @Nullable
    private static ValueProvider<String> displayTable(@Nullable ValueProvider<TableReference> table) {
        if (table == null) {
            return null;
        }
        return ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToTableSpec());
    }

    private static String getExtractJobId(ValueProvider<String> jobIdToken) {
        return (String)jobIdToken.get() + "-extract";
    }

    private static String getExtractDestinationUri(String extractDestinationDir) {
        return String.format("%s/%s", extractDestinationDir, "*.avro");
    }

    private static List<String> getExtractFilePaths(String extractDestinationDir, Job extractJob) throws IOException {
        JobStatistics jobStats = extractJob.getStatistics();
        List counts = jobStats.getExtract().getDestinationUriFileCounts();
        if (counts.size() != 1) {
            String errorMessage = counts.size() == 0 ? "No destination uri file count received." : String.format("More than one destination uri file count received. First two are %s, %s", counts.get(0), counts.get(1));
            throw new RuntimeException(errorMessage);
        }
        long filesCount = (Long)counts.get(0);
        ImmutableList.Builder paths = ImmutableList.builder();
        IOChannelFactory factory = IOChannelUtils.getFactory((String)extractDestinationDir);
        for (long i = 0L; i < filesCount; ++i) {
            String filePath = factory.resolve(extractDestinationDir, String.format("%012d%s", i, ".avro"));
            paths.add((Object)filePath);
        }
        return paths.build();
    }

    private static String jobToPrettyString(@Nullable Job job) throws IOException {
        return job == null ? "null" : job.toPrettyString();
    }

    private static String statusToPrettyString(@Nullable JobStatus status) throws IOException {
        return status == null ? "Unknown status: null." : status.toPrettyString();
    }

    private static void verifyDatasetPresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getDataset(table.getProjectId(), table.getDatasetId());
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "dataset", BigQueryIO.toTableSpec(table)), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "dataset", BigQueryIO.toTableSpec(table)), e);
        }
    }

    private static void verifyTablePresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getTable(table);
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "table", BigQueryIO.toTableSpec(table)), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "table", BigQueryIO.toTableSpec(table)), e);
        }
    }

    @VisibleForTesting
    static void clearCreatedTables() {
        StreamingWriteFn.clearCreatedTables();
    }

    private static Status parseStatus(@Nullable Job job) {
        if (job == null) {
            return Status.UNKNOWN;
        }
        JobStatus status = job.getStatus();
        if (status.getErrorResult() != null) {
            return Status.FAILED;
        }
        if (status.getErrors() != null && !status.getErrors().isEmpty()) {
            return Status.FAILED;
        }
        return Status.SUCCEEDED;
    }

    @VisibleForTesting
    static String toJsonString(Object item) {
        if (item == null) {
            return null;
        }
        try {
            return JSON_FACTORY.toString(item);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot serialize %s to a JSON string.", item.getClass().getSimpleName()), e);
        }
    }

    @VisibleForTesting
    static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)JSON_FACTORY.fromString(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot deserialize %s from a JSON string: %s.", clazz, json), e);
        }
    }

    private static String randomUUIDString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private BigQueryIO() {
    }

    private static <K, V> List<V> getOrCreateMapListValue(Map<K, List<V>> map, K key) {
        List<V> value = map.get(key);
        if (value == null) {
            value = new ArrayList<V>();
            map.put(key, value);
        }
        return value;
    }

    static enum Status {
        SUCCEEDED,
        FAILED,
        UNKNOWN;

    }

    private static class StreamWithDeDup
    extends PTransform<PCollection<TableRow>, PDone> {
        @Nullable
        private final transient ValueProvider<TableReference> tableReference;
        @Nullable
        private final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
        @Nullable
        private final transient ValueProvider<TableSchema> tableSchema;
        private final Write.CreateDisposition createDisposition;
        private final BigQueryServices bqServices;

        StreamWithDeDup(ValueProvider<TableReference> tableReference, @Nullable SerializableFunction<BoundedWindow, TableReference> tableRefFunction, @Nullable ValueProvider<TableSchema> tableSchema, Write.CreateDisposition createDisposition, BigQueryServices bqServices) {
            this.tableReference = tableReference;
            this.tableRefFunction = tableRefFunction;
            this.tableSchema = tableSchema;
            this.createDisposition = createDisposition;
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        }

        protected Coder<Void> getDefaultOutputCoder() {
            return VoidCoder.of();
        }

        public PDone expand(PCollection<TableRow> input) {
            PCollection tagged = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new TagWithUniqueIdsAndTable((BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class), this.tableReference, this.tableRefFunction)));
            ((PCollection)tagged.setCoder((Coder)KvCoder.of(ShardedKeyCoder.of(StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of())).apply((PTransform)Reshuffle.of())).apply((PTransform)ParDo.of((DoFn)new StreamingWriteFn(this.tableSchema, this.createDisposition, this.bqServices)));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    @VisibleForTesting
    static class TagWithUniqueIdsAndTable
    extends DoFn<TableRow, KV<ShardedKey<String>, TableRowInfo>> {
        private final ValueProvider<String> tableSpec;
        private final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
        private transient String randomUUID;
        private transient long sequenceNo = 0L;

        TagWithUniqueIdsAndTable(BigQueryOptions options, ValueProvider<TableReference> table, SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
            Preconditions.checkArgument((boolean)(table == null ^ tableRefFunction == null), (Object)"Exactly one of table or tableRefFunction should be set");
            if (table != null) {
                if (table.isAccessible() && Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    TableReference tableRef = ((TableReference)table.get()).setProjectId(((BigQueryOptions)options.as(BigQueryOptions.class)).getProject());
                    table = ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryIO.toJsonString(tableRef)), (SerializableFunction)new JsonTableRefToTableRef());
                }
                this.tableSpec = ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToTableSpec());
            } else {
                this.tableSpec = null;
            }
            this.tableRefFunction = tableRefFunction;
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.Context context) {
            this.randomUUID = UUID.randomUUID().toString();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
            String uniqueId = this.randomUUID + this.sequenceNo++;
            ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
            String tableSpec = this.tableSpecFromWindow((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class), window);
            context.output((Object)KV.of(ShardedKey.of(tableSpec, randomGenerator.nextInt(0, 50)), (Object)new TableRowInfo((TableRow)context.element(), uniqueId)));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", this.tableSpec));
            if (this.tableRefFunction != null) {
                builder.add(DisplayData.item((String)"tableFn", this.tableRefFunction.getClass()).withLabel("Table Reference Function"));
            }
        }

        @VisibleForTesting
        ValueProvider<String> getTableSpec() {
            return this.tableSpec;
        }

        private String tableSpecFromWindow(BigQueryOptions options, BoundedWindow window) {
            if (this.tableSpec != null) {
                return (String)this.tableSpec.get();
            }
            TableReference table = (TableReference)this.tableRefFunction.apply((Object)window);
            if (table.getProjectId() == null) {
                table.setProjectId(options.getProject());
            }
            return BigQueryIO.toTableSpec(table);
        }
    }

    private static class TableRowInfo {
        final TableRow tableRow;
        final String uniqueId;

        TableRowInfo(TableRow tableRow, String uniqueId) {
            this.tableRow = tableRow;
            this.uniqueId = uniqueId;
        }
    }

    private static class TableRowInfoCoder
    extends AtomicCoder<TableRowInfo> {
        private static final TableRowInfoCoder INSTANCE = new TableRowInfoCoder();
        TableRowJsonCoder tableRowCoder = TableRowJsonCoder.of();
        StringUtf8Coder idCoder = StringUtf8Coder.of();

        private TableRowInfoCoder() {
        }

        @JsonCreator
        public static TableRowInfoCoder of() {
            return INSTANCE;
        }

        public void encode(TableRowInfo value, OutputStream outStream, Coder.Context context) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            this.tableRowCoder.encode(value.tableRow, outStream, context.nested());
            this.idCoder.encode(value.uniqueId, outStream, context);
        }

        public TableRowInfo decode(InputStream inStream, Coder.Context context) throws IOException {
            return new TableRowInfo(this.tableRowCoder.decode(inStream, context.nested()), this.idCoder.decode(inStream, context));
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            throw new Coder.NonDeterministicException((Coder)this, "TableRows are not deterministic.");
        }
    }

    @VisibleForTesting
    static class ShardedKeyCoder<KeyT>
    extends StandardCoder<ShardedKey<KeyT>> {
        Coder<KeyT> keyCoder;
        VarIntCoder shardNumberCoder;

        public static <KeyT> ShardedKeyCoder<KeyT> of(Coder<KeyT> keyCoder) {
            return new ShardedKeyCoder<KeyT>(keyCoder);
        }

        @JsonCreator
        public static <KeyT> ShardedKeyCoder<KeyT> of(@JsonProperty(value="component_encodings") List<Coder<KeyT>> components) {
            Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expecting 1 component, got %s", (Object[])new Object[]{components.size()});
            return ShardedKeyCoder.of(components.get(0));
        }

        protected ShardedKeyCoder(Coder<KeyT> keyCoder) {
            this.keyCoder = keyCoder;
            this.shardNumberCoder = VarIntCoder.of();
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.keyCoder);
        }

        public void encode(ShardedKey<KeyT> key, OutputStream outStream, Coder.Context context) throws IOException {
            this.keyCoder.encode(key.getKey(), outStream, context.nested());
            this.shardNumberCoder.encode(Integer.valueOf(key.getShardNumber()), outStream, context);
        }

        public ShardedKey<KeyT> decode(InputStream inStream, Coder.Context context) throws IOException {
            return new ShardedKey(this.keyCoder.decode(inStream, context.nested()), this.shardNumberCoder.decode(inStream, context));
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.keyCoder.verifyDeterministic();
        }
    }

    private static class ShardedKey<K> {
        private final K key;
        private final int shardNumber;

        public static <K> ShardedKey<K> of(K key, int shardNumber) {
            return new ShardedKey<K>(key, shardNumber);
        }

        private ShardedKey(K key, int shardNumber) {
            this.key = key;
            this.shardNumber = shardNumber;
        }

        public K getKey() {
            return this.key;
        }

        public int getShardNumber() {
            return this.shardNumber;
        }
    }

    @SystemDoFnInternal
    @VisibleForTesting
    static class StreamingWriteFn
    extends DoFn<KV<ShardedKey<String>, TableRowInfo>, Void> {
        @Nullable
        private final ValueProvider<String> jsonTableSchema;
        private final BigQueryServices bqServices;
        private transient Map<String, List<TableRow>> tableRows;
        private final Write.CreateDisposition createDisposition;
        private transient Map<String, List<String>> uniqueIdsForTableRows;
        private static Set<String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());
        private Aggregator<Long, Long> byteCountAggregator = this.createAggregator("ByteCount", (Combine.CombineFn)Sum.ofLongs());

        StreamingWriteFn(@Nullable ValueProvider<TableSchema> schema, Write.CreateDisposition createDisposition, BigQueryServices bqServices) {
            this.jsonTableSchema = schema == null ? null : ValueProvider.NestedValueProvider.of(schema, (SerializableFunction)new TableSchemaToJsonSchema());
            this.createDisposition = createDisposition;
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearCreatedTables() {
            Set<String> set = createdTables;
            synchronized (set) {
                createdTables.clear();
            }
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.Context context) {
            this.tableRows = new HashMap<String, List<TableRow>>();
            this.uniqueIdsForTableRows = new HashMap<String, List<String>>();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            String tableSpec = (String)((ShardedKey)((KV)context.element()).getKey()).getKey();
            List rows = BigQueryIO.getOrCreateMapListValue(this.tableRows, tableSpec);
            List uniqueIds = BigQueryIO.getOrCreateMapListValue(this.uniqueIdsForTableRows, tableSpec);
            rows.add(((TableRowInfo)((KV)context.element()).getValue()).tableRow);
            uniqueIds.add(((TableRowInfo)((KV)context.element()).getValue()).uniqueId);
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.Context context) throws Exception {
            BigQueryOptions options = (BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class);
            for (Map.Entry<String, List<TableRow>> entry : this.tableRows.entrySet()) {
                TableReference tableReference = this.getOrCreateTable(options, entry.getKey());
                this.flushRows(tableReference, entry.getValue(), this.uniqueIdsForTableRows.get(entry.getKey()), options);
            }
            this.tableRows.clear();
            this.uniqueIdsForTableRows.clear();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"schema", this.jsonTableSchema).withLabel("Table Schema"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TableReference getOrCreateTable(BigQueryOptions options, String tableSpec) throws InterruptedException, IOException {
            TableReference tableReference = BigQueryIO.parseTableSpec(tableSpec);
            if (this.createDisposition != Write.CreateDisposition.CREATE_NEVER && !createdTables.contains(tableSpec)) {
                Set<String> set = createdTables;
                synchronized (set) {
                    BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(options);
                    if (!createdTables.contains(tableSpec)) {
                        if (datasetService.getTable(tableReference) == null) {
                            TableSchema tableSchema = (TableSchema)JSON_FACTORY.fromString((String)this.jsonTableSchema.get(), TableSchema.class);
                            datasetService.createTable(new Table().setTableReference(tableReference).setSchema(tableSchema));
                        }
                        createdTables.add(tableSpec);
                    }
                }
            }
            return tableReference;
        }

        private void flushRows(TableReference tableReference, List<TableRow> tableRows, List<String> uniqueIds, BigQueryOptions options) throws InterruptedException {
            if (!tableRows.isEmpty()) {
                try {
                    long totalBytes = this.bqServices.getDatasetService(options).insertAll(tableReference, tableRows, uniqueIds);
                    this.byteCountAggregator.addValue((Object)totalBytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class Write {
        public static Bound to(String tableSpec) {
            return new Bound().to(tableSpec);
        }

        public static Bound to(ValueProvider<String> tableSpec) {
            return new Bound().to(tableSpec);
        }

        public static Bound to(TableReference table) {
            return new Bound().to(table);
        }

        public static Bound to(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
            return new Bound().to(tableSpecFunction);
        }

        public static Bound toTableReference(SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
            return new Bound().toTableReference(tableRefFunction);
        }

        public static Bound withSchema(TableSchema schema) {
            return new Bound().withSchema(schema);
        }

        public static Bound withSchema(ValueProvider<TableSchema> schema) {
            return new Bound().withSchema(schema);
        }

        public static Bound withCreateDisposition(CreateDisposition disposition) {
            return new Bound().withCreateDisposition(disposition);
        }

        public static Bound withWriteDisposition(WriteDisposition disposition) {
            return new Bound().withWriteDisposition(disposition);
        }

        public static Bound withoutValidation() {
            return new Bound().withoutValidation();
        }

        private Write() {
        }

        static class WriteRename
        extends DoFn<String, Void> {
            private final BigQueryServices bqServices;
            private final ValueProvider<String> jobIdToken;
            private final ValueProvider<String> jsonTableRef;
            private final WriteDisposition writeDisposition;
            private final CreateDisposition createDisposition;
            private final PCollectionView<Iterable<String>> tempTablesView;

            public WriteRename(BigQueryServices bqServices, ValueProvider<String> jobIdToken, ValueProvider<String> jsonTableRef, WriteDisposition writeDisposition, CreateDisposition createDisposition, PCollectionView<Iterable<String>> tempTablesView) {
                this.bqServices = bqServices;
                this.jobIdToken = jobIdToken;
                this.jsonTableRef = jsonTableRef;
                this.writeDisposition = writeDisposition;
                this.createDisposition = createDisposition;
                this.tempTablesView = tempTablesView;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                ArrayList tempTablesJson = Lists.newArrayList((Iterable)((Iterable)c.sideInput(this.tempTablesView)));
                if (tempTablesJson.size() == 0) {
                    return;
                }
                ArrayList tempTables = Lists.newArrayList();
                for (String table : tempTablesJson) {
                    tempTables.add(BigQueryIO.fromJsonString(table, TableReference.class));
                }
                this.copy(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), (String)this.jobIdToken.get(), BigQueryIO.fromJsonString((String)this.jsonTableRef.get(), TableReference.class), tempTables, this.writeDisposition, this.createDisposition);
                BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class));
                WriteRename.removeTemporaryTables(tableService, tempTables);
            }

            private void copy(BigQueryServices.JobService jobService, String jobIdPrefix, TableReference ref, List<TableReference> tempTables, WriteDisposition writeDisposition, CreateDisposition createDisposition) throws InterruptedException, IOException {
                JobConfigurationTableCopy copyConfig = new JobConfigurationTableCopy().setSourceTables(tempTables).setDestinationTable(ref).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name());
                String projectId = ref.getProjectId();
                Job lastFailedCopyJob = null;
                block5: for (int i = 0; i < 3; ++i) {
                    String jobId = jobIdPrefix + "-" + i;
                    JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId);
                    jobService.startCopyJob(jobRef, copyConfig);
                    Job copyJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
                    Status jobStatus = BigQueryIO.parseStatus(copyJob);
                    switch (jobStatus) {
                        case SUCCEEDED: {
                            return;
                        }
                        case UNKNOWN: {
                            throw new RuntimeException(String.format("UNKNOWN status of copy job [%s]: %s.", jobId, BigQueryIO.jobToPrettyString(copyJob)));
                        }
                        case FAILED: {
                            lastFailedCopyJob = copyJob;
                            continue block5;
                        }
                        default: {
                            throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", new Object[]{jobStatus, BigQueryIO.jobToPrettyString(copyJob)}));
                        }
                    }
                }
                throw new RuntimeException(String.format("Failed to create copy job with id prefix %s, reached max retries: %d, last failed copy job: %s.", jobIdPrefix, 3, BigQueryIO.jobToPrettyString(lastFailedCopyJob)));
            }

            static void removeTemporaryTables(BigQueryServices.DatasetService tableService, List<TableReference> tempTables) {
                for (TableReference tableRef : tempTables) {
                    try {
                        LOG.debug("Deleting table {}", (Object)BigQueryIO.toJsonString(tableRef));
                        tableService.deleteTable(tableRef);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to delete the table {}", (Object)BigQueryIO.toJsonString(tableRef), (Object)e);
                    }
                }
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item((String)"jobIdToken", this.jobIdToken).withLabel("Job ID Token")).addIfNotNull(DisplayData.item((String)"jsonTableRef", this.jsonTableRef).withLabel("Table Reference")).add(DisplayData.item((String)"writeDisposition", (String)this.writeDisposition.toString()).withLabel("Write Disposition")).add(DisplayData.item((String)"createDisposition", (String)this.createDisposition.toString()).withLabel("Create Disposition"));
            }
        }

        static class WriteTables
        extends DoFn<KV<Long, Iterable<List<String>>>, String> {
            private final boolean singlePartition;
            private final BigQueryServices bqServices;
            private final ValueProvider<String> jobIdToken;
            private final String tempFilePrefix;
            private final ValueProvider<String> jsonTableRef;
            private final ValueProvider<String> jsonSchema;
            private final WriteDisposition writeDisposition;
            private final CreateDisposition createDisposition;

            public WriteTables(boolean singlePartition, BigQueryServices bqServices, ValueProvider<String> jobIdToken, String tempFilePrefix, ValueProvider<String> jsonTableRef, ValueProvider<String> jsonSchema, WriteDisposition writeDisposition, CreateDisposition createDisposition) {
                this.singlePartition = singlePartition;
                this.bqServices = bqServices;
                this.jobIdToken = jobIdToken;
                this.tempFilePrefix = tempFilePrefix;
                this.jsonTableRef = jsonTableRef;
                this.jsonSchema = jsonSchema;
                this.writeDisposition = writeDisposition;
                this.createDisposition = createDisposition;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                List partition = (List)Lists.newArrayList((Iterable)((Iterable)((KV)c.element()).getValue())).get(0);
                String jobIdPrefix = String.format((String)this.jobIdToken.get() + "_%05d", ((KV)c.element()).getKey());
                TableReference ref = BigQueryIO.fromJsonString((String)this.jsonTableRef.get(), TableReference.class);
                if (!this.singlePartition) {
                    ref.setTableId(jobIdPrefix);
                }
                this.load(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, ref, BigQueryIO.fromJsonString(this.jsonSchema == null ? null : (String)this.jsonSchema.get(), TableSchema.class), partition, this.writeDisposition, this.createDisposition);
                c.output((Object)BigQueryIO.toJsonString(ref));
                WriteTables.removeTemporaryFiles(c.getPipelineOptions(), this.tempFilePrefix, partition);
            }

            private void load(BigQueryServices.JobService jobService, String jobIdPrefix, TableReference ref, @Nullable TableSchema schema, List<String> gcsUris, WriteDisposition writeDisposition, CreateDisposition createDisposition) throws InterruptedException, IOException {
                JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(ref).setSchema(schema).setSourceUris(gcsUris).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat("NEWLINE_DELIMITED_JSON");
                String projectId = ref.getProjectId();
                Job lastFailedLoadJob = null;
                block5: for (int i = 0; i < 3; ++i) {
                    String jobId = jobIdPrefix + "-" + i;
                    JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId);
                    jobService.startLoadJob(jobRef, loadConfig);
                    Job loadJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
                    Status jobStatus = BigQueryIO.parseStatus(loadJob);
                    switch (jobStatus) {
                        case SUCCEEDED: {
                            return;
                        }
                        case UNKNOWN: {
                            throw new RuntimeException(String.format("UNKNOWN status of load job [%s]: %s.", jobId, BigQueryIO.jobToPrettyString(loadJob)));
                        }
                        case FAILED: {
                            lastFailedLoadJob = loadJob;
                            continue block5;
                        }
                        default: {
                            throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", new Object[]{jobStatus, BigQueryIO.jobToPrettyString(loadJob)}));
                        }
                    }
                }
                throw new RuntimeException(String.format("Failed to create load job with id prefix %s, reached max retries: %d, last failed load job: %s.", jobIdPrefix, 3, BigQueryIO.jobToPrettyString(lastFailedLoadJob)));
            }

            static void removeTemporaryFiles(PipelineOptions options, String tempFilePrefix, Collection<String> files) throws IOException {
                IOChannelFactory factory = IOChannelUtils.getFactory((String)tempFilePrefix);
                if (factory instanceof GcsIOChannelFactory) {
                    GcsUtil gcsUtil = new GcsUtil.GcsUtilFactory().create(options);
                    gcsUtil.remove(files);
                } else if (factory instanceof FileIOChannelFactory) {
                    for (String filename : files) {
                        LOG.debug("Removing file {}", (Object)filename);
                        boolean exists = Files.deleteIfExists(Paths.get(filename, new String[0]));
                        if (exists) continue;
                        LOG.debug("{} does not exist.", (Object)filename);
                    }
                } else {
                    throw new IOException("Unrecognized file system.");
                }
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item((String)"jobIdToken", this.jobIdToken).withLabel("Job ID Token")).addIfNotNull(DisplayData.item((String)"tempFilePrefix", (String)this.tempFilePrefix).withLabel("Temporary File Prefix")).addIfNotNull(DisplayData.item((String)"jsonTableRef", this.jsonTableRef).withLabel("Table Reference")).addIfNotNull(DisplayData.item((String)"jsonSchema", this.jsonSchema).withLabel("Table Schema"));
            }
        }

        static class WritePartition
        extends DoFn<String, KV<Long, List<String>>> {
            private final PCollectionView<Iterable<KV<String, Long>>> resultsView;
            private TupleTag<KV<Long, List<String>>> multiPartitionsTag;
            private TupleTag<KV<Long, List<String>>> singlePartitionTag;

            public WritePartition(PCollectionView<Iterable<KV<String, Long>>> resultsView, TupleTag<KV<Long, List<String>>> multiPartitionsTag, TupleTag<KV<Long, List<String>>> singlePartitionTag) {
                this.resultsView = resultsView;
                this.multiPartitionsTag = multiPartitionsTag;
                this.singlePartitionTag = singlePartitionTag;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                ArrayList results = Lists.newArrayList((Iterable)((Iterable)c.sideInput(this.resultsView)));
                if (results.isEmpty()) {
                    TableRowWriter writer = new TableRowWriter((String)c.element());
                    writer.open(UUID.randomUUID().toString());
                    results.add(writer.close());
                }
                long partitionId = 0L;
                int currNumFiles = 0;
                long currSizeBytes = 0L;
                ArrayList currResults = Lists.newArrayList();
                for (int i = 0; i < results.size(); ++i) {
                    KV fileResult = (KV)results.get(i);
                    if (currNumFiles + 1 > 10000 || currSizeBytes + (Long)fileResult.getValue() > 0xB0000000000L) {
                        c.sideOutput(this.multiPartitionsTag, (Object)KV.of((Object)(++partitionId), (Object)currResults));
                        currResults = Lists.newArrayList();
                        currNumFiles = 0;
                        currSizeBytes = 0L;
                    }
                    ++currNumFiles;
                    currSizeBytes += ((Long)fileResult.getValue()).longValue();
                    currResults.add(fileResult.getKey());
                }
                if (partitionId == 0L) {
                    c.sideOutput(this.singlePartitionTag, (Object)KV.of((Object)(++partitionId), (Object)currResults));
                } else {
                    c.sideOutput(this.multiPartitionsTag, (Object)KV.of((Object)(++partitionId), (Object)currResults));
                }
            }
        }

        static class TableRowWriter {
            private static final Coder<TableRow> CODER = TableRowJsonCoder.of();
            private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
            private final String tempFilePrefix;
            private String id;
            private String fileName;
            private WritableByteChannel channel;
            protected String mimeType = "text/plain";
            private CountingOutputStream out;

            TableRowWriter(String basename) {
                this.tempFilePrefix = basename;
            }

            public final void open(String uId) throws Exception {
                this.id = uId;
                this.fileName = this.tempFilePrefix + this.id;
                LOG.debug("Opening {}.", (Object)this.fileName);
                this.channel = IOChannelUtils.create((String)this.fileName, (String)this.mimeType);
                try {
                    this.out = new CountingOutputStream(Channels.newOutputStream(this.channel));
                    LOG.debug("Writing header to {}.", (Object)this.fileName);
                }
                catch (Exception e) {
                    try {
                        LOG.error("Writing header to {} failed, closing channel.", (Object)this.fileName);
                        this.channel.close();
                    }
                    catch (IOException closeException) {
                        LOG.error("Closing channel for {} failed", (Object)this.fileName);
                    }
                    throw e;
                }
                LOG.debug("Starting write of bundle {} to {}.", (Object)this.id, (Object)this.fileName);
            }

            public void write(TableRow value) throws Exception {
                CODER.encode((Object)value, (OutputStream)this.out, Coder.Context.OUTER);
                this.out.write(NEWLINE);
            }

            public final KV<String, Long> close() throws IOException {
                this.channel.close();
                return KV.of((Object)this.fileName, (Object)this.out.getCount());
            }
        }

        public static class Bound
        extends PTransform<PCollection<TableRow>, PDone> {
            static final int MAX_NUM_FILES = 10000;
            static final long MAX_SIZE_BYTES = 0xB0000000000L;
            static final int MAX_RETRY_JOBS = 3;
            static final int LOAD_JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
            @Nullable
            final ValueProvider<String> jsonTableRef;
            @Nullable
            final SerializableFunction<BoundedWindow, TableReference> tableRefFunction;
            @Nullable
            final ValueProvider<String> jsonSchema;
            final CreateDisposition createDisposition;
            final WriteDisposition writeDisposition;
            final boolean validate;
            @Nullable
            private BigQueryServices bigQueryServices;
            @Nullable
            @VisibleForTesting
            String stepUuid;
            @Nullable
            @VisibleForTesting
            ValueProvider<String> jobUuid;

            @Deprecated
            public Bound() {
                this(null, null, null, null, CreateDisposition.CREATE_IF_NEEDED, WriteDisposition.WRITE_EMPTY, true, null);
            }

            private Bound(String name, @Nullable ValueProvider<String> jsonTableRef, @Nullable SerializableFunction<BoundedWindow, TableReference> tableRefFunction, @Nullable ValueProvider<String> jsonSchema, CreateDisposition createDisposition, WriteDisposition writeDisposition, boolean validate, @Nullable BigQueryServices bigQueryServices) {
                super(name);
                this.jsonTableRef = jsonTableRef;
                this.tableRefFunction = tableRefFunction;
                this.jsonSchema = jsonSchema;
                this.createDisposition = (CreateDisposition)((Object)Preconditions.checkNotNull((Object)((Object)createDisposition), (Object)"createDisposition"));
                this.writeDisposition = (WriteDisposition)((Object)Preconditions.checkNotNull((Object)((Object)writeDisposition), (Object)"writeDisposition"));
                this.validate = validate;
                this.bigQueryServices = bigQueryServices;
            }

            public Bound to(String tableSpec) {
                return this.toTableRef((ValueProvider<TableReference>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableSpec), (SerializableFunction)new TableSpecToTableRef()));
            }

            public Bound to(TableReference table) {
                return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryIO.toTableSpec(table)));
            }

            public Bound to(ValueProvider<String> tableSpec) {
                return this.toTableRef((ValueProvider<TableReference>)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new TableSpecToTableRef()));
            }

            private Bound toTableRef(ValueProvider<TableReference> table) {
                return new Bound(this.name, (ValueProvider<String>)ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToJson()), this.tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound to(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
                return this.toTableReference(new TranslateTableSpecFunction(tableSpecFunction));
            }

            public Bound toTableReference(SerializableFunction<BoundedWindow, TableReference> tableRefFunction) {
                return new Bound(this.name, this.jsonTableRef, tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withSchema(TableSchema schema) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryIO.toJsonString(schema)), this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withSchema(ValueProvider<TableSchema> schema) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, (ValueProvider<String>)ValueProvider.NestedValueProvider.of(schema, (SerializableFunction)new TableSchemaToJsonSchema()), this.createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withCreateDisposition(CreateDisposition createDisposition) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, createDisposition, this.writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withWriteDisposition(WriteDisposition writeDisposition) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, this.createDisposition, writeDisposition, this.validate, this.bigQueryServices);
            }

            public Bound withoutValidation() {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, false, this.bigQueryServices);
            }

            @VisibleForTesting
            Bound withTestServices(BigQueryServices testServices) {
                return new Bound(this.name, this.jsonTableRef, this.tableRefFunction, this.jsonSchema, this.createDisposition, this.writeDisposition, this.validate, testServices);
            }

            private static void verifyTableNotExistOrEmpty(BigQueryServices.DatasetService datasetService, TableReference tableRef) {
                try {
                    if (datasetService.getTable(tableRef) != null) {
                        Preconditions.checkState((boolean)datasetService.isTableEmpty(tableRef), (String)"BigQuery table is not empty: %s.", (Object[])new Object[]{BigQueryIO.toTableSpec(tableRef)});
                    }
                }
                catch (IOException | InterruptedException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException("unable to confirm BigQuery table emptiness for table " + BigQueryIO.toTableSpec(tableRef), e);
                }
            }

            public void validate(PCollection<TableRow> input) {
                BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                Preconditions.checkState((this.jsonTableRef != null || this.tableRefFunction != null ? 1 : 0) != 0, (Object)"must set the table reference of a BigQueryIO.Write transform");
                Preconditions.checkState((this.jsonTableRef == null || this.tableRefFunction == null ? 1 : 0) != 0, (Object)"Cannot set both a table reference and a table function for a BigQueryIO.Write transform");
                Preconditions.checkArgument((this.createDisposition != CreateDisposition.CREATE_IF_NEEDED || this.jsonSchema != null ? 1 : 0) != 0, (Object)"CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
                if (this.jsonTableRef != null && this.validate) {
                    TableReference table = (TableReference)this.getTableWithDefaultProject(options).get();
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                    BigQueryIO.verifyDatasetPresence(datasetService, table);
                    if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                        BigQueryIO.verifyTablePresence(datasetService, table);
                    }
                    if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                        Bound.verifyTableNotExistOrEmpty(datasetService, table);
                    }
                }
                if (input.isBounded() == PCollection.IsBounded.UNBOUNDED || this.tableRefFunction != null) {
                    if (this.tableRefFunction != null) {
                        Preconditions.checkArgument((this.createDisposition != CreateDisposition.CREATE_NEVER ? 1 : 0) != 0, (Object)"CreateDisposition.CREATE_NEVER is not supported when using a tablespec function.");
                    }
                    if (this.jsonSchema == null) {
                        Preconditions.checkArgument((this.createDisposition == CreateDisposition.CREATE_NEVER ? 1 : 0) != 0, (Object)"CreateDisposition.CREATE_NEVER must be used if jsonSchema is null.");
                    }
                    Preconditions.checkArgument((this.writeDisposition != WriteDisposition.WRITE_TRUNCATE ? 1 : 0) != 0, (Object)"WriteDisposition.WRITE_TRUNCATE is not supported for an unbounded PCollection or when using a tablespec function.");
                } else {
                    String tempLocation = options.getTempLocation();
                    Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Write needs a GCS temp location to store temp files.");
                    if (this.bigQueryServices == null) {
                        try {
                            GcsPath.fromUri((String)tempLocation);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                        }
                    }
                }
            }

            public PDone expand(PCollection<TableRow> input) {
                String tempFilePrefix;
                Pipeline p = input.getPipeline();
                BigQueryOptions options = (BigQueryOptions)p.getOptions().as(BigQueryOptions.class);
                BigQueryServices bqServices = this.getBigQueryServices();
                if (input.isBounded() == PCollection.IsBounded.UNBOUNDED || this.tableRefFunction != null) {
                    return (PDone)input.apply((PTransform)new StreamWithDeDup(this.getTable(), this.tableRefFunction, (ValueProvider<TableSchema>)(this.jsonSchema == null ? null : ValueProvider.NestedValueProvider.of(this.jsonSchema, (SerializableFunction)new JsonSchemaToTableSchema())), this.createDisposition, bqServices));
                }
                ValueProvider<TableReference> table = this.getTableWithDefaultProject(options);
                this.stepUuid = BigQueryIO.randomUUIDString();
                this.jobUuid = ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)options.getJobName()), (SerializableFunction)new CreatePerBeamJobUuid(this.stepUuid));
                ValueProvider.NestedValueProvider jobIdToken = ValueProvider.NestedValueProvider.of(this.jobUuid, (SerializableFunction)new BeamJobUuidToBigQueryJobUuid());
                String tempLocation = options.getTempLocation();
                try {
                    IOChannelFactory factory = IOChannelUtils.getFactory((String)tempLocation);
                    tempFilePrefix = factory.resolve(factory.resolve(tempLocation, "BigQueryWriteTemp"), this.stepUuid);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to resolve BigQuery temp location in %s", tempLocation), e);
                }
                PCollection singleton = (PCollection)p.apply("Create", (PTransform)Create.of((Object[])new String[]{tempFilePrefix}));
                PCollection inputInGlobalWindow = (PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes());
                PCollection results = (PCollection)inputInGlobalWindow.apply("WriteBundles", (PTransform)ParDo.of((DoFn)new WriteBundles(tempFilePrefix)));
                TupleTag<KV<Long, List<String>>> multiPartitionsTag = new TupleTag<KV<Long, List<String>>>("multiPartitionsTag"){};
                TupleTag<KV<Long, List<String>>> singlePartitionTag = new TupleTag<KV<Long, List<String>>>("singlePartitionTag"){};
                PCollectionView resultsView = (PCollectionView)results.apply("ResultsView", (PTransform)View.asIterable());
                PCollectionTuple partitions = (PCollectionTuple)singleton.apply((PTransform)ParDo.of((DoFn)new WritePartition((PCollectionView<Iterable<KV<String, Long>>>)resultsView, multiPartitionsTag, singlePartitionTag)).withSideInputs(new PCollectionView[]{resultsView}).withOutputTags((TupleTag)multiPartitionsTag, TupleTagList.of((TupleTag)singlePartitionTag)));
                PCollection tempTables = (PCollection)((PCollection)partitions.get((TupleTag)multiPartitionsTag).apply("MultiPartitionsGroupByKey", (PTransform)GroupByKey.create())).apply("MultiPartitionsWriteTables", (PTransform)ParDo.of((DoFn)new WriteTables(false, bqServices, (ValueProvider<String>)jobIdToken, tempFilePrefix, (ValueProvider<String>)ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToJson()), this.jsonSchema, WriteDisposition.WRITE_EMPTY, CreateDisposition.CREATE_IF_NEEDED)));
                PCollectionView tempTablesView = (PCollectionView)tempTables.apply("TempTablesView", (PTransform)View.asIterable());
                singleton.apply((PTransform)ParDo.of((DoFn)new WriteRename(bqServices, (ValueProvider<String>)jobIdToken, (ValueProvider<String>)ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToJson()), this.writeDisposition, this.createDisposition, (PCollectionView<Iterable<String>>)tempTablesView)).withSideInputs(new PCollectionView[]{tempTablesView}));
                ((PCollection)partitions.get((TupleTag)singlePartitionTag).apply("SinglePartitionGroupByKey", (PTransform)GroupByKey.create())).apply("SinglePartitionWriteTables", (PTransform)ParDo.of((DoFn)new WriteTables(true, bqServices, (ValueProvider<String>)jobIdToken, tempFilePrefix, (ValueProvider<String>)ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToJson()), this.jsonSchema, this.writeDisposition, this.createDisposition)));
                return PDone.in((Pipeline)input.getPipeline());
            }

            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item((String)"table", this.jsonTableRef).withLabel("Table Reference")).addIfNotNull(DisplayData.item((String)"schema", this.jsonSchema).withLabel("Table Schema"));
                if (this.tableRefFunction != null) {
                    builder.add(DisplayData.item((String)"tableFn", this.tableRefFunction.getClass()).withLabel("Table Reference Function"));
                }
                builder.add(DisplayData.item((String)"createDisposition", (String)this.createDisposition.toString()).withLabel("Table CreateDisposition")).add(DisplayData.item((String)"writeDisposition", (String)this.writeDisposition.toString()).withLabel("Table WriteDisposition")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.validate).withLabel("Validation Enabled"), (Object)true);
            }

            public CreateDisposition getCreateDisposition() {
                return this.createDisposition;
            }

            public WriteDisposition getWriteDisposition() {
                return this.writeDisposition;
            }

            public TableSchema getSchema() {
                return BigQueryIO.fromJsonString(this.jsonSchema == null ? null : (String)this.jsonSchema.get(), TableSchema.class);
            }

            @Nullable
            private ValueProvider<TableReference> getTableWithDefaultProject(BigQueryOptions bqOptions) {
                ValueProvider<TableReference> table = this.getTable();
                if (table == null) {
                    return table;
                }
                if (!table.isAccessible()) {
                    LOG.info("Using a dynamic value for table input. This must contain a project in the table reference: {}", table);
                    return table;
                }
                if (Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    TableReference tableRef = (TableReference)table.get();
                    tableRef.setProjectId(bqOptions.getProject());
                    return ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryIO.toJsonString(tableRef)), (SerializableFunction)new JsonTableRefToTableRef());
                }
                return table;
            }

            @Nullable
            public ValueProvider<TableReference> getTable() {
                return this.jsonTableRef == null ? null : ValueProvider.NestedValueProvider.of(this.jsonTableRef, (SerializableFunction)new JsonTableRefToTableRef());
            }

            public boolean getValidate() {
                return this.validate;
            }

            private BigQueryServices getBigQueryServices() {
                if (this.bigQueryServices == null) {
                    this.bigQueryServices = new BigQueryServicesImpl();
                }
                return this.bigQueryServices;
            }

            private static class WriteBundles
            extends DoFn<TableRow, KV<String, Long>> {
                private transient TableRowWriter writer = null;
                private final String tempFilePrefix;

                WriteBundles(String tempFilePrefix) {
                    this.tempFilePrefix = tempFilePrefix;
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) throws Exception {
                    if (this.writer == null) {
                        this.writer = new TableRowWriter(this.tempFilePrefix);
                        this.writer.open(UUID.randomUUID().toString());
                        LOG.debug("Done opening writer {}", (Object)this.writer);
                    }
                    try {
                        this.writer.write((TableRow)c.element());
                    }
                    catch (Exception e) {
                        try {
                            this.writer.close();
                        }
                        catch (Exception closeException) {
                            e.addSuppressed(closeException);
                        }
                        throw e;
                    }
                }

                @DoFn.FinishBundle
                public void finishBundle(DoFn.Context c) throws Exception {
                    if (this.writer != null) {
                        c.output(this.writer.close());
                        this.writer = null;
                    }
                }

                public void populateDisplayData(DisplayData.Builder builder) {
                    super.populateDisplayData(builder);
                    builder.addIfNotNull(DisplayData.item((String)"tempFilePrefix", (String)this.tempFilePrefix).withLabel("Temporary File Prefix"));
                }
            }

            private static class TranslateTableSpecFunction
            implements SerializableFunction<BoundedWindow, TableReference> {
                private SerializableFunction<BoundedWindow, String> tableSpecFunction;

                TranslateTableSpecFunction(SerializableFunction<BoundedWindow, String> tableSpecFunction) {
                    this.tableSpecFunction = tableSpecFunction;
                }

                public TableReference apply(BoundedWindow value) {
                    return BigQueryIO.parseTableSpec((String)this.tableSpecFunction.apply((Object)value));
                }
            }
        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }
    }

    @VisibleForTesting
    static class TransformingSource<T, V>
    extends BoundedSource<V> {
        private final BoundedSource<T> boundedSource;
        private final SerializableFunction<T, V> function;
        private final Coder<V> outputCoder;

        TransformingSource(BoundedSource<T> boundedSource, SerializableFunction<T, V> function, Coder<V> outputCoder) {
            this.boundedSource = (BoundedSource)Preconditions.checkNotNull(boundedSource, (Object)"boundedSource");
            this.function = (SerializableFunction)Preconditions.checkNotNull(function, (Object)"function");
            this.outputCoder = (Coder)Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
        }

        public List<? extends BoundedSource<V>> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            return Lists.transform((List)this.boundedSource.splitIntoBundles(desiredBundleSizeBytes, options), (Function)new Function<BoundedSource<T>, BoundedSource<V>>(){

                public BoundedSource<V> apply(BoundedSource<T> input) {
                    return new TransformingSource(input, TransformingSource.this.function, TransformingSource.this.outputCoder);
                }
            });
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            return this.boundedSource.getEstimatedSizeBytes(options);
        }

        public BoundedSource.BoundedReader<V> createReader(PipelineOptions options) throws IOException {
            return new TransformingReader(this.boundedSource.createReader(options));
        }

        public void validate() {
            this.boundedSource.validate();
        }

        public Coder<V> getDefaultOutputCoder() {
            return this.outputCoder;
        }

        private class TransformingReader
        extends BoundedSource.BoundedReader<V> {
            private final BoundedSource.BoundedReader<T> boundedReader;

            private TransformingReader(BoundedSource.BoundedReader<T> boundedReader) {
                this.boundedReader = (BoundedSource.BoundedReader)Preconditions.checkNotNull(boundedReader, (Object)"boundedReader");
            }

            public synchronized BoundedSource<V> getCurrentSource() {
                return new TransformingSource(this.boundedReader.getCurrentSource(), TransformingSource.this.function, TransformingSource.this.outputCoder);
            }

            public boolean start() throws IOException {
                return this.boundedReader.start();
            }

            public boolean advance() throws IOException {
                return this.boundedReader.advance();
            }

            public V getCurrent() throws NoSuchElementException {
                Object current = this.boundedReader.getCurrent();
                return TransformingSource.this.function.apply(current);
            }

            public void close() throws IOException {
                this.boundedReader.close();
            }

            public synchronized BoundedSource<V> splitAtFraction(double fraction) {
                BoundedSource split = this.boundedReader.splitAtFraction(fraction);
                return split == null ? null : new TransformingSource(split, TransformingSource.this.function, TransformingSource.this.outputCoder);
            }

            public Double getFractionConsumed() {
                return this.boundedReader.getFractionConsumed();
            }

            public Instant getCurrentTimestamp() throws NoSuchElementException {
                return this.boundedReader.getCurrentTimestamp();
            }
        }
    }

    private static abstract class BigQuerySourceBase
    extends BoundedSource<TableRow> {
        private static final int MAX_FILES_VERIFY_RETRIES = 9;
        protected static final int JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
        private static final Duration INITIAL_FILES_VERIFY_BACKOFF = Duration.standardSeconds((long)1L);
        protected final ValueProvider<String> jobIdToken;
        protected final String extractDestinationDir;
        protected final BigQueryServices bqServices;
        protected final ValueProvider<String> executingProject;

        private BigQuerySourceBase(ValueProvider<String> jobIdToken, String extractDestinationDir, BigQueryServices bqServices, ValueProvider<String> executingProject) {
            this.jobIdToken = (ValueProvider)Preconditions.checkNotNull(jobIdToken, (Object)"jobIdToken");
            this.extractDestinationDir = (String)Preconditions.checkNotNull((Object)extractDestinationDir, (Object)"extractDestinationDir");
            this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
            this.executingProject = (ValueProvider)Preconditions.checkNotNull(executingProject, (Object)"executingProject");
        }

        public List<BoundedSource<TableRow>> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReference tableToExtract = this.getTableToExtract(bqOptions);
            BigQueryServices.JobService jobService = this.bqServices.getJobService(bqOptions);
            String extractJobId = BigQueryIO.getExtractJobId((ValueProvider<String>)this.jobIdToken);
            List<String> tempFiles = this.executeExtract(extractJobId, tableToExtract, jobService);
            TableSchema tableSchema = this.bqServices.getDatasetService(bqOptions).getTable(tableToExtract).getSchema();
            this.cleanupTempResource(bqOptions);
            return this.createSources(tempFiles, tableSchema);
        }

        protected abstract TableReference getTableToExtract(BigQueryOptions var1) throws Exception;

        protected abstract void cleanupTempResource(BigQueryOptions var1) throws Exception;

        public void validate() {
        }

        public Coder<TableRow> getDefaultOutputCoder() {
            return TableRowJsonCoder.of();
        }

        private List<String> executeExtract(String jobId, TableReference table, BigQueryServices.JobService jobService) throws InterruptedException, IOException {
            JobReference jobRef = new JobReference().setProjectId((String)this.executingProject.get()).setJobId(jobId);
            String destinationUri = BigQueryIO.getExtractDestinationUri(this.extractDestinationDir);
            JobConfigurationExtract extract = new JobConfigurationExtract().setSourceTable(table).setDestinationFormat("AVRO").setDestinationUris((List)ImmutableList.of((Object)destinationUri));
            LOG.info("Starting BigQuery extract job: {}", (Object)jobId);
            jobService.startExtractJob(jobRef, extract);
            Job extractJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            if (BigQueryIO.parseStatus(extractJob) != Status.SUCCEEDED) {
                throw new IOException(String.format("Extract job %s failed, status: %s.", extractJob.getJobReference().getJobId(), BigQueryIO.statusToPrettyString(extractJob.getStatus())));
            }
            List tempFiles = BigQueryIO.getExtractFilePaths(this.extractDestinationDir, extractJob);
            return ImmutableList.copyOf((Collection)tempFiles);
        }

        private List<BoundedSource<TableRow>> createSources(List<String> files, TableSchema tableSchema) throws IOException, InterruptedException {
            final String jsonSchema = JSON_FACTORY.toString((Object)tableSchema);
            SerializableFunction<GenericRecord, TableRow> function = new SerializableFunction<GenericRecord, TableRow>(){

                public TableRow apply(GenericRecord input) {
                    return BigQueryAvroUtils.convertGenericRecordToTableRow(input, BigQueryIO.fromJsonString(jsonSchema, TableSchema.class));
                }
            };
            ArrayList avroSources = Lists.newArrayList();
            for (String fileName : files) {
                avroSources.add(new TransformingSource<GenericRecord, TableRow>((BoundedSource<GenericRecord>)AvroSource.from((String)fileName), function, this.getDefaultOutputCoder()));
            }
            return ImmutableList.copyOf((Collection)avroSources);
        }

        protected static class BigQueryReader
        extends BoundedSource.BoundedReader<TableRow> {
            private final BigQuerySourceBase source;
            private final BigQueryServices.BigQueryJsonReader reader;

            private BigQueryReader(BigQuerySourceBase source, BigQueryServices.BigQueryJsonReader reader) {
                this.source = source;
                this.reader = reader;
            }

            public BoundedSource<TableRow> getCurrentSource() {
                return this.source;
            }

            public boolean start() throws IOException {
                return this.reader.start();
            }

            public boolean advance() throws IOException {
                return this.reader.advance();
            }

            public TableRow getCurrent() throws NoSuchElementException {
                return this.reader.getCurrent();
            }

            public void close() throws IOException {
                this.reader.close();
            }
        }
    }

    @VisibleForTesting
    static class BigQueryQuerySource
    extends BigQuerySourceBase {
        private final ValueProvider<String> query;
        private final ValueProvider<String> jsonQueryTempTable;
        private final Boolean flattenResults;
        private final Boolean useLegacySql;
        private transient AtomicReference<JobStatistics> dryRunJobStats;

        static BigQueryQuerySource create(ValueProvider<String> jobIdToken, ValueProvider<String> query, ValueProvider<TableReference> queryTempTableRef, Boolean flattenResults, Boolean useLegacySql, String extractDestinationDir, BigQueryServices bqServices) {
            return new BigQueryQuerySource(jobIdToken, query, queryTempTableRef, flattenResults, useLegacySql, extractDestinationDir, bqServices);
        }

        private BigQueryQuerySource(ValueProvider<String> jobIdToken, ValueProvider<String> query, ValueProvider<TableReference> queryTempTableRef, Boolean flattenResults, Boolean useLegacySql, String extractDestinationDir, BigQueryServices bqServices) {
            super(jobIdToken, extractDestinationDir, bqServices, (ValueProvider)ValueProvider.NestedValueProvider.of((ValueProvider)((ValueProvider)Preconditions.checkNotNull(queryTempTableRef, (Object)"queryTempTableRef")), (SerializableFunction)new TableRefToProjectId()));
            this.query = (ValueProvider)Preconditions.checkNotNull(query, (Object)"query");
            this.jsonQueryTempTable = ValueProvider.NestedValueProvider.of(queryTempTableRef, (SerializableFunction)new TableRefToJson());
            this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
            this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
            this.dryRunJobStats = new AtomicReference();
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            return this.dryRunQueryIfNeeded(bqOptions).getTotalBytesProcessed();
        }

        public BoundedSource.BoundedReader<TableRow> createReader(PipelineOptions options) throws IOException {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            return new BigQuerySourceBase.BigQueryReader(this, this.bqServices.getReaderFromQuery(bqOptions, (String)this.query.get(), (String)this.executingProject.get(), this.flattenResults, this.useLegacySql));
        }

        @Override
        protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException, InterruptedException {
            String location = null;
            List referencedTables = this.dryRunQueryIfNeeded(bqOptions).getQuery().getReferencedTables();
            BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
            if (referencedTables != null && !referencedTables.isEmpty()) {
                TableReference queryTable = (TableReference)referencedTables.get(0);
                location = tableService.getTable(queryTable).getLocation();
            }
            TableReference tableToExtract = (TableReference)JSON_FACTORY.fromString((String)this.jsonQueryTempTable.get(), TableReference.class);
            tableService.createDataset(tableToExtract.getProjectId(), tableToExtract.getDatasetId(), location, "Dataset for BigQuery query job temporary table");
            String queryJobId = (String)this.jobIdToken.get() + "-query";
            this.executeQuery((String)this.executingProject.get(), queryJobId, tableToExtract, this.bqServices.getJobService(bqOptions));
            return tableToExtract;
        }

        @Override
        protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
            Preconditions.checkState((boolean)this.jsonQueryTempTable.isAccessible());
            TableReference tableToRemove = (TableReference)JSON_FACTORY.fromString((String)this.jsonQueryTempTable.get(), TableReference.class);
            BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
            tableService.deleteTable(tableToRemove);
            tableService.deleteDataset(tableToRemove.getProjectId(), tableToRemove.getDatasetId());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"query", this.query));
        }

        private synchronized JobStatistics dryRunQueryIfNeeded(BigQueryOptions bqOptions) throws InterruptedException, IOException {
            if (this.dryRunJobStats.get() == null) {
                JobStatistics jobStats = this.bqServices.getJobService(bqOptions).dryRunQuery((String)this.executingProject.get(), this.createBasicQueryConfig());
                this.dryRunJobStats.compareAndSet(null, jobStats);
            }
            return this.dryRunJobStats.get();
        }

        private void executeQuery(String executingProject, String jobId, TableReference destinationTable, BigQueryServices.JobService jobService) throws IOException, InterruptedException {
            JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(jobId);
            JobConfigurationQuery queryConfig = this.createBasicQueryConfig().setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition("CREATE_IF_NEEDED").setDestinationTable(destinationTable).setPriority("BATCH").setWriteDisposition("WRITE_EMPTY");
            jobService.startQueryJob(jobRef, queryConfig);
            Job job = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            if (BigQueryIO.parseStatus(job) != Status.SUCCEEDED) {
                throw new IOException(String.format("Query job %s failed, status: %s.", jobId, BigQueryIO.statusToPrettyString(job.getStatus())));
            }
        }

        private JobConfigurationQuery createBasicQueryConfig() {
            return new JobConfigurationQuery().setQuery((String)this.query.get()).setFlattenResults(this.flattenResults).setUseLegacySql(this.useLegacySql);
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.dryRunJobStats = new AtomicReference();
        }
    }

    @VisibleForTesting
    static class BigQueryTableSource
    extends BigQuerySourceBase {
        private final ValueProvider<String> jsonTable;
        private final AtomicReference<Long> tableSizeBytes;

        static BigQueryTableSource create(ValueProvider<String> jobIdToken, ValueProvider<TableReference> table, String extractDestinationDir, BigQueryServices bqServices, ValueProvider<String> executingProject) {
            return new BigQueryTableSource(jobIdToken, table, extractDestinationDir, bqServices, executingProject);
        }

        private BigQueryTableSource(ValueProvider<String> jobIdToken, ValueProvider<TableReference> table, String extractDestinationDir, BigQueryServices bqServices, ValueProvider<String> executingProject) {
            super(jobIdToken, extractDestinationDir, bqServices, executingProject);
            this.jsonTable = ValueProvider.NestedValueProvider.of((ValueProvider)((ValueProvider)Preconditions.checkNotNull(table, (Object)"table")), (SerializableFunction)new TableRefToJson());
            this.tableSizeBytes = new AtomicReference();
        }

        @Override
        protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException {
            Preconditions.checkState((boolean)this.jsonTable.isAccessible());
            return (TableReference)JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class);
        }

        public BoundedSource.BoundedReader<TableRow> createReader(PipelineOptions options) throws IOException {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            Preconditions.checkState((boolean)this.jsonTable.isAccessible());
            TableReference tableRef = (TableReference)JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class);
            return new BigQuerySourceBase.BigQueryReader(this, this.bqServices.getReaderFromTable(bqOptions, tableRef));
        }

        public synchronized long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            if (this.tableSizeBytes.get() == null) {
                TableReference table = (TableReference)JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class);
                Long numBytes = this.bqServices.getDatasetService((BigQueryOptions)options.as(BigQueryOptions.class)).getTable(table).getNumBytes();
                this.tableSizeBytes.compareAndSet(null, numBytes);
            }
            return this.tableSizeBytes.get();
        }

        @Override
        protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"table", this.jsonTable));
        }
    }

    @VisibleForTesting
    static class PassThroughThenCleanup<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private CleanupOperation cleanupOperation;

        PassThroughThenCleanup(CleanupOperation cleanupOperation) {
            this.cleanupOperation = cleanupOperation;
        }

        public PCollection<T> expand(PCollection<T> input) {
            TupleTag mainOutput = new TupleTag();
            TupleTag cleanupSignal = new TupleTag();
            PCollectionTuple outputs = (PCollectionTuple)input.apply((PTransform)ParDo.of(new IdentityFn()).withOutputTags(mainOutput, TupleTagList.of((TupleTag)cleanupSignal)));
            PCollectionView cleanupSignalView = (PCollectionView)outputs.get(cleanupSignal).setCoder((Coder)VoidCoder.of()).apply((PTransform)View.asSingleton().withDefaultValue(null));
            ((PCollection)input.getPipeline().apply("Create(CleanupOperation)", (PTransform)Create.of((Object[])new CleanupOperation[]{this.cleanupOperation}))).apply("Cleanup", (PTransform)ParDo.of((DoFn)new DoFn<CleanupOperation, Void>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) throws Exception {
                    ((CleanupOperation)c.element()).cleanup(c.getPipelineOptions());
                }
            }).withSideInputs(new PCollectionView[]{cleanupSignalView}));
            return outputs.get(mainOutput);
        }

        static abstract class CleanupOperation
        implements Serializable {
            CleanupOperation() {
            }

            abstract void cleanup(PipelineOptions var1) throws Exception;
        }

        private static class IdentityFn<T>
        extends DoFn<T, T> {
            private IdentityFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output(c.element());
            }
        }
    }

    public static class Read {
        public static Bound from(String tableSpec) {
            return new Bound().from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public static Bound from(ValueProvider<String> tableSpec) {
            return new Bound().from(tableSpec);
        }

        public static Bound fromQuery(String query) {
            return new Bound().fromQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public static Bound fromQuery(ValueProvider<String> query) {
            return new Bound().fromQuery(query);
        }

        public static Bound from(TableReference table) {
            return new Bound().from(table);
        }

        public static Bound withoutValidation() {
            return new Bound().withoutValidation();
        }

        private Read() {
        }

        public static class Bound
        extends PTransform<PBegin, PCollection<TableRow>> {
            @Nullable
            final ValueProvider<String> jsonTableRef;
            @Nullable
            final ValueProvider<String> query;
            final boolean validate;
            @Nullable
            final Boolean flattenResults;
            @Nullable
            final Boolean useLegacySql;
            @Nullable
            BigQueryServices bigQueryServices;
            @Nullable
            @VisibleForTesting
            String stepUuid;
            @Nullable
            @VisibleForTesting
            ValueProvider<String> jobUuid;
            private static final String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";

            private Bound() {
                this(null, null, null, true, null, null, null);
            }

            private Bound(String name, @Nullable ValueProvider<String> query, @Nullable ValueProvider<String> jsonTableRef, boolean validate, @Nullable Boolean flattenResults, @Nullable Boolean useLegacySql, @Nullable BigQueryServices bigQueryServices) {
                super(name);
                this.jsonTableRef = jsonTableRef;
                this.query = query;
                this.validate = validate;
                this.flattenResults = flattenResults;
                this.useLegacySql = useLegacySql;
                this.bigQueryServices = bigQueryServices;
            }

            public Bound from(ValueProvider<String> tableSpec) {
                return new Bound(this.name, this.query, (ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new TableSpecToTableRef()), (SerializableFunction)new TableRefToJson()), this.validate, this.flattenResults, this.useLegacySql, this.bigQueryServices);
            }

            public Bound from(TableReference table) {
                return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryIO.toTableSpec(table)));
            }

            public Bound fromQuery(String query) {
                return this.fromQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
            }

            public Bound fromQuery(ValueProvider<String> query) {
                return new Bound(this.name, query, this.jsonTableRef, this.validate, (Boolean)MoreObjects.firstNonNull((Object)this.flattenResults, (Object)Boolean.TRUE), (Boolean)MoreObjects.firstNonNull((Object)this.useLegacySql, (Object)Boolean.TRUE), this.bigQueryServices);
            }

            public Bound withoutValidation() {
                return new Bound(this.name, this.query, this.jsonTableRef, false, this.flattenResults, this.useLegacySql, this.bigQueryServices);
            }

            public Bound withoutResultFlattening() {
                return new Bound(this.name, this.query, this.jsonTableRef, this.validate, false, this.useLegacySql, this.bigQueryServices);
            }

            public Bound usingStandardSql() {
                return new Bound(this.name, this.query, this.jsonTableRef, this.validate, this.flattenResults, false, this.bigQueryServices);
            }

            @VisibleForTesting
            Bound withTestServices(BigQueryServices testServices) {
                return new Bound(this.name, this.query, this.jsonTableRef, this.validate, this.flattenResults, this.useLegacySql, testServices);
            }

            public void validate(PBegin input) {
                ValueProvider<TableReference> table;
                BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                String tempLocation = bqOptions.getTempLocation();
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Read needs a GCS temp location to store temp files.");
                if (this.bigQueryServices == null) {
                    try {
                        GcsPath.fromUri((String)tempLocation);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                    }
                }
                Preconditions.checkState(((table = this.getTableWithDefaultProject(bqOptions)) == null || this.query == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: table reference and query may not both be set");
                Preconditions.checkState((table != null || this.query != null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: one of table reference and query must be set");
                if (table != null) {
                    Preconditions.checkState((this.flattenResults == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
                    Preconditions.checkState((this.useLegacySql == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
                } else {
                    Preconditions.checkState((this.flattenResults != null ? 1 : 0) != 0, (Object)"flattenResults should not be null if query is set");
                    Preconditions.checkState((this.useLegacySql != null ? 1 : 0) != 0, (Object)"useLegacySql should not be null if query is set");
                }
                if (this.validate && table != null) {
                    Preconditions.checkState((boolean)table.isAccessible(), (Object)"Cannot call validate if table is dynamically set.");
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(bqOptions);
                    BigQueryIO.verifyDatasetPresence(datasetService, (TableReference)table.get());
                    BigQueryIO.verifyTablePresence(datasetService, (TableReference)table.get());
                } else if (this.validate && this.query != null) {
                    Preconditions.checkState((boolean)this.query.isAccessible(), (Object)"Cannot call validate if query is dynamically set.");
                    BigQueryServices.JobService jobService = this.getBigQueryServices().getJobService(bqOptions);
                    try {
                        jobService.dryRunQuery(bqOptions.getProject(), new JobConfigurationQuery().setQuery((String)this.query.get()).setFlattenResults(this.flattenResults).setUseLegacySql(this.useLegacySql));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, this.query.get()), e);
                    }
                }
            }

            public PCollection<TableRow> expand(PBegin input) {
                BigQuerySourceBase source;
                String extractDestinationDir;
                this.stepUuid = BigQueryIO.randomUUIDString();
                BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                this.jobUuid = ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)bqOptions.getJobName()), (SerializableFunction)new CreatePerBeamJobUuid(this.stepUuid));
                ValueProvider.NestedValueProvider jobIdToken = ValueProvider.NestedValueProvider.of(this.jobUuid, (SerializableFunction)new BeamJobUuidToBigQueryJobUuid());
                BigQueryServices bqServices = this.getBigQueryServices();
                String tempLocation = bqOptions.getTempLocation();
                try {
                    IOChannelFactory factory = IOChannelUtils.getFactory((String)tempLocation);
                    extractDestinationDir = factory.resolve(tempLocation, this.stepUuid);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to resolve extract destination directory in %s", tempLocation));
                }
                final String executingProject = bqOptions.getProject();
                if (!(this.query == null || this.query.isAccessible() && Strings.isNullOrEmpty((String)((String)this.query.get())))) {
                    source = BigQueryQuerySource.create((ValueProvider<String>)jobIdToken, this.query, (ValueProvider<TableReference>)ValueProvider.NestedValueProvider.of(this.jobUuid, (SerializableFunction)new CreateJsonTableRefFromUuid(executingProject)), this.flattenResults, this.useLegacySql, extractDestinationDir, bqServices);
                } else {
                    ValueProvider<TableReference> inputTable = this.getTableWithDefaultProject(bqOptions);
                    source = BigQueryTableSource.create((ValueProvider<String>)jobIdToken, inputTable, extractDestinationDir, bqServices, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)executingProject));
                }
                PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation((ValueProvider)jobIdToken, bqServices, extractDestinationDir){
                    final /* synthetic */ ValueProvider val$jobIdToken;
                    final /* synthetic */ BigQueryServices val$bqServices;
                    final /* synthetic */ String val$extractDestinationDir;
                    {
                        this.val$jobIdToken = valueProvider;
                        this.val$bqServices = bigQueryServices;
                        this.val$extractDestinationDir = string2;
                    }

                    @Override
                    void cleanup(PipelineOptions options) throws Exception {
                        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                        JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(BigQueryIO.getExtractJobId((ValueProvider<String>)this.val$jobIdToken));
                        Job extractJob = this.val$bqServices.getJobService(bqOptions).getJob(jobRef);
                        Collection extractFiles = null;
                        if (extractJob != null) {
                            extractFiles = BigQueryIO.getExtractFilePaths(this.val$extractDestinationDir, extractJob);
                        } else {
                            IOChannelFactory factory = IOChannelUtils.getFactory((String)this.val$extractDestinationDir);
                            Collection dirMatch = factory.match(this.val$extractDestinationDir);
                            if (!dirMatch.isEmpty()) {
                                extractFiles = factory.match(factory.resolve(this.val$extractDestinationDir, "*"));
                            }
                        }
                        if (extractFiles != null && !extractFiles.isEmpty()) {
                            new GcsUtil.GcsUtilFactory().create(options).remove(extractFiles);
                        }
                    }
                };
                return (PCollection)((PCollection)input.getPipeline().apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)source))).setCoder(this.getDefaultOutputCoder()).apply(new PassThroughThenCleanup(cleanupOperation));
            }

            protected Coder<TableRow> getDefaultOutputCoder() {
                return TableRowJsonCoder.of();
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item((String)"table", (ValueProvider)BigQueryIO.displayTable((ValueProvider<TableReference>)this.getTableProvider())).withLabel("Table")).addIfNotNull(DisplayData.item((String)"query", this.query).withLabel("Query")).addIfNotNull(DisplayData.item((String)"flattenResults", (Boolean)this.flattenResults).withLabel("Flatten Query Results")).addIfNotNull(DisplayData.item((String)"useLegacySql", (Boolean)this.useLegacySql).withLabel("Use Legacy SQL Dialect")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.validate).withLabel("Validation Enabled"), (Object)true);
            }

            @Nullable
            private ValueProvider<TableReference> getTableWithDefaultProject(BigQueryOptions bqOptions) {
                ValueProvider<TableReference> table = this.getTableProvider();
                if (table == null) {
                    return table;
                }
                if (!table.isAccessible()) {
                    LOG.info("Using a dynamic value for table input. This must contain a project in the table reference: {}", table);
                    return table;
                }
                if (Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    TableReference tableRef = (TableReference)table.get();
                    tableRef.setProjectId(bqOptions.getProject());
                    return ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryIO.toJsonString(tableRef)), (SerializableFunction)new JsonTableRefToTableRef());
                }
                return table;
            }

            @Nullable
            public ValueProvider<TableReference> getTableProvider() {
                return this.jsonTableRef == null ? null : ValueProvider.NestedValueProvider.of(this.jsonTableRef, (SerializableFunction)new JsonTableRefToTableRef());
            }

            @Nullable
            public TableReference getTable() {
                ValueProvider<TableReference> provider = this.getTableProvider();
                return provider == null ? null : (TableReference)provider.get();
            }

            @Nullable
            public String getQuery() {
                return this.query == null ? null : (String)this.query.get();
            }

            @Nullable
            public ValueProvider<String> getQueryProvider() {
                return this.query;
            }

            public boolean getValidate() {
                return this.validate;
            }

            public Boolean getFlattenResults() {
                return this.flattenResults;
            }

            @Nullable
            public Boolean getUseLegacySql() {
                return this.useLegacySql;
            }

            private BigQueryServices getBigQueryServices() {
                if (this.bigQueryServices == null) {
                    this.bigQueryServices = new BigQueryServicesImpl();
                }
                return this.bigQueryServices;
            }
        }
    }

    @VisibleForTesting
    static class CreateJsonTableRefFromUuid
    implements SerializableFunction<String, TableReference> {
        private final String executingProject;

        private CreateJsonTableRefFromUuid(String executingProject) {
            this.executingProject = executingProject;
        }

        public TableReference apply(String jobUuid) {
            String queryTempDatasetId = "temp_dataset_" + jobUuid;
            String queryTempTableId = "temp_table_" + jobUuid;
            TableReference queryTempTableRef = new TableReference().setProjectId(this.executingProject).setDatasetId(queryTempDatasetId).setTableId(queryTempTableId);
            return queryTempTableRef;
        }
    }

    @VisibleForTesting
    static class CreatePerBeamJobUuid
    implements SerializableFunction<String, String> {
        private final String stepUuid;

        private CreatePerBeamJobUuid(String stepUuid) {
            this.stepUuid = stepUuid;
        }

        public String apply(String jobUuid) {
            return this.stepUuid + "_" + jobUuid.replaceAll("-", "");
        }
    }

    @VisibleForTesting
    static class BeamJobUuidToBigQueryJobUuid
    implements SerializableFunction<String, String> {
        BeamJobUuidToBigQueryJobUuid() {
        }

        public String apply(String from) {
            return "beam_job_" + from;
        }
    }

    @VisibleForTesting
    static class TableSpecToTableRef
    implements SerializableFunction<String, TableReference> {
        TableSpecToTableRef() {
        }

        public TableReference apply(String from) {
            return BigQueryIO.parseTableSpec(from);
        }
    }

    private static class TableRefToProjectId
    implements SerializableFunction<TableReference, String> {
        private TableRefToProjectId() {
        }

        public String apply(TableReference from) {
            return from.getProjectId();
        }
    }

    private static class TableRefToJson
    implements SerializableFunction<TableReference, String> {
        private TableRefToJson() {
        }

        public String apply(TableReference from) {
            return BigQueryIO.toJsonString(from);
        }
    }

    private static class TableRefToTableSpec
    implements SerializableFunction<TableReference, String> {
        private TableRefToTableSpec() {
        }

        public String apply(TableReference from) {
            return BigQueryIO.toTableSpec(from);
        }
    }

    private static class JsonTableRefToTableRef
    implements SerializableFunction<String, TableReference> {
        private JsonTableRefToTableRef() {
        }

        public TableReference apply(String from) {
            return BigQueryIO.fromJsonString(from, TableReference.class);
        }
    }

    private static class TableSchemaToJsonSchema
    implements SerializableFunction<TableSchema, String> {
        private TableSchemaToJsonSchema() {
        }

        public String apply(TableSchema from) {
            return BigQueryIO.toJsonString(from);
        }
    }

    @VisibleForTesting
    static class JsonSchemaToTableSchema
    implements SerializableFunction<String, TableSchema> {
        JsonSchemaToTableSchema() {
        }

        public TableSchema apply(String from) {
            return BigQueryIO.fromJsonString(from, TableSchema.class);
        }
    }
}

