/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.options.BigQueryOptions;

interface BigQueryServices
extends Serializable {
    public JobService getJobService(BigQueryOptions var1);

    public DatasetService getDatasetService(BigQueryOptions var1);

    public BigQueryJsonReader getReaderFromTable(BigQueryOptions var1, TableReference var2);

    public BigQueryJsonReader getReaderFromQuery(BigQueryOptions var1, String var2, String var3, @Nullable Boolean var4, @Nullable Boolean var5);

    public static interface BigQueryJsonReader {
        public boolean start() throws IOException;

        public boolean advance() throws IOException;

        public TableRow getCurrent() throws NoSuchElementException;

        public void close() throws IOException;
    }

    public static interface DatasetService {
        public Table getTable(String var1, String var2, String var3) throws InterruptedException, IOException;

        public void createTable(Table var1) throws InterruptedException, IOException;

        public void deleteTable(String var1, String var2, String var3) throws IOException, InterruptedException;

        public boolean isTableEmpty(String var1, String var2, String var3) throws IOException, InterruptedException;

        public Dataset getDataset(String var1, String var2) throws IOException, InterruptedException;

        public void createDataset(String var1, String var2, @Nullable String var3, @Nullable String var4) throws IOException, InterruptedException;

        public void deleteDataset(String var1, String var2) throws IOException, InterruptedException;

        public long insertAll(TableReference var1, List<TableRow> var2, @Nullable List<String> var3) throws IOException, InterruptedException;
    }

    public static interface JobService {
        public void startLoadJob(JobReference var1, JobConfigurationLoad var2) throws InterruptedException, IOException;

        public void startExtractJob(JobReference var1, JobConfigurationExtract var2) throws InterruptedException, IOException;

        public void startQueryJob(JobReference var1, JobConfigurationQuery var2) throws IOException, InterruptedException;

        public void startCopyJob(JobReference var1, JobConfigurationTableCopy var2) throws IOException, InterruptedException;

        public Job pollJob(JobReference var1, int var2) throws InterruptedException, IOException;

        public JobStatistics dryRunQuery(String var1, JobConfigurationQuery var2) throws InterruptedException, IOException;

        public Job getJob(JobReference var1) throws IOException, InterruptedException;
    }
}

