/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.util.List;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.http.Header;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_ElasticsearchIO_ConnectionConfiguration
extends ElasticsearchIO.ConnectionConfiguration {
    private final List<String> addresses;
    private final @Nullable String username;
    private final @Nullable String password;
    private final @Nullable String apiKey;
    private final @Nullable String bearerToken;
    private final @Nullable List<Header> defaultHeaders;
    private final @Nullable String keystorePath;
    private final @Nullable String keystorePassword;
    private final @Nullable String pathPrefix;
    private final String index;
    private final @Nullable String type;
    private final @Nullable Integer socketTimeout;
    private final @Nullable Integer connectTimeout;
    private final boolean trustSelfSignedCerts;
    private final boolean compressionEnabled;

    private AutoValue_ElasticsearchIO_ConnectionConfiguration(List<String> addresses, @Nullable String username, @Nullable String password, @Nullable String apiKey, @Nullable String bearerToken, @Nullable List<Header> defaultHeaders, @Nullable String keystorePath, @Nullable String keystorePassword, @Nullable String pathPrefix, String index, @Nullable String type, @Nullable Integer socketTimeout, @Nullable Integer connectTimeout, boolean trustSelfSignedCerts, boolean compressionEnabled) {
        this.addresses = addresses;
        this.username = username;
        this.password = password;
        this.apiKey = apiKey;
        this.bearerToken = bearerToken;
        this.defaultHeaders = defaultHeaders;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.pathPrefix = pathPrefix;
        this.index = index;
        this.type = type;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
        this.trustSelfSignedCerts = trustSelfSignedCerts;
        this.compressionEnabled = compressionEnabled;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public @Nullable String getUsername() {
        return this.username;
    }

    @Override
    public @Nullable String getPassword() {
        return this.password;
    }

    @Override
    public @Nullable String getApiKey() {
        return this.apiKey;
    }

    @Override
    public @Nullable String getBearerToken() {
        return this.bearerToken;
    }

    @Override
    public @Nullable List<Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public @Nullable String getKeystorePath() {
        return this.keystorePath;
    }

    @Override
    public @Nullable String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public @Nullable String getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public @Nullable String getType() {
        return this.type;
    }

    @Override
    public @Nullable Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public @Nullable Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public boolean isTrustSelfSignedCerts() {
        return this.trustSelfSignedCerts;
    }

    @Override
    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public String toString() {
        return "ConnectionConfiguration{addresses=" + this.addresses + ", username=" + this.username + ", password=" + this.password + ", apiKey=" + this.apiKey + ", bearerToken=" + this.bearerToken + ", defaultHeaders=" + this.defaultHeaders + ", keystorePath=" + this.keystorePath + ", keystorePassword=" + this.keystorePassword + ", pathPrefix=" + this.pathPrefix + ", index=" + this.index + ", type=" + this.type + ", socketTimeout=" + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", trustSelfSignedCerts=" + this.trustSelfSignedCerts + ", compressionEnabled=" + this.compressionEnabled + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.ConnectionConfiguration) {
            ElasticsearchIO.ConnectionConfiguration that = (ElasticsearchIO.ConnectionConfiguration)o;
            return this.addresses.equals(that.getAddresses()) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && (this.apiKey == null ? that.getApiKey() == null : this.apiKey.equals(that.getApiKey())) && (this.bearerToken == null ? that.getBearerToken() == null : this.bearerToken.equals(that.getBearerToken())) && (this.defaultHeaders == null ? that.getDefaultHeaders() == null : this.defaultHeaders.equals(that.getDefaultHeaders())) && (this.keystorePath == null ? that.getKeystorePath() == null : this.keystorePath.equals(that.getKeystorePath())) && (this.keystorePassword == null ? that.getKeystorePassword() == null : this.keystorePassword.equals(that.getKeystorePassword())) && (this.pathPrefix == null ? that.getPathPrefix() == null : this.pathPrefix.equals(that.getPathPrefix())) && this.index.equals(that.getIndex()) && (this.type == null ? that.getType() == null : this.type.equals(that.getType())) && (this.socketTimeout == null ? that.getSocketTimeout() == null : this.socketTimeout.equals(that.getSocketTimeout())) && (this.connectTimeout == null ? that.getConnectTimeout() == null : this.connectTimeout.equals(that.getConnectTimeout())) && this.trustSelfSignedCerts == that.isTrustSelfSignedCerts() && this.compressionEnabled == that.isCompressionEnabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.addresses.hashCode();
        h$ *= 1000003;
        h$ ^= this.username == null ? 0 : this.username.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= this.apiKey == null ? 0 : this.apiKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.bearerToken == null ? 0 : this.bearerToken.hashCode();
        h$ *= 1000003;
        h$ ^= this.defaultHeaders == null ? 0 : this.defaultHeaders.hashCode();
        h$ *= 1000003;
        h$ ^= this.keystorePath == null ? 0 : this.keystorePath.hashCode();
        h$ *= 1000003;
        h$ ^= this.keystorePassword == null ? 0 : this.keystorePassword.hashCode();
        h$ *= 1000003;
        h$ ^= this.pathPrefix == null ? 0 : this.pathPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.index.hashCode();
        h$ *= 1000003;
        h$ ^= this.type == null ? 0 : this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.socketTimeout == null ? 0 : this.socketTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectTimeout == null ? 0 : this.connectTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.trustSelfSignedCerts ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.compressionEnabled ? 1231 : 1237;
    }

    @Override
    ElasticsearchIO.ConnectionConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.ConnectionConfiguration.Builder {
        private List<String> addresses;
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String apiKey;
        private @Nullable String bearerToken;
        private @Nullable List<Header> defaultHeaders;
        private @Nullable String keystorePath;
        private @Nullable String keystorePassword;
        private @Nullable String pathPrefix;
        private String index;
        private @Nullable String type;
        private @Nullable Integer socketTimeout;
        private @Nullable Integer connectTimeout;
        private Boolean trustSelfSignedCerts;
        private Boolean compressionEnabled;

        Builder() {
        }

        private Builder(ElasticsearchIO.ConnectionConfiguration source) {
            this.addresses = source.getAddresses();
            this.username = source.getUsername();
            this.password = source.getPassword();
            this.apiKey = source.getApiKey();
            this.bearerToken = source.getBearerToken();
            this.defaultHeaders = source.getDefaultHeaders();
            this.keystorePath = source.getKeystorePath();
            this.keystorePassword = source.getKeystorePassword();
            this.pathPrefix = source.getPathPrefix();
            this.index = source.getIndex();
            this.type = source.getType();
            this.socketTimeout = source.getSocketTimeout();
            this.connectTimeout = source.getConnectTimeout();
            this.trustSelfSignedCerts = source.isTrustSelfSignedCerts();
            this.compressionEnabled = source.isCompressionEnabled();
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setAddresses(List<String> addresses) {
            if (addresses == null) {
                throw new NullPointerException("Null addresses");
            }
            this.addresses = addresses;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setDefaultHeaders(List<Header> defaultHeaders) {
            this.defaultHeaders = defaultHeaders;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setIndex(String index) {
            if (index == null) {
                throw new NullPointerException("Null index");
            }
            this.index = index;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setType(String type) {
            this.type = type;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setTrustSelfSignedCerts(boolean trustSelfSignedCerts) {
            this.trustSelfSignedCerts = trustSelfSignedCerts;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration build() {
            if (this.addresses == null || this.index == null || this.trustSelfSignedCerts == null || this.compressionEnabled == null) {
                StringBuilder missing = new StringBuilder();
                if (this.addresses == null) {
                    missing.append(" addresses");
                }
                if (this.index == null) {
                    missing.append(" index");
                }
                if (this.trustSelfSignedCerts == null) {
                    missing.append(" trustSelfSignedCerts");
                }
                if (this.compressionEnabled == null) {
                    missing.append(" compressionEnabled");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration(this.addresses, this.username, this.password, this.apiKey, this.bearerToken, this.defaultHeaders, this.keystorePath, this.keystorePassword, this.pathPrefix, this.index, this.type, this.socketTimeout, this.connectTimeout, this.trustSelfSignedCerts, this.compressionEnabled);
        }
    }
}

