/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;

final class AutoValue_ElasticsearchIO_Read
extends ElasticsearchIO.Read {
    private final ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
    private final String query;
    private final String scrollKeepalive;
    private final long batchSize;

    private AutoValue_ElasticsearchIO_Read(@Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration, @Nullable String query, String scrollKeepalive, long batchSize) {
        this.connectionConfiguration = connectionConfiguration;
        this.query = query;
        if (scrollKeepalive == null) {
            throw new NullPointerException("Null scrollKeepalive");
        }
        this.scrollKeepalive = scrollKeepalive;
        this.batchSize = batchSize;
    }

    @Override
    @Nullable
    ElasticsearchIO.ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    @Nullable
    String getQuery() {
        return this.query;
    }

    @Override
    String getScrollKeepalive() {
        return this.scrollKeepalive;
    }

    @Override
    long getBatchSize() {
        return this.batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.Read) {
            ElasticsearchIO.Read that = (ElasticsearchIO.Read)((Object)o);
            return (this.connectionConfiguration == null ? that.getConnectionConfiguration() == null : this.connectionConfiguration.equals(that.getConnectionConfiguration())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && this.scrollKeepalive.equals(that.getScrollKeepalive()) && this.batchSize == that.getBatchSize();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.connectionConfiguration == null ? 0 : this.connectionConfiguration.hashCode();
        h *= 1000003;
        h ^= this.query == null ? 0 : this.query.hashCode();
        h *= 1000003;
        h ^= this.scrollKeepalive.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.batchSize >>> 32 ^ this.batchSize));
        return h;
    }

    @Override
    public ElasticsearchIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.Read.Builder {
        private ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
        private String query;
        private String scrollKeepalive;
        private Long batchSize;

        Builder() {
        }

        Builder(ElasticsearchIO.Read source) {
            this.connectionConfiguration = source.getConnectionConfiguration();
            this.query = source.getQuery();
            this.scrollKeepalive = source.getScrollKeepalive();
            this.batchSize = source.getBatchSize();
        }

        @Override
        public ElasticsearchIO.Read.Builder setConnectionConfiguration(ElasticsearchIO.ConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        @Override
        public ElasticsearchIO.Read.Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        @Override
        public ElasticsearchIO.Read.Builder setScrollKeepalive(String scrollKeepalive) {
            this.scrollKeepalive = scrollKeepalive;
            return this;
        }

        @Override
        public ElasticsearchIO.Read.Builder setBatchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public ElasticsearchIO.Read build() {
            String missing = "";
            if (this.scrollKeepalive == null) {
                missing = missing + " scrollKeepalive";
            }
            if (this.batchSize == null) {
                missing = missing + " batchSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_Read(this.connectionConfiguration, this.query, this.scrollKeepalive, this.batchSize);
        }
    }
}

