/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.auto.value.AutoValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Read;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_ReadAll;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Write;
import org.apache.beam.sdk.io.cassandra.DefaultObjectMapperFactory;
import org.apache.beam.sdk.io.cassandra.Mapper;
import org.apache.beam.sdk.io.cassandra.ReadFn;
import org.apache.beam.sdk.io.cassandra.RingRange;
import org.apache.beam.sdk.io.cassandra.SplitGenerator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CassandraIO {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraIO.class);
    private static final String MURMUR3PARTITIONER = "org.apache.cassandra.dht.Murmur3Partitioner";

    private CassandraIO() {
    }

    public static <T> Read<T> read() {
        return new AutoValue_CassandraIO_Read.Builder().build();
    }

    public static <T> ReadAll<T> readAll() {
        return new AutoValue_CassandraIO_ReadAll.Builder().build();
    }

    public static <T> Write<T> write() {
        return Write.builder(MutationType.WRITE).build();
    }

    public static <T> Write<T> delete() {
        return Write.builder(MutationType.DELETE).build();
    }

    static Cluster getCluster(ValueProvider<List<String>> hosts, ValueProvider<Integer> port, ValueProvider<String> username, ValueProvider<String> password, ValueProvider<String> localDc, ValueProvider<String> consistencyLevel, ValueProvider<Integer> connectTimeout, ValueProvider<Integer> readTimeout) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(((List)hosts.get()).toArray(new String[0])).withPort(((Integer)port.get()).intValue());
        if (username != null) {
            builder.withAuthProvider((AuthProvider)new PlainTextAuthProvider((String)username.get(), (String)password.get()));
        }
        DCAwareRoundRobinPolicy.Builder dcAwarePolicyBuilder = new DCAwareRoundRobinPolicy.Builder();
        if (localDc != null) {
            dcAwarePolicyBuilder.withLocalDc((String)localDc.get());
        }
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)dcAwarePolicyBuilder.build()));
        if (consistencyLevel != null) {
            builder.withQueryOptions(new QueryOptions().setConsistencyLevel(ConsistencyLevel.valueOf((String)((String)consistencyLevel.get()))));
        }
        SocketOptions socketOptions = new SocketOptions();
        builder.withSocketOptions(socketOptions);
        if (connectTimeout != null) {
            socketOptions.setConnectTimeoutMillis(((Integer)connectTimeout.get()).intValue());
        }
        if (readTimeout != null) {
            socketOptions.setReadTimeoutMillis(((Integer)readTimeout.get()).intValue());
        }
        return builder.build();
    }

    @VisibleForTesting
    private static boolean isMurmur3Partitioner(Cluster cluster) {
        return MURMUR3PARTITIONER.equals(cluster.getMetadata().getPartitioner());
    }

    @AutoValue
    public static abstract class ReadAll<T>
    extends PTransform<PCollection<Read<T>>, PCollection<T>> {
        @Nullable
        abstract Coder<T> coder();

        abstract Builder<T> builder();

        public ReadAll<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public PCollection<T> expand(PCollection<Read<T>> input) {
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            return ((PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read", (PTransform)ParDo.of(new ReadFn()))).setCoder(this.coder());
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract ReadAll<T> autoBuild();

            public ReadAll<T> build() {
                return this.autoBuild();
            }
        }
    }

    private static class Mutator<T> {
        private static final int CONCURRENT_ASYNC_QUERIES = 100;
        private final Cluster cluster;
        private final Session session;
        private final SerializableFunction<Session, Mapper> mapperFactoryFn;
        private List<Future<Void>> mutateFutures;
        private final BiFunction<Mapper<T>, T, Future<Void>> mutator;
        private final String operationName;

        Mutator(Write<T> spec, BiFunction<Mapper<T>, T, Future<Void>> mutator, String operationName) {
            this.cluster = CassandraIO.getCluster(spec.hosts(), spec.port(), spec.username(), spec.password(), spec.localDc(), spec.consistencyLevel(), spec.connectTimeout(), spec.readTimeout());
            this.session = this.cluster.connect((String)spec.keyspace().get());
            this.mapperFactoryFn = spec.mapperFactoryFn();
            this.mutateFutures = new ArrayList<Future<Void>>();
            this.mutator = mutator;
            this.operationName = operationName;
        }

        void mutate(T entity) throws ExecutionException, InterruptedException {
            Mapper mapper = (Mapper)this.mapperFactoryFn.apply((Object)this.session);
            this.mutateFutures.add(this.mutator.apply(mapper, (Mapper)entity));
            if (this.mutateFutures.size() == 100) {
                LOG.debug("Waiting for a batch of {} Cassandra {} to be executed...", (Object)100, (Object)this.operationName);
                this.waitForFuturesToFinish();
                this.mutateFutures = new ArrayList<Future<Void>>();
            }
        }

        void flush() throws ExecutionException, InterruptedException {
            if (this.mutateFutures.size() > 0) {
                this.waitForFuturesToFinish();
            }
        }

        void close() {
            if (this.session != null) {
                this.session.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }

        private void waitForFuturesToFinish() throws ExecutionException, InterruptedException {
            for (Future<Void> future : this.mutateFutures) {
                future.get();
            }
        }
    }

    private static class DeleteFn<T>
    extends DoFn<T, Void> {
        private final Write<T> spec;
        private transient Mutator<T> deleter;

        DeleteFn(Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.deleter = new Mutator<Object>(this.spec, Mapper::deleteAsync, "deletes");
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws ExecutionException, InterruptedException {
            this.deleter.mutate(c.element());
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            this.deleter.flush();
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.deleter.close();
            this.deleter = null;
        }
    }

    private static class WriteFn<T>
    extends DoFn<T, Void> {
        private final Write<T> spec;
        private transient Mutator<T> writer;

        WriteFn(Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.writer = new Mutator<Object>(this.spec, Mapper::saveAsync, "writes");
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws ExecutionException, InterruptedException {
            this.writer.mutate(c.element());
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            this.writer.flush();
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.writer.close();
            this.writer = null;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract ValueProvider<List<String>> hosts();

        @Nullable
        abstract ValueProvider<Integer> port();

        @Nullable
        abstract ValueProvider<String> keyspace();

        @Nullable
        abstract Class<T> entity();

        @Nullable
        abstract ValueProvider<String> username();

        @Nullable
        abstract ValueProvider<String> password();

        @Nullable
        abstract ValueProvider<String> localDc();

        @Nullable
        abstract ValueProvider<String> consistencyLevel();

        abstract MutationType mutationType();

        @Nullable
        abstract ValueProvider<Integer> connectTimeout();

        @Nullable
        abstract ValueProvider<Integer> readTimeout();

        @Nullable
        abstract SerializableFunction<Session, Mapper> mapperFactoryFn();

        abstract Builder<T> builder();

        static <T> Builder<T> builder(MutationType mutationType) {
            return new AutoValue_CassandraIO_Write.Builder().setMutationType(mutationType);
        }

        public Write<T> withHosts(List<String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with null hosts"));
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with empty hosts list"));
            return this.withHosts((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hosts));
        }

        public Write<T> withHosts(ValueProvider<List<String>> hosts) {
            return this.builder().setHosts(hosts).build();
        }

        public Write<T> withPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withPort(port) called with invalid port number (%s)"), (int)port);
            return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
        }

        public Write<T> withPort(ValueProvider<Integer> port) {
            return this.builder().setPort(port).build();
        }

        public Write<T> withKeyspace(String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withKeyspace(keyspace) called with null keyspace"));
            return this.withKeyspace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)keyspace));
        }

        public Write<T> withKeyspace(ValueProvider<String> keyspace) {
            return this.builder().setKeyspace(keyspace).build();
        }

        public Write<T> withEntity(Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withEntity(entity) called with null entity"));
            return this.builder().setEntity(entity).build();
        }

        public Write<T> withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withUsername(username) called with null username"));
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public Write<T> withUsername(ValueProvider<String> username) {
            return this.builder().setUsername(username).build();
        }

        public Write<T> withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withPassword(password) called with null password"));
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public Write<T> withPassword(ValueProvider<String> password) {
            return this.builder().setPassword(password).build();
        }

        public Write<T> withLocalDc(String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withLocalDc(localDc) called with null localDc"));
            return this.withLocalDc((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)localDc));
        }

        public Write<T> withLocalDc(ValueProvider<String> localDc) {
            return this.builder().setLocalDc(localDc).build();
        }

        public Write<T> withConsistencyLevel(String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withConsistencyLevel(consistencyLevel) called with null consistencyLevel"));
            return this.withConsistencyLevel((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)consistencyLevel));
        }

        public Write<T> withConsistencyLevel(ValueProvider<String> consistencyLevel) {
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public Write<T> withConnectTimeout(Integer timeout) {
            Preconditions.checkArgument((timeout != null && timeout > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withConnectTimeout(timeout) called with invalid timeout number (%s)"), (Object)timeout);
            return this.withConnectTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public Write<T> withConnectTimeout(ValueProvider<Integer> timeout) {
            return this.builder().setConnectTimeout(timeout).build();
        }

        public Write<T> withReadTimeout(Integer timeout) {
            Preconditions.checkArgument((timeout != null && timeout > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withReadTimeout(timeout) called with invalid timeout number (%s)"), (Object)timeout);
            return this.withReadTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public Write<T> withReadTimeout(ValueProvider<Integer> timeout) {
            return this.builder().setReadTimeout(timeout).build();
        }

        public Write<T> withMapperFactoryFn(SerializableFunction<Session, Mapper> mapperFactoryFn) {
            Preconditions.checkArgument((mapperFactoryFn != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().mapperFactoryFn(mapperFactoryFn) called with null value"));
            return this.builder().setMapperFactoryFn(mapperFactoryFn).build();
        }

        public void validate(PipelineOptions pipelineOptions) {
            Preconditions.checkState((this.hosts() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a list of hosts to be set via withHosts(hosts)"));
            Preconditions.checkState((this.port() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a valid port number to be set via withPort(port)"));
            Preconditions.checkState((this.keyspace() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a keyspace to be set via withKeyspace(keyspace)"));
            Preconditions.checkState((this.entity() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires an entity to be set via withEntity(entity)"));
        }

        public PDone expand(PCollection<T> input) {
            if (this.mutationType() == MutationType.DELETE) {
                input.apply((PTransform)ParDo.of(new DeleteFn(this)));
            } else {
                input.apply((PTransform)ParDo.of(new WriteFn(this)));
            }
            return PDone.in((Pipeline)input.getPipeline());
        }

        private String getMutationTypeName() {
            return this.mutationType() == null ? MutationType.WRITE.name().toLowerCase() : this.mutationType().name().toLowerCase();
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setHosts(ValueProvider<List<String>> var1);

            abstract Builder<T> setPort(ValueProvider<Integer> var1);

            abstract Builder<T> setKeyspace(ValueProvider<String> var1);

            abstract Builder<T> setEntity(Class<T> var1);

            abstract Optional<Class<T>> entity();

            abstract Builder<T> setUsername(ValueProvider<String> var1);

            abstract Builder<T> setPassword(ValueProvider<String> var1);

            abstract Builder<T> setLocalDc(ValueProvider<String> var1);

            abstract Builder<T> setConsistencyLevel(ValueProvider<String> var1);

            abstract Builder<T> setMutationType(MutationType var1);

            abstract Builder<T> setConnectTimeout(ValueProvider<Integer> var1);

            abstract Builder<T> setReadTimeout(ValueProvider<Integer> var1);

            abstract Builder<T> setMapperFactoryFn(SerializableFunction<Session, Mapper> var1);

            abstract Optional<SerializableFunction<Session, Mapper>> mapperFactoryFn();

            abstract Write<T> autoBuild();

            public Write<T> build() {
                if (!this.mapperFactoryFn().isPresent() && this.entity().isPresent()) {
                    this.setMapperFactoryFn(new DefaultObjectMapperFactory<T>(this.entity().get()));
                }
                return this.autoBuild();
            }
        }
    }

    public static enum MutationType {
        WRITE,
        DELETE;

    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract ValueProvider<List<String>> hosts();

        @Nullable
        abstract ValueProvider<String> query();

        @Nullable
        abstract ValueProvider<Integer> port();

        @Nullable
        abstract ValueProvider<String> keyspace();

        @Nullable
        abstract ValueProvider<String> table();

        @Nullable
        abstract Class<T> entity();

        @Nullable
        abstract Coder<T> coder();

        @Nullable
        abstract ValueProvider<String> username();

        @Nullable
        abstract ValueProvider<String> password();

        @Nullable
        abstract ValueProvider<String> localDc();

        @Nullable
        abstract ValueProvider<String> consistencyLevel();

        @Nullable
        abstract ValueProvider<Integer> minNumberOfSplits();

        @Nullable
        abstract ValueProvider<Integer> connectTimeout();

        @Nullable
        abstract ValueProvider<Integer> readTimeout();

        @Nullable
        abstract SerializableFunction<Session, Mapper> mapperFactoryFn();

        @Nullable
        abstract ValueProvider<Set<RingRange>> ringRanges();

        abstract Builder<T> builder();

        public Read<T> withHosts(List<String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)"hosts can not be null");
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"hosts can not be empty");
            return this.withHosts((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hosts));
        }

        public Read<T> withHosts(ValueProvider<List<String>> hosts) {
            return this.builder().setHosts(hosts).build();
        }

        public Read<T> withPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port must be > 0, but was: %s", (int)port);
            return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
        }

        public Read<T> withPort(ValueProvider<Integer> port) {
            return this.builder().setPort(port).build();
        }

        public Read<T> withKeyspace(String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)"keyspace can not be null");
            return this.withKeyspace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)keyspace));
        }

        public Read<T> withKeyspace(ValueProvider<String> keyspace) {
            return this.builder().setKeyspace(keyspace).build();
        }

        public Read<T> withTable(String table) {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table can not be null");
            return this.withTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table));
        }

        public Read<T> withTable(ValueProvider<String> table) {
            return this.builder().setTable(table).build();
        }

        public Read<T> withQuery(String query) {
            Preconditions.checkArgument((query != null && query.length() > 0 ? 1 : 0) != 0, (Object)"query cannot be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public Read<T> withQuery(ValueProvider<String> query) {
            return this.builder().setQuery(query).build();
        }

        public Read<T> withEntity(Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity can not be null");
            return this.builder().setEntity(entity).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public Read<T> withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public Read<T> withUsername(ValueProvider<String> username) {
            return this.builder().setUsername(username).build();
        }

        public Read<T> withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public Read<T> withPassword(ValueProvider<String> password) {
            return this.builder().setPassword(password).build();
        }

        public Read<T> withLocalDc(String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)"localDc can not be null");
            return this.withLocalDc((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)localDc));
        }

        public Read<T> withLocalDc(ValueProvider<String> localDc) {
            return this.builder().setLocalDc(localDc).build();
        }

        public Read<T> withConsistencyLevel(String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)"consistencyLevel can not be null");
            return this.withConsistencyLevel((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)consistencyLevel));
        }

        public Read<T> withConsistencyLevel(ValueProvider<String> consistencyLevel) {
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public Read<T> withMinNumberOfSplits(Integer minNumberOfSplits) {
            Preconditions.checkArgument((minNumberOfSplits != null ? 1 : 0) != 0, (Object)"minNumberOfSplits can not be null");
            Preconditions.checkArgument((minNumberOfSplits > 0 ? 1 : 0) != 0, (Object)"minNumberOfSplits must be greater than 0");
            return this.withMinNumberOfSplits((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)minNumberOfSplits));
        }

        public Read<T> withMinNumberOfSplits(ValueProvider<Integer> minNumberOfSplits) {
            return this.builder().setMinNumberOfSplits(minNumberOfSplits).build();
        }

        public Read<T> withConnectTimeout(Integer timeout) {
            Preconditions.checkArgument((timeout != null ? 1 : 0) != 0, (Object)"Connect timeout can not be null");
            Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Connect timeout must be > 0, but was: %s", (Object)timeout);
            return this.withConnectTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public Read<T> withConnectTimeout(ValueProvider<Integer> timeout) {
            return this.builder().setConnectTimeout(timeout).build();
        }

        public Read<T> withReadTimeout(Integer timeout) {
            Preconditions.checkArgument((timeout != null ? 1 : 0) != 0, (Object)"Read timeout can not be null");
            Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Read timeout must be > 0, but was: %s", (Object)timeout);
            return this.withReadTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public Read<T> withReadTimeout(ValueProvider<Integer> timeout) {
            return this.builder().setReadTimeout(timeout).build();
        }

        public Read<T> withMapperFactoryFn(SerializableFunction<Session, Mapper> mapperFactory) {
            Preconditions.checkArgument((mapperFactory != null ? 1 : 0) != 0, (Object)"CassandraIO.withMapperFactory(withMapperFactory) called with null value");
            return this.builder().setMapperFactoryFn(mapperFactory).build();
        }

        public Read<T> withRingRanges(Set<RingRange> ringRange) {
            return this.withRingRanges((ValueProvider<Set<RingRange>>)ValueProvider.StaticValueProvider.of(ringRange));
        }

        public Read<T> withRingRanges(ValueProvider<Set<RingRange>> ringRange) {
            return this.builder().setRingRanges(ringRange).build();
        }

        public PCollection<T> expand(PBegin input) {
            Preconditions.checkArgument((this.hosts() != null && this.port() != null ? 1 : 0) != 0, (Object)"WithHosts() and withPort() are required");
            Preconditions.checkArgument((this.keyspace() != null ? 1 : 0) != 0, (Object)"withKeyspace() is required");
            Preconditions.checkArgument((this.table() != null ? 1 : 0) != 0, (Object)"withTable() is required");
            Preconditions.checkArgument((this.entity() != null ? 1 : 0) != 0, (Object)"withEntity() is required");
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            PCollection splits = ((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)((Object)this), (Object[])new Read[0]))).apply("Create Splits", (PTransform)ParDo.of(new SplitFn()))).setCoder((Coder)SerializableCoder.of((TypeDescriptor)new TypeDescriptor<Read<T>>(){}));
            return (PCollection)splits.apply("ReadAll", CassandraIO.readAll().withCoder(this.coder()));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setHosts(ValueProvider<List<String>> var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setPort(ValueProvider<Integer> var1);

            abstract Builder<T> setKeyspace(ValueProvider<String> var1);

            abstract Builder<T> setTable(ValueProvider<String> var1);

            abstract Builder<T> setEntity(Class<T> var1);

            abstract Optional<Class<T>> entity();

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setUsername(ValueProvider<String> var1);

            abstract Builder<T> setPassword(ValueProvider<String> var1);

            abstract Builder<T> setLocalDc(ValueProvider<String> var1);

            abstract Builder<T> setConsistencyLevel(ValueProvider<String> var1);

            abstract Builder<T> setMinNumberOfSplits(ValueProvider<Integer> var1);

            abstract Builder<T> setConnectTimeout(ValueProvider<Integer> var1);

            abstract Builder<T> setReadTimeout(ValueProvider<Integer> var1);

            abstract Builder<T> setMapperFactoryFn(SerializableFunction<Session, Mapper> var1);

            abstract Optional<SerializableFunction<Session, Mapper>> mapperFactoryFn();

            abstract Builder<T> setRingRanges(ValueProvider<Set<RingRange>> var1);

            abstract Read<T> autoBuild();

            public Read<T> build() {
                if (!this.mapperFactoryFn().isPresent() && this.entity().isPresent()) {
                    this.setMapperFactoryFn(new DefaultObjectMapperFactory<T>(this.entity().get()));
                }
                return this.autoBuild();
            }
        }

        private static class SplitFn<T>
        extends DoFn<Read<T>, Read<T>> {
            private SplitFn() {
            }

            @DoFn.ProcessElement
            public void process(@DoFn.Element Read<T> read, DoFn.OutputReceiver<Read<T>> outputReceiver) {
                Set<RingRange> ringRanges = SplitFn.getRingRanges(read);
                for (RingRange rr : ringRanges) {
                    outputReceiver.output(read.withRingRanges((Set<RingRange>)ImmutableSet.of((Object)rr)));
                }
            }

            private static <T> Set<RingRange> getRingRanges(Read<T> read) {
                try (Cluster cluster = CassandraIO.getCluster(read.hosts(), read.port(), read.username(), read.password(), read.localDc(), read.consistencyLevel(), read.connectTimeout(), read.readTimeout());){
                    if (CassandraIO.isMurmur3Partitioner(cluster)) {
                        LOG.info("Murmur3Partitioner detected, splitting");
                        Integer splitCount = read.minNumberOfSplits() != null && read.minNumberOfSplits().get() != null ? (Integer)read.minNumberOfSplits().get() : Integer.valueOf(cluster.getMetadata().getAllHosts().size());
                        List<BigInteger> tokens = cluster.getMetadata().getTokenRanges().stream().map(tokenRange -> new BigInteger(tokenRange.getEnd().getValue().toString())).collect(Collectors.toList());
                        SplitGenerator splitGenerator = new SplitGenerator(cluster.getMetadata().getPartitioner());
                        Set<RingRange> set = splitGenerator.generateSplits(splitCount.intValue(), tokens).stream().flatMap(Collection::stream).collect(Collectors.toSet());
                        return set;
                    }
                    LOG.warn("Only Murmur3Partitioner is supported for splitting, using an unique source for the read");
                    String partitioner = cluster.getMetadata().getPartitioner();
                    RingRange totalRingRange = RingRange.of(SplitGenerator.getRangeMin(partitioner), SplitGenerator.getRangeMax(partitioner));
                    Set<RingRange> set = Collections.singleton(totalRingRange);
                    return set;
                }
            }
        }
    }
}

