/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.beam.fn.harness.HandlesSplits;
import org.apache.beam.fn.harness.control.BundleProgressReporter;
import org.apache.beam.fn.harness.control.ExecutionStateSampler;
import org.apache.beam.fn.harness.control.Metrics;
import org.apache.beam.fn.harness.data.AutoValue_PCollectionConsumerRegistry_ConsumerAndMetadata;
import org.apache.beam.fn.harness.debug.DataSampler;
import org.apache.beam.fn.harness.debug.ElementSample;
import org.apache.beam.fn.harness.debug.OutputSampler;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCollectionConsumerRegistry {
    private final  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker stateTracker;
    private final @UnknownKeyFor @NonNull @Initialized ShortIdMap shortIdMap;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ConsumerAndMetadata>> pCollectionIdsToConsumers;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FnDataReceiver> pCollectionIdsToWrappedConsumer;
    private final @UnknownKeyFor @NonNull @Initialized BundleProgressReporter.Registrar bundleProgressReporterRegistrar;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor processBundleDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized RehydratedComponents rehydratedComponents;
    @javax.annotation.Nullable
    private final @UnknownKeyFor @Nullable @Initialized DataSampler dataSampler;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PCollectionConsumerRegistry.class);

    public PCollectionConsumerRegistry( @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker stateTracker, @UnknownKeyFor @NonNull @Initialized ShortIdMap shortIdMap, @UnknownKeyFor @NonNull @Initialized BundleProgressReporter.Registrar bundleProgressReporterRegistrar, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor processBundleDescriptor) {
        this(stateTracker, shortIdMap, bundleProgressReporterRegistrar, processBundleDescriptor, null);
    }

    public PCollectionConsumerRegistry( @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker stateTracker, @UnknownKeyFor @NonNull @Initialized ShortIdMap shortIdMap, @UnknownKeyFor @NonNull @Initialized BundleProgressReporter.Registrar bundleProgressReporterRegistrar, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor processBundleDescriptor, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized DataSampler dataSampler) {
        this.stateTracker = stateTracker;
        this.shortIdMap = shortIdMap;
        this.pCollectionIdsToConsumers = new HashMap<String, List<ConsumerAndMetadata>>();
        this.pCollectionIdsToWrappedConsumer = new HashMap<String, FnDataReceiver>();
        this.bundleProgressReporterRegistrar = bundleProgressReporterRegistrar;
        this.processBundleDescriptor = processBundleDescriptor;
        this.rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)RunnerApi.Components.newBuilder().putAllCoders(processBundleDescriptor.getCodersMap()).putAllPcollections(processBundleDescriptor.getPcollectionsMap()).putAllWindowingStrategies(processBundleDescriptor.getWindowingStrategiesMap()).build());
        this.dataSampler = dataSampler;
    }

    public <T> void register(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized String pTransformUniqueName, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> consumer) {
        if (this.pCollectionIdsToWrappedConsumer.containsKey(pCollectionId)) {
            throw new RuntimeException("New consumers for a pCollectionId cannot be register()-d after calling getMultiplexingConsumer.");
        }
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder();
        builder.setUrn("beam:metric:pardo_execution_time:process_bundle_msecs:v1");
        builder.setType("beam:metrics:sum_int64:v1");
        builder.setLabel("PTRANSFORM", pTransformId);
        MetricsApi.MonitoringInfo mi = builder.build();
        if (mi == null) {
            throw new IllegalStateException(String.format("Unable to construct %s counter for PTransform {id=%s, name=%s}", "beam:metric:pardo_execution_time:process_bundle_msecs:v1", pTransformId, pTransformUniqueName));
        }
        String shortId = this.shortIdMap.getOrCreateShortId(mi);
        ExecutionStateSampler.ExecutionState executionState = this.stateTracker.create(shortId, pTransformId, pTransformUniqueName, "process");
        List consumerAndMetadatas = this.pCollectionIdsToConsumers.computeIfAbsent(pCollectionId, unused -> new ArrayList());
        consumerAndMetadatas.add(ConsumerAndMetadata.forConsumer(consumer, pTransformId, executionState, this.stateTracker));
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getMultiplexingConsumer(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
        return this.pCollectionIdsToWrappedConsumer.computeIfAbsent(pCollectionId, pcId -> {
            Coder coder;
            if (!this.processBundleDescriptor.containsPcollections(pCollectionId)) {
                throw new IllegalArgumentException(String.format("Unknown PCollection id %s", pCollectionId));
            }
            String coderId = this.processBundleDescriptor.getPcollectionsOrThrow(pCollectionId).getCoderId();
            OutputSampler sampler = null;
            try {
                Coder maybeWindowedValueInputCoder = this.rehydratedComponents.getCoder(coderId);
                if (this.dataSampler != null) {
                    sampler = this.dataSampler.sampleOutput(pCollectionId, maybeWindowedValueInputCoder);
                }
                coder = maybeWindowedValueInputCoder instanceof WindowedValues.WindowedValueCoder ? ((WindowedValues.WindowedValueCoder)maybeWindowedValueInputCoder).getValueCoder() : maybeWindowedValueInputCoder;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to materialize coder %s", coderId), e);
            }
            List consumerAndMetadatas = this.pCollectionIdsToConsumers.computeIfAbsent(pCollectionId, unused -> new ArrayList());
            if (consumerAndMetadatas.size() == 1) {
                ConsumerAndMetadata consumerAndMetadata = (ConsumerAndMetadata)consumerAndMetadatas.get(0);
                if (consumerAndMetadata.getConsumer() instanceof HandlesSplits) {
                    return new SplittingMetricTrackingFnDataReceiver((String)pcId, coder, consumerAndMetadata, sampler);
                }
                return new MetricTrackingFnDataReceiver((String)pcId, coder, consumerAndMetadata, sampler);
            }
            return new MultiplexingMetricTrackingFnDataReceiver((String)pcId, coder, consumerAndMetadatas, sampler);
        });
    }

    private static <T> void logAndRethrow(@UnknownKeyFor @NonNull @Initialized Exception e, @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler.ExecutionState executionState,  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker executionStateTracker, @UnknownKeyFor @NonNull @Initialized String ptransformId, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized OutputSampler<T> outputSampler, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized ElementSample<T> elementSample) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String processBundleId;
        ExecutionStateSampler.ExecutionStateTrackerStatus status = executionStateTracker.getStatus();
        String string = processBundleId = status == null ? null : status.getProcessBundleId();
        if (outputSampler != null) {
            outputSampler.exception(elementSample, e, ptransformId, processBundleId);
        }
        if (executionState.error()) {
            LOG.error("Failed to process element for bundle \"{}\"", (Object)processBundleId, (Object)e);
        }
        throw e;
    }

    private static class SampleByteSizeDistribution<@UnknownKeyFor T> {
        final @UnknownKeyFor @NonNull @Initialized Distribution distribution;
        @UnknownKeyFor @NonNull @Initialized ByteSizeObserver byteCountObserver;
        private static final @UnknownKeyFor @NonNull @Initialized int RESERVOIR_SIZE = 10;
        private static final @UnknownKeyFor @NonNull @Initialized int SAMPLING_THRESHOLD = 30;
        private @UnknownKeyFor @NonNull @Initialized long samplingToken = 0L;
        private @UnknownKeyFor @NonNull @Initialized long nextSamplingToken = 0L;
        private @UnknownKeyFor @NonNull @Initialized Random randomGenerator = new Random();

        public SampleByteSizeDistribution(@UnknownKeyFor @NonNull @Initialized Distribution distribution) {
            this.distribution = distribution;
            this.byteCountObserver = null;
        }

        public void tryUpdate(T value, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.shouldSampleElement()) {
                this.byteCountObserver = new ByteSizeObserver();
                coder.registerByteSizeObserver(value, (ElementByteSizeObserver)this.byteCountObserver);
                if (!this.byteCountObserver.getIsLazy()) {
                    this.byteCountObserver.advance();
                    this.distribution.update(this.byteCountObserver.observedSize);
                }
            } else {
                this.byteCountObserver = null;
            }
        }

        public void finishLazyUpdate() {
            if (this.byteCountObserver != null && this.byteCountObserver.getIsLazy()) {
                this.byteCountObserver.advance();
                this.distribution.update(this.byteCountObserver.observedSize);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean shouldSampleElement() {
            if (this.samplingToken + 1L == Long.MAX_VALUE) {
                this.samplingToken = 0L;
                this.nextSamplingToken = this.getNextSamplingToken(this.samplingToken);
            }
            ++this.samplingToken;
            if (this.nextSamplingToken == 0L) {
                if (this.samplingToken <= 10L || this.randomGenerator.nextInt((int)this.samplingToken) < 10) {
                    if (this.samplingToken > 30L) {
                        this.nextSamplingToken = this.getNextSamplingToken(this.samplingToken);
                    }
                    return true;
                }
            } else if (this.samplingToken >= this.nextSamplingToken) {
                this.nextSamplingToken = this.getNextSamplingToken(this.samplingToken);
                return true;
            }
            return false;
        }

        private @UnknownKeyFor @NonNull @Initialized long getNextSamplingToken(@UnknownKeyFor @NonNull @Initialized long samplingToken) {
            double gap = Math.log(1.0 - this.randomGenerator.nextDouble()) / Math.log(1.0 - 10.0 / (double)samplingToken);
            return samplingToken + (long)((int)gap);
        }

        private static class ByteSizeObserver
        extends ElementByteSizeObserver {
            private @UnknownKeyFor @NonNull @Initialized long observedSize = 0L;

            private ByteSizeObserver() {
            }

            protected void reportElementSize(@UnknownKeyFor @NonNull @Initialized long elementSize) {
                this.observedSize += elementSize;
            }
        }
    }

    private class SplittingMetricTrackingFnDataReceiver<@UnknownKeyFor T>
    extends MetricTrackingFnDataReceiver<T>
    implements HandlesSplits {
        private final @UnknownKeyFor @NonNull @Initialized HandlesSplits delegate;

        public SplittingMetricTrackingFnDataReceiver(@UnknownKeyFor @NonNull @Initialized String pCollection, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized ConsumerAndMetadata consumerAndMetadata, OutputSampler<T> outputSampler) {
            super(pCollection, coder, consumerAndMetadata, outputSampler);
            this.delegate = (HandlesSplits)consumerAndMetadata.getConsumer();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized HandlesSplits.SplitResult trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            return this.delegate.trySplit(fractionOfRemainder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getProgress() {
            return this.delegate.getProgress();
        }
    }

    private class MultiplexingMetricTrackingFnDataReceiver<@UnknownKeyFor T>
    implements FnDataReceiver<WindowedValue<T>> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ConsumerAndMetadata> consumerAndMetadatas;
        private final @UnknownKeyFor @NonNull @Initialized Metrics.BundleCounter elementCountCounter;
        private final @UnknownKeyFor @NonNull @Initialized SampleByteSizeDistribution<T> sampledByteSizeDistribution;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        @javax.annotation.Nullable
        private @UnknownKeyFor @Nullable @Initialized OutputSampler<T> outputSampler = null;

        public MultiplexingMetricTrackingFnDataReceiver(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized T> coder, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<ConsumerAndMetadata> consumerAndMetadatas, OutputSampler<T> outputSampler) {
            this.consumerAndMetadatas = consumerAndMetadatas;
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("PCOLLECTION", pCollectionId);
            MonitoringInfoMetricName elementCountMetricName = MonitoringInfoMetricName.named(MonitoringInfoConstants.Urns.ELEMENT_COUNT, labels);
            String elementCountShortId = PCollectionConsumerRegistry.this.shortIdMap.getOrCreateShortId(new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.ELEMENT_COUNT).setType("beam:metrics:sum_int64:v1").setLabels(labels).build());
            this.elementCountCounter = Metrics.bundleProcessingThreadCounter(elementCountShortId, elementCountMetricName);
            PCollectionConsumerRegistry.this.bundleProgressReporterRegistrar.register(this.elementCountCounter);
            MonitoringInfoMetricName sampledByteSizeMetricName = MonitoringInfoMetricName.named(MonitoringInfoConstants.Urns.SAMPLED_BYTE_SIZE, labels);
            String sampledByteSizeShortId = PCollectionConsumerRegistry.this.shortIdMap.getOrCreateShortId(new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.SAMPLED_BYTE_SIZE).setType("beam:metrics:distribution_int64:v1").setLabels(labels).build());
            Metrics.BundleDistribution sampledByteSizeUnderlyingDistribution = Metrics.bundleProcessingThreadDistribution(sampledByteSizeShortId, sampledByteSizeMetricName);
            this.sampledByteSizeDistribution = new SampleByteSizeDistribution(sampledByteSizeUnderlyingDistribution);
            PCollectionConsumerRegistry.this.bundleProgressReporterRegistrar.register(sampledByteSizeUnderlyingDistribution);
            this.coder = coder;
            this.outputSampler = outputSampler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> input) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.elementCountCounter.inc(input.getWindows().size());
            this.sampledByteSizeDistribution.tryUpdate(input.getValue(), this.coder);
            ElementSample<T> elementSample = null;
            if (this.outputSampler != null) {
                elementSample = this.outputSampler.sample(input);
            }
            int size = this.consumerAndMetadatas.size();
            for (int i = 0; i < size; ++i) {
                ConsumerAndMetadata consumerAndMetadata = this.consumerAndMetadatas.get(i);
                ExecutionStateSampler.ExecutionState state = consumerAndMetadata.getExecutionState();
                state.activate();
                try {
                    consumerAndMetadata.getConsumer().accept(input);
                }
                catch (Exception e) {
                    PCollectionConsumerRegistry.logAndRethrow(e, state, consumerAndMetadata.getExecutionStateTracker(), consumerAndMetadata.getPTransformId(), this.outputSampler, elementSample);
                }
                finally {
                    state.deactivate();
                }
                this.sampledByteSizeDistribution.finishLazyUpdate();
            }
        }
    }

    private class MetricTrackingFnDataReceiver<@UnknownKeyFor T>
    implements FnDataReceiver<WindowedValue<T>> {
        private final @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> delegate;
        private final @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler.ExecutionState executionState;
        private final @UnknownKeyFor @NonNull @Initialized Metrics.BundleCounter elementCountCounter;
        private final @UnknownKeyFor @NonNull @Initialized SampleByteSizeDistribution<T> sampledByteSizeDistribution;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized OutputSampler<T> outputSampler;
        private final @UnknownKeyFor @NonNull @Initialized String ptransformId;
        private final  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker executionStateTracker;

        public MetricTrackingFnDataReceiver(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized ConsumerAndMetadata consumerAndMetadata, OutputSampler<T> outputSampler) {
            this.delegate = consumerAndMetadata.getConsumer();
            this.executionState = consumerAndMetadata.getExecutionState();
            this.executionStateTracker = consumerAndMetadata.getExecutionStateTracker();
            this.ptransformId = consumerAndMetadata.getPTransformId();
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("PCOLLECTION", pCollectionId);
            MonitoringInfoMetricName elementCountMetricName = MonitoringInfoMetricName.named(MonitoringInfoConstants.Urns.ELEMENT_COUNT, labels);
            String elementCountShortId = PCollectionConsumerRegistry.this.shortIdMap.getOrCreateShortId(new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.ELEMENT_COUNT).setType("beam:metrics:sum_int64:v1").setLabels(labels).build());
            this.elementCountCounter = Metrics.bundleProcessingThreadCounter(elementCountShortId, elementCountMetricName);
            PCollectionConsumerRegistry.this.bundleProgressReporterRegistrar.register(this.elementCountCounter);
            MonitoringInfoMetricName sampledByteSizeMetricName = MonitoringInfoMetricName.named(MonitoringInfoConstants.Urns.SAMPLED_BYTE_SIZE, labels);
            String sampledByteSizeShortId = PCollectionConsumerRegistry.this.shortIdMap.getOrCreateShortId(new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.SAMPLED_BYTE_SIZE).setType("beam:metrics:distribution_int64:v1").setLabels(labels).build());
            Metrics.BundleDistribution sampledByteSizeUnderlyingDistribution = Metrics.bundleProcessingThreadDistribution(sampledByteSizeShortId, sampledByteSizeMetricName);
            this.sampledByteSizeDistribution = new SampleByteSizeDistribution(sampledByteSizeUnderlyingDistribution);
            PCollectionConsumerRegistry.this.bundleProgressReporterRegistrar.register(sampledByteSizeUnderlyingDistribution);
            this.coder = coder;
            this.outputSampler = outputSampler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> input) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.elementCountCounter.inc(input.getWindows().size());
            this.sampledByteSizeDistribution.tryUpdate(input.getValue(), this.coder);
            ElementSample<T> elementSample = null;
            if (this.outputSampler != null) {
                elementSample = this.outputSampler.sample(input);
            }
            this.executionState.activate();
            try {
                this.delegate.accept(input);
            }
            catch (Exception e) {
                PCollectionConsumerRegistry.logAndRethrow(e, this.executionState, this.executionStateTracker, this.ptransformId, this.outputSampler, elementSample);
            }
            finally {
                this.executionState.deactivate();
            }
            this.sampledByteSizeDistribution.finishLazyUpdate();
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    static abstract class ConsumerAndMetadata {
        ConsumerAndMetadata() {
        }

        public static @UnknownKeyFor @NonNull @Initialized ConsumerAndMetadata forConsumer(@UnknownKeyFor @NonNull @Initialized FnDataReceiver consumer, @UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler.ExecutionState state,  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker stateTracker) {
            return new AutoValue_PCollectionConsumerRegistry_ConsumerAndMetadata(consumer, pTransformId, state, stateTracker);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized FnDataReceiver getConsumer();

        public abstract @UnknownKeyFor @NonNull @Initialized String getPTransformId();

        public abstract @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler.ExecutionState getExecutionState();

        public abstract  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker getExecutionStateTracker();
    }
}

