/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.fn.harness.HandlesSplits;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.ProgressUtils;
import org.apache.beam.fn.harness.SplitResultsWithStopIndex;
import org.apache.beam.fn.harness.WindowedSplitResult;
import org.apache.beam.fn.harness.state.FnApiStateAccessor;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.fn.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.Holder;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.OutputBuilder;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Timestamp;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SplittableTruncateSizedRestrictionsDoFnRunner<@UnknownKeyFor InputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT, @UnknownKeyFor WatermarkEstimatorStateT, @UnknownKeyFor OutputT>
implements FnApiStateAccessor.MutatingStateContext<Void, BoundedWindow> {
    private final @UnknownKeyFor @NonNull @Initialized boolean observesWindow;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> doFnInvoker;
    private final @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>>> mainOutputConsumer;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized FnApiStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stateAccessor;
    private final @UnknownKeyFor @NonNull @Initialized SplittableTruncateSizedRestrictionsDoFnRunner. @UnknownKeyFor @NonNull @Initialized TruncateSizedRestrictionArgumentProvider mutableArgumentProvider;
    private final @UnknownKeyFor @NonNull @Initialized String pTransformId;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform;
    private final @UnknownKeyFor @NonNull @Initialized String mainInputId;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fullInputCoder;
    private final @UnknownKeyFor @NonNull @Initialized Object splitLock = new Object();
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    private @UnknownKeyFor @NonNull @Initialized int windowCurrentIndex;
    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedWindow> currentWindows;
    private @Nullable RestrictionT currentRestriction;
    private @Nullable @UnknownKeyFor @Initialized Holder<WatermarkEstimatorStateT> currentWatermarkEstimatorState;
    private @Nullable @UnknownKeyFor @Initialized Instant initialWatermark;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized WatermarkEstimators.WatermarkAndStateObserver<WatermarkEstimatorStateT> currentWatermarkEstimator;
    private @Nullable @UnknownKeyFor @Initialized BoundedWindow currentWindow;
    private @Nullable @UnknownKeyFor @Initialized RestrictionTracker<RestrictionT, PositionT> currentTracker;
    private @Nullable @UnknownKeyFor @Initialized WindowedValue<InputT> currentElement;
    private @UnknownKeyFor @NonNull @Initialized int windowStopIndex;

    SplittableTruncateSizedRestrictionsDoFnRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized String pTransformId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>>> mainOutputConsumer, @UnknownKeyFor @NonNull @Initialized FnApiStateAccessor<@UnknownKeyFor @Nullable @Initialized Void> stateAccessor) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pipelineOptions = pipelineOptions;
        this.stateAccessor = stateAccessor;
        this.pTransformId = pTransformId;
        this.pTransform = pTransform;
        RunnerApi.ParDoPayload parDoPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)pTransform.getSpec().getPayload());
        DoFn doFn = ParDoTranslation.getDoFn((RunnerApi.ParDoPayload)parDoPayload);
        DoFnSignature doFnSignature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor((DoFn)doFn, (PipelineOptions)pipelineOptions);
        this.doFnSchemaInformation = ParDoTranslation.getSchemaInformation((RunnerApi.ParDoPayload)parDoPayload);
        this.mainOutputConsumer = mainOutputConsumer;
        this.sideInputMapping = ParDoTranslation.getSideInputMapping((RunnerApi.ParDoPayload)parDoPayload);
        this.observesWindow = doFnSignature.splitRestriction() != null && doFnSignature.splitRestriction().observesWindow() || doFnSignature.newTracker() != null && doFnSignature.newTracker().observesWindow() || doFnSignature.getSize() != null && doFnSignature.getSize().observesWindow() || !this.sideInputMapping.isEmpty();
        this.mutableArgumentProvider = this.observesWindow ? new TruncateSizedRestrictionWindowObservingArgumentProvider() : new TruncateSizedRestrictionNonWindowObservingArgumentProvider();
        this.mainInputId = ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)pTransform);
        RunnerApi.PCollection mainInput = components.getPcollectionsOrThrow(pTransform.getInputsOrThrow(this.mainInputId));
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)components).withPipeline(Pipeline.create());
        Coder inputCoder = rehydratedComponents.getCoder(mainInput.getCoderId());
        Coder windowCoder = rehydratedComponents.getWindowingStrategy(mainInput.getWindowingStrategyId()).getWindowFn().windowCoder();
        this.fullInputCoder = (Coder)WindowedValues.getFullCoder((Coder)inputCoder, (Coder)windowCoder);
    }

    @Override
    public @UnknownKeyFor @Nullable @Initialized Void getCurrentKey() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BoundedWindow getCurrentWindow() {
        return (BoundedWindow)Preconditions.checkStateNotNull((Object)this.currentWindow, (Object)"Attempt to access window outside windowed element processing context.");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedWindow> getCurrentWindows() {
        return (List)Preconditions.checkStateNotNull(this.currentWindows, (Object)"Attempt to access window collection outside windowed element processing context.");
    }

    public @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> getCurrentElement() {
        return (WindowedValue)Preconditions.checkStateNotNull(this.currentElement, (Object)"Attempt to access element outside element processing context.");
    }

    private RestrictionT getCurrentRestriction() {
        return (RestrictionT)Preconditions.checkStateNotNull(this.currentRestriction, (Object)"Attempt to access restriction outside element processing context.");
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCurrentTracker() {
        return (RestrictionTracker)Preconditions.checkStateNotNull(this.currentTracker, (Object)"Attempt to access restriction tracker state outside element processing context.");
    }

    private WatermarkEstimatorStateT getCurrentWatermarkEstimatorState() {
        Preconditions.checkStateNotNull(this.currentWatermarkEstimatorState, (Object)"Attempt to access watermark estimator state outside element processing context.");
        return (WatermarkEstimatorStateT)this.currentWatermarkEstimatorState.get();
    }

    void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>> elem) {
        if (this.observesWindow) {
            this.processElementForWindowObservingTruncateRestriction(elem);
        } else {
            this.processElementForTruncateRestriction(elem);
        }
    }

    @Nullable @UnknownKeyFor @Initialized HandlesSplits.SplitResult trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder, @UnknownKeyFor @NonNull @Initialized HandlesSplits splitDelegate) {
        if (this.observesWindow) {
            return this.trySplitForWindowObservingTruncateRestriction(fractionOfRemainder, splitDelegate);
        }
        return splitDelegate.trySplit(fractionOfRemainder);
    }

    private void processElementForTruncateRestriction(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>> elem) {
        this.currentElement = elem.withValue(((KV)((KV)elem.getValue()).getKey()).getKey());
        this.currentRestriction = ((KV)((KV)((KV)elem.getValue()).getKey()).getValue()).getKey();
        this.currentWatermarkEstimatorState = Holder.of((Object)((KV)((KV)((KV)elem.getValue()).getKey()).getValue()).getValue());
        this.currentTracker = RestrictionTrackers.synchronize((RestrictionTracker)this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider));
        try {
            RestrictionTracker.TruncateResult truncatedRestriction = this.doFnInvoker.invokeTruncateRestriction((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
            if (truncatedRestriction != null) {
                this.mutableArgumentProvider.output(truncatedRestriction.getTruncatedRestriction());
            }
        }
        finally {
            this.currentTracker = null;
            this.currentElement = null;
            this.currentRestriction = null;
            this.currentWatermarkEstimatorState = null;
        }
        this.stateAccessor.finalizeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementForWindowObservingTruncateRestriction(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>> elem) {
        this.currentElement = elem.withValue(((KV)((KV)elem.getValue()).getKey()).getKey());
        this.windowCurrentIndex = -1;
        this.windowStopIndex = elem.getWindows().size();
        this.currentWindows = ImmutableList.copyOf((Collection)elem.getWindows());
        while (true) {
            Object object = this.splitLock;
            synchronized (object) {
                ++this.windowCurrentIndex;
                if (this.windowCurrentIndex >= this.windowStopIndex) {
                    this.windowCurrentIndex = -1;
                    this.windowStopIndex = 0;
                    this.currentElement = null;
                    this.currentWindows = null;
                    this.currentRestriction = null;
                    this.currentWatermarkEstimatorState = null;
                    this.currentWindow = null;
                    this.currentTracker = null;
                    this.currentWatermarkEstimator = null;
                    this.initialWatermark = null;
                    break;
                }
                this.currentRestriction = ((KV)((KV)((KV)elem.getValue()).getKey()).getValue()).getKey();
                this.currentWatermarkEstimatorState = Holder.of((Object)((KV)((KV)((KV)elem.getValue()).getKey()).getValue()).getValue());
                this.currentWindow = (BoundedWindow)((List)Preconditions.checkStateNotNull(this.currentWindows, (Object)"internal error: currentWindows is null during element processing")).get(this.windowCurrentIndex);
                this.currentTracker = RestrictionTrackers.synchronize((RestrictionTracker)this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider));
                this.currentWatermarkEstimator = WatermarkEstimators.threadSafe((WatermarkEstimator)this.doFnInvoker.invokeNewWatermarkEstimator((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider));
                this.initialWatermark = (Instant)this.currentWatermarkEstimator.getWatermarkAndState().getKey();
            }
            RestrictionTracker.TruncateResult truncatedRestriction = this.doFnInvoker.invokeTruncateRestriction((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
            if (truncatedRestriction == null) continue;
            this.mutableArgumentProvider.output(truncatedRestriction.getTruncatedRestriction());
        }
        this.stateAccessor.finalizeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized RestrictionTracker.Progress getProgressFromWindowObservingTruncate(@UnknownKeyFor @NonNull @Initialized double elementCompleted) {
        Object object = this.splitLock;
        synchronized (object) {
            if (this.currentWindow != null) {
                return ProgressUtils.scaleProgress(RestrictionTracker.Progress.from((double)elementCompleted, (double)(1.0 - elementCompleted)), this.windowCurrentIndex, this.windowStopIndex);
            }
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized WindowedSplitResult calculateRestrictionSize(final @UnknownKeyFor @NonNull @Initialized WindowedSplitResult splitResult, @UnknownKeyFor @NonNull @Initialized String errorContext) {
        double fullSize = splitResult.getResidualInUnprocessedWindowsRoot() == null && splitResult.getPrimaryInFullyProcessedWindowsRoot() == null ? 0.0 : this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider, errorContext){

            public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentRestriction();
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                return SplittableTruncateSizedRestrictionsDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
            }
        });
        double primarySize = splitResult.getPrimarySplitRoot() == null ? 0.0 : this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider, errorContext){

            public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                WindowedValue<?> splitRoot = splitResult.getPrimarySplitRoot();
                return ((KV)((KV)splitRoot.getValue()).getValue()).getKey();
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                return SplittableTruncateSizedRestrictionsDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
            }
        });
        double residualSize = splitResult.getResidualSplitRoot() == null ? 0.0 : this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider, errorContext){

            public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                WindowedValue<?> splitRoot = splitResult.getResidualSplitRoot();
                return ((KV)((KV)splitRoot.getValue()).getValue()).getKey();
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                return SplittableTruncateSizedRestrictionsDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
            }
        });
        return WindowedSplitResult.forRoots(splitResult.getPrimaryInFullyProcessedWindowsRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getPrimaryInFullyProcessedWindowsRoot().getValue(), (Object)fullSize), (Instant)splitResult.getPrimaryInFullyProcessedWindowsRoot().getTimestamp(), (Collection)splitResult.getPrimaryInFullyProcessedWindowsRoot().getWindows(), (PaneInfo)splitResult.getPrimaryInFullyProcessedWindowsRoot().getPaneInfo()), splitResult.getPrimarySplitRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getPrimarySplitRoot().getValue(), (Object)primarySize), (Instant)splitResult.getPrimarySplitRoot().getTimestamp(), (Collection)splitResult.getPrimarySplitRoot().getWindows(), (PaneInfo)splitResult.getPrimarySplitRoot().getPaneInfo()), splitResult.getResidualSplitRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getResidualSplitRoot().getValue(), (Object)residualSize), (Instant)splitResult.getResidualSplitRoot().getTimestamp(), (Collection)splitResult.getResidualSplitRoot().getWindows(), (PaneInfo)splitResult.getResidualSplitRoot().getPaneInfo()), splitResult.getResidualInUnprocessedWindowsRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getResidualInUnprocessedWindowsRoot().getValue(), (Object)fullSize), (Instant)splitResult.getResidualInUnprocessedWindowsRoot().getTimestamp(), (Collection)splitResult.getResidualInUnprocessedWindowsRoot().getWindows(), (PaneInfo)splitResult.getResidualInUnprocessedWindowsRoot().getPaneInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable @UnknownKeyFor @Initialized HandlesSplits.SplitResult trySplitForWindowObservingTruncateRestriction(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder, @UnknownKeyFor @NonNull @Initialized HandlesSplits splitDelegate) {
        HandlesSplits.SplitResult downstreamSplitResult;
        WindowedSplitResult windowedSplitResult;
        Object object = this.splitLock;
        synchronized (object) {
            if (this.currentWindow == null) {
                return null;
            }
            SplitResultsWithStopIndex splitResult = SplittableTruncateSizedRestrictionsDoFnRunner.computeSplitForTruncate(this.getCurrentElement(), this.getCurrentRestriction(), this.getCurrentWindow(), this.getCurrentWindows(), this.getCurrentWatermarkEstimatorState(), fractionOfRemainder, splitDelegate, this.windowCurrentIndex, this.windowStopIndex);
            if (splitResult == null) {
                return null;
            }
            this.windowStopIndex = splitResult.getNewWindowStopIndex();
            windowedSplitResult = this.calculateRestrictionSize(splitResult.getWindowSplit(), "beam:transform:sdf_truncate_sized_restrictions:v1/GetSize");
            downstreamSplitResult = splitResult.getDownstreamSplit();
        }
        return SplittableTruncateSizedRestrictionsDoFnRunner.constructSplitResult(windowedSplitResult, downstreamSplitResult, this.fullInputCoder, (Instant)Preconditions.checkStateNotNull((Object)this.initialWatermark, (Object)"Attempt to construct split result without initial watermark"), this.pTransformId, this.mainInputId, this.pTransform.getOutputsMap().keySet());
    }

    private static <WatermarkEstimatorStateT> @UnknownKeyFor @NonNull @Initialized WindowedSplitResult computeWindowSplitResult(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> currentElement, @UnknownKeyFor @NonNull @Initialized Object currentRestriction, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, WatermarkEstimatorStateT currentWatermarkEstimatorState, @UnknownKeyFor @NonNull @Initialized int toIndex, @UnknownKeyFor @NonNull @Initialized int fromIndex, @UnknownKeyFor @NonNull @Initialized int stopWindowIndex) {
        List<BoundedWindow> primaryFullyProcessedWindows = windows.subList(0, toIndex);
        List<BoundedWindow> residualUnprocessedWindows = windows.subList(fromIndex, stopWindowIndex);
        WindowedSplitResult windowedSplitResult = WindowedSplitResult.forRoots(primaryFullyProcessedWindows.isEmpty() ? null : WindowedValues.of((Object)KV.of((Object)currentElement.getValue(), (Object)KV.of((Object)currentRestriction, currentWatermarkEstimatorState)), (Instant)currentElement.getTimestamp(), primaryFullyProcessedWindows, (PaneInfo)currentElement.getPaneInfo()), null, null, residualUnprocessedWindows.isEmpty() ? null : WindowedValues.of((Object)KV.of((Object)currentElement.getValue(), (Object)KV.of((Object)currentRestriction, currentWatermarkEstimatorState)), (Instant)currentElement.getTimestamp(), residualUnprocessedWindows, (PaneInfo)currentElement.getPaneInfo()));
        return windowedSplitResult;
    }

    @VisibleForTesting
    static <WatermarkEstimatorStateT> @Nullable @UnknownKeyFor @Initialized SplitResultsWithStopIndex computeSplitForTruncate(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> element, @UnknownKeyFor @NonNull @Initialized Object restriction, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, WatermarkEstimatorStateT watermarkEstimatorState, @UnknownKeyFor @NonNull @Initialized double fractionOfRemainder, @UnknownKeyFor @NonNull @Initialized HandlesSplits splitDelegate, @UnknownKeyFor @NonNull @Initialized int currentWindowIndex, @UnknownKeyFor @NonNull @Initialized int stopWindowIndex) {
        WindowedSplitResult windowedSplitResult;
        int newWindowStopIndex;
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((splitDelegate != null ? 1 : 0) != 0);
        HandlesSplits.SplitResult downstreamSplitResult = null;
        if (currentWindowIndex != stopWindowIndex - 1) {
            double elementCompleted = splitDelegate.getProgress();
            RestrictionTracker.Progress elementProgress = RestrictionTracker.Progress.from((double)elementCompleted, (double)(1.0 - elementCompleted));
            RestrictionTracker.Progress scaledProgress = ProgressUtils.scaleProgress(elementProgress, currentWindowIndex, stopWindowIndex);
            double scaledFractionOfRemainder = scaledProgress.getWorkRemaining() * fractionOfRemainder;
            if (scaledFractionOfRemainder >= elementProgress.getWorkRemaining()) {
                newWindowStopIndex = (int)Math.min((long)(stopWindowIndex - 1), (long)currentWindowIndex + Math.max(1L, Math.round((elementProgress.getWorkCompleted() + scaledFractionOfRemainder) / (elementProgress.getWorkCompleted() + elementProgress.getWorkRemaining()))));
                windowedSplitResult = SplittableTruncateSizedRestrictionsDoFnRunner.computeWindowSplitResult(element, restriction, windows, watermarkEstimatorState, newWindowStopIndex, newWindowStopIndex, stopWindowIndex);
            } else {
                downstreamSplitResult = splitDelegate.trySplit(scaledFractionOfRemainder);
                newWindowStopIndex = currentWindowIndex + 1;
                int toIndex = downstreamSplitResult == null ? newWindowStopIndex : currentWindowIndex;
                windowedSplitResult = SplittableTruncateSizedRestrictionsDoFnRunner.computeWindowSplitResult(element, restriction, windows, watermarkEstimatorState, toIndex, newWindowStopIndex, stopWindowIndex);
            }
        } else {
            newWindowStopIndex = stopWindowIndex;
            downstreamSplitResult = splitDelegate.trySplit(fractionOfRemainder);
            if (downstreamSplitResult == null) {
                return null;
            }
            windowedSplitResult = SplittableTruncateSizedRestrictionsDoFnRunner.computeWindowSplitResult(element, restriction, windows, watermarkEstimatorState, currentWindowIndex, stopWindowIndex, stopWindowIndex);
        }
        return SplitResultsWithStopIndex.of(windowedSplitResult, downstreamSplitResult, newWindowStopIndex);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized HandlesSplits.SplitResult constructSplitResult(@Nullable @UnknownKeyFor @Initialized WindowedSplitResult windowedSplitResult, @Nullable @UnknownKeyFor @Initialized HandlesSplits.SplitResult downstreamElementSplit, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fullInputCoder, @UnknownKeyFor @NonNull @Initialized Instant initialWatermark, @UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized String mainInputId, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> outputIds) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((windowedSplitResult == null || windowedSplitResult.getResidualSplitRoot() == null || downstreamElementSplit == null ? 1 : 0) != 0);
        ArrayList<BeamFnApi.BundleApplication> primaryRoots = new ArrayList<BeamFnApi.BundleApplication>();
        ArrayList<BeamFnApi.DelayedBundleApplication> residualRoots = new ArrayList<BeamFnApi.DelayedBundleApplication>();
        if (windowedSplitResult != null && windowedSplitResult.getPrimaryInFullyProcessedWindowsRoot() != null) {
            ByteStringOutputStream primaryInOtherWindowsBytes = new ByteStringOutputStream();
            try {
                fullInputCoder.encode(windowedSplitResult.getPrimaryInFullyProcessedWindowsRoot(), (OutputStream)primaryInOtherWindowsBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BeamFnApi.BundleApplication.Builder primaryApplicationInOtherWindows = BeamFnApi.BundleApplication.newBuilder().setTransformId(pTransformId).setInputId(mainInputId).setElement(primaryInOtherWindowsBytes.toByteString());
            primaryRoots.add(primaryApplicationInOtherWindows.build());
        }
        if (windowedSplitResult != null && windowedSplitResult.getResidualInUnprocessedWindowsRoot() != null) {
            ByteStringOutputStream bytesOut = new ByteStringOutputStream();
            try {
                fullInputCoder.encode(windowedSplitResult.getResidualInUnprocessedWindowsRoot(), (OutputStream)bytesOut);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BeamFnApi.BundleApplication.Builder residualInUnprocessedWindowsRoot = BeamFnApi.BundleApplication.newBuilder().setTransformId(pTransformId).setInputId(mainInputId).setElement(bytesOut.toByteString());
            HashMap<String, Timestamp> outputWatermarkMapForUnprocessedWindows = new HashMap<String, Timestamp>();
            if (!initialWatermark.equals((Object)GlobalWindow.TIMESTAMP_MIN_VALUE)) {
                Timestamp outputWatermark = Timestamp.newBuilder().setSeconds(initialWatermark.getMillis() / 1000L).setNanos((int)(initialWatermark.getMillis() % 1000L) * 1000000).build();
                for (String outputId : outputIds) {
                    outputWatermarkMapForUnprocessedWindows.put(outputId, outputWatermark);
                }
            }
            residualInUnprocessedWindowsRoot.putAllOutputWatermarks(outputWatermarkMapForUnprocessedWindows);
            residualRoots.add(BeamFnApi.DelayedBundleApplication.newBuilder().setApplication(residualInUnprocessedWindowsRoot).build());
        }
        if (downstreamElementSplit != null) {
            primaryRoots.add((BeamFnApi.BundleApplication)Iterables.getOnlyElement(downstreamElementSplit.getPrimaryRoots()));
            residualRoots.add((BeamFnApi.DelayedBundleApplication)Iterables.getOnlyElement(downstreamElementSplit.getResidualRoots()));
        }
        return HandlesSplits.SplitResult.of(primaryRoots, residualRoots);
    }

    private <T> void outputTo(@UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> consumer, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
        if (this.currentWatermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
            ((TimestampObservingWatermarkEstimator)this.currentWatermarkEstimator).observeTimestamp(output.getTimestamp());
        }
        try {
            consumer.accept(output);
        }
        catch (Throwable t) {
            throw UserCodeException.wrap((Throwable)t);
        }
    }

    private void tearDown() {
        this.doFnInvoker.invokeTeardown();
    }

    private static class SplitDelegatingFnDataReceiver<@UnknownKeyFor InputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor WatermarkEstimatorStateT>
    implements FnDataReceiver<WindowedValue<KV<KV<InputT, KV<RestrictionT, WatermarkEstimatorStateT>>, Double>>>,
    HandlesSplits {
        private final @UnknownKeyFor @NonNull @Initialized HandlesSplits splitDelegate;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SplittableTruncateSizedRestrictionsDoFnRunner<InputT, RestrictionT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, WatermarkEstimatorStateT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> runner;

        public SplitDelegatingFnDataReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SplittableTruncateSizedRestrictionsDoFnRunner<InputT, RestrictionT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, WatermarkEstimatorStateT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> runner, @UnknownKeyFor @NonNull @Initialized HandlesSplits splitDelegate) {
            this.runner = runner;
            this.splitDelegate = splitDelegate;
        }

        public void accept(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>> input) {
            this.runner.processElement(input);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized HandlesSplits.SplitResult trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            return this.runner.trySplit(fractionOfRemainder, this.splitDelegate);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getProgress() {
            double totalWork;
            double delegateProgress = this.splitDelegate.getProgress();
            if (!((SplittableTruncateSizedRestrictionsDoFnRunner)this.runner).observesWindow) {
                return delegateProgress;
            }
            RestrictionTracker.Progress progress = ((SplittableTruncateSizedRestrictionsDoFnRunner)this.runner).getProgressFromWindowObservingTruncate(delegateProgress);
            if (progress != null && (totalWork = progress.getWorkCompleted() + progress.getWorkRemaining()) > 0.0) {
                return progress.getWorkCompleted() / totalWork;
            }
            return 0.0;
        }
    }

    private abstract class TruncateSizedRestrictionArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT>
    implements DoFn.OutputReceiver<RestrictionT> {
        private TruncateSizedRestrictionArgumentProvider() {
        }

        protected @UnknownKeyFor @NonNull @Initialized double getSize(final RestrictionT subrestriction) {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>((DoFnInvoker.ArgumentProvider)this, this.getErrorContext() + "/GetSize"){

                public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                    return subrestriction;
                }

                public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getTimestamp();
                }

                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                    return SplittableTruncateSizedRestrictionsDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
                }
            });
        }

        public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
            return "TruncateRestriction";
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getPaneInfo();
        }

        public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getValue();
        }

        public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int index) {
            SerializableFunction converter = (SerializableFunction)SplittableTruncateSizedRestrictionsDoFnRunner.this.doFnSchemaInformation.getElementConverters().get(index);
            return converter.apply(SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getValue());
        }

        public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getTimestamp();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Object restriction() {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentRestriction();
        }

        public @UnknownKeyFor @NonNull @Initialized Object watermarkEstimatorState() {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentWatermarkEstimatorState();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentTracker();
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.pipelineOptions;
        }

        public void outputWithTimestamp(RestrictionT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            throw new UnsupportedOperationException("Cannot outputWithTimestamp from TruncateRestriction");
        }

        public void outputWindowedValue(RestrictionT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            throw new UnsupportedOperationException("Cannot outputWindowedValue from TruncateRestriction");
        }
    }

    private class TruncateSizedRestrictionNonWindowObservingArgumentProvider
    extends TruncateSizedRestrictionArgumentProvider {
        private TruncateSizedRestrictionNonWindowObservingArgumentProvider() {
        }

        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<RestrictionT> builder(RestrictionT value) {
            return WindowedValues.builder(SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement()).withValue(value).setReceiver(windowedValue -> {
                double size = this.getSize(windowedValue.getValue());
                SplittableTruncateSizedRestrictionsDoFnRunner.this.outputTo(SplittableTruncateSizedRestrictionsDoFnRunner.this.mainOutputConsumer, SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().withValue((Object)KV.of((Object)KV.of((Object)SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getValue(), (Object)KV.of((Object)windowedValue.getValue(), (Object)SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentWatermarkEstimatorState())), (Object)size)));
            });
        }
    }

    private class TruncateSizedRestrictionWindowObservingArgumentProvider
    extends TruncateSizedRestrictionArgumentProvider {
        private TruncateSizedRestrictionWindowObservingArgumentProvider() {
        }

        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<RestrictionT> builder(RestrictionT value) {
            return WindowedValues.builder(SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement()).withValue(value).setWindow(SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentWindow()).setReceiver(windowedValue -> {
                double size = this.getSize(windowedValue.getValue());
                SplittableTruncateSizedRestrictionsDoFnRunner.this.outputTo(SplittableTruncateSizedRestrictionsDoFnRunner.this.mainOutputConsumer, windowedValue.withValue((Object)KV.of((Object)KV.of((Object)SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentElement().getValue(), (Object)KV.of((Object)windowedValue.getValue(), (Object)SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentWatermarkEstimatorState())), (Object)size)));
            });
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentWindow();
        }

        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
            PCollectionView pCollectionView = (PCollectionView)Preconditions.checkStateNotNull((Object)((PCollectionView)SplittableTruncateSizedRestrictionsDoFnRunner.this.sideInputMapping.get(tagId)), (String)"Side input tag not found: %s", (Object)tagId);
            return SplittableTruncateSizedRestrictionsDoFnRunner.this.stateAccessor.get(pCollectionView, SplittableTruncateSizedRestrictionsDoFnRunner.this.getCurrentWindow());
        }
    }

    static class Factory
    implements PTransformRunnerFactory {
        Factory() {
        }

        @Override
        public final void addRunnerForPTransform(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.addRunnerForTruncateSizedRestrictions(context);
        }

        private <InputT, RestrictionT, PositionT, WatermarkEstimatorStateT, OutputT> void addRunnerForTruncateSizedRestrictions(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FnApiStateAccessor<Void> stateAccessor = FnApiStateAccessor.Factory.factoryForPTransformContext(context).create();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((context.getPTransform().getOutputsMap().size() == 1 ? 1 : 0) != 0, (String)"TruncateSizedRestrictions expects exact one output, but got: ", (int)context.getPTransform().getOutputsMap().size());
            TupleTag mainOutputTag = new TupleTag((String)Iterables.getOnlyElement(context.getPTransform().getOutputsMap().keySet()));
            FnDataReceiver mainOutputConsumer = context.getPCollectionConsumer(context.getPTransform().getOutputsOrThrow(mainOutputTag.getId()));
            SplittableTruncateSizedRestrictionsDoFnRunner runner = new SplittableTruncateSizedRestrictionsDoFnRunner(context.getPipelineOptions(), context.getPTransformId(), context.getPTransform(), context.getComponents(), mainOutputConsumer, stateAccessor);
            SplitDelegatingFnDataReceiver mainInputConsumer = mainOutputConsumer instanceof HandlesSplits ? new SplitDelegatingFnDataReceiver(runner, (HandlesSplits)mainOutputConsumer) : runner::processElement;
            context.addPCollectionConsumer(context.getPTransform().getInputsOrThrow(ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)context.getPTransform())), mainInputConsumer);
            context.addTearDownFunction(() -> runner.tearDown());
        }
    }

    @AutoService(value={PTransformRunnerFactory.Registrar.class})
    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory> getPTransformRunnerFactories() {
            Factory factory = new Factory();
            return ImmutableMap.builder().put((Object)"beam:transform:sdf_truncate_sized_restrictions:v1", (Object)factory).build();
        }
    }
}

