/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.logging;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.MDC;

public class QuotaEvent {
    private static @UnknownKeyFor @NonNull @Initialized boolean enabled = false;

    public static void setEnabled(@UnknownKeyFor @NonNull @Initialized boolean enabled) {
        QuotaEvent.enabled = enabled;
    }

    public static class Builder {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> data = new HashMap<String, String>();

        public @UnknownKeyFor @NonNull @Initialized Builder withMessageText(@UnknownKeyFor @NonNull @Initialized String messageText) {
            this.data.put("quota_event.message_text", messageText);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withFullResourceName(@UnknownKeyFor @NonNull @Initialized String fullResourceName) {
            this.data.put("quota_event.full_resource_name", fullResourceName);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withQuotaName(@UnknownKeyFor @NonNull @Initialized String quotaName) {
            this.data.put("quota_event.quota_name", quotaName);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withOperation(@UnknownKeyFor @NonNull @Initialized String operation) {
            this.data.put("quota_event.operation", operation);
            return this;
        }

        @Nullable
        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized QuotaEventCloseable create() {
            if (!enabled) {
                return null;
            }
            this.data.forEach(MDC::put);
            return new QuotaEventCloseable(this.data);
        }
    }

    public static class QuotaEventCloseable
    implements AutoCloseable {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> data;

        public QuotaEventCloseable(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> data) {
            this.data = data;
        }

        @Override
        public void close() {
            if (!enabled) {
                return;
            }
            for (String key : this.data.keySet()) {
                MDC.remove((String)key);
            }
        }
    }
}

