/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.state.FnApiStateAccessor;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SplittablePairWithRestrictionDoFnRunner<@UnknownKeyFor InputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor WatermarkEstimatorStateT, @UnknownKeyFor OutputT>
implements FnApiStateAccessor.MutatingStateContext<Void, BoundedWindow> {
    private final @UnknownKeyFor @NonNull @Initialized boolean observesWindow;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>>> mainOutputConsumer;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized FnApiStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stateAccessor;
    private final @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> doFnInvoker;
    private final @UnknownKeyFor @NonNull @Initialized SplittablePairWithRestrictionDoFnRunner. @UnknownKeyFor @NonNull @Initialized PairWithRestrictionArgumentProvider mutableArgumentProvider;
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;

    SplittablePairWithRestrictionDoFnRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getPCollectionConsumer, @UnknownKeyFor @NonNull @Initialized FnApiStateAccessor<@UnknownKeyFor @Nullable @Initialized Void> stateAccessor) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pipelineOptions = pipelineOptions;
        RunnerApi.ParDoPayload parDoPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)pTransform.getSpec().getPayload());
        DoFn doFn = ParDoTranslation.getDoFn((RunnerApi.ParDoPayload)parDoPayload);
        DoFnSignature doFnSignature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor((DoFn)doFn, (PipelineOptions)pipelineOptions);
        this.doFnSchemaInformation = ParDoTranslation.getSchemaInformation((RunnerApi.ParDoPayload)parDoPayload);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((pTransform.getOutputsMap().size() == 1 ? 1 : 0) != 0, (String)"PairWithRestriction expects exact one output, but got: ", (int)pTransform.getOutputsMap().size());
        TupleTag mainOutputTag = new TupleTag((String)Iterables.getOnlyElement(pTransform.getOutputsMap().keySet()));
        FnDataReceiver<WindowedValue<?>> mainOutputConsumer = getPCollectionConsumer.apply(pTransform.getOutputsOrThrow(mainOutputTag.getId()));
        this.mainOutputConsumer = mainOutputConsumer;
        this.sideInputMapping = ParDoTranslation.getSideInputMapping((RunnerApi.ParDoPayload)parDoPayload);
        this.observesWindow = doFnSignature.getInitialRestriction() != null && doFnSignature.getInitialRestriction().observesWindow() || !this.sideInputMapping.isEmpty();
        this.mutableArgumentProvider = this.observesWindow ? new WindowObservingProcessBundleContext() : new NonWindowObservingProcessBundleContext();
        this.stateAccessor = stateAccessor;
    }

    private void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        if (this.observesWindow) {
            this.processElementForWindowObservingPairWithRestriction(elem);
        } else {
            this.processElementForPairWithRestriction(elem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementForPairWithRestriction(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        this.mutableArgumentProvider.currentElement = elem;
        try {
            Object currentRestriction = this.doFnInvoker.invokeGetInitialRestriction((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
            Object watermarkEstimatorState = this.doFnInvoker.invokeGetInitialWatermarkEstimatorState((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
            this.outputTo(this.mainOutputConsumer, elem.withValue((Object)KV.of((Object)elem.getValue(), (Object)KV.of((Object)currentRestriction, (Object)watermarkEstimatorState))));
        }
        finally {
            this.mutableArgumentProvider.currentElement = null;
        }
        this.stateAccessor.finalizeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementForWindowObservingPairWithRestriction(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        this.mutableArgumentProvider.currentElement = elem;
        try {
            for (BoundedWindow boundedWindow : elem.getWindows()) {
                this.mutableArgumentProvider.currentWindow = boundedWindow;
                Object currentRestriction = this.doFnInvoker.invokeGetInitialRestriction((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
                Object watermarkEstimatorState = this.doFnInvoker.invokeGetInitialWatermarkEstimatorState((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
                this.outputTo(this.mainOutputConsumer, WindowedValues.of((Object)KV.of((Object)elem.getValue(), (Object)KV.of((Object)currentRestriction, (Object)watermarkEstimatorState)), (Instant)elem.getTimestamp(), (BoundedWindow)boundedWindow, (PaneInfo)elem.getPaneInfo()));
            }
        }
        finally {
            this.mutableArgumentProvider.currentElement = null;
            this.mutableArgumentProvider.currentWindow = null;
        }
        this.stateAccessor.finalizeState();
    }

    private void tearDown() {
        this.doFnInvoker.invokeTeardown();
    }

    private <T> void outputTo(@UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> consumer, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
        try {
            consumer.accept(output);
        }
        catch (Throwable t) {
            throw UserCodeException.wrap((Throwable)t);
        }
    }

    @Override
    public @UnknownKeyFor @Nullable @Initialized Void getCurrentKey() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BoundedWindow getCurrentWindow() {
        return this.mutableArgumentProvider.getCurrentWindowOrFail();
    }

    private class NonWindowObservingProcessBundleContext
    extends PairWithRestrictionArgumentProvider {
        private NonWindowObservingProcessBundleContext() {
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            throw new IllegalStateException("Attempt to access window in non-window-observing context. This is an internal error.");
        }

        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
            throw new IllegalStateException("Attempt to access side input in non-window-observing context. This is an internal error.");
        }
    }

    private class WindowObservingProcessBundleContext
    extends PairWithRestrictionArgumentProvider {
        private WindowObservingProcessBundleContext() {
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            return this.getCurrentWindowOrFail();
        }

        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
            PCollectionView pCollectionView = (PCollectionView)Preconditions.checkStateNotNull((Object)((PCollectionView)SplittablePairWithRestrictionDoFnRunner.this.sideInputMapping.get(tagId)), (String)"Side input tag not found: %s", (Object)tagId);
            return SplittablePairWithRestrictionDoFnRunner.this.stateAccessor.get(pCollectionView, SplittablePairWithRestrictionDoFnRunner.this.getCurrentWindow());
        }
    }

    private abstract class PairWithRestrictionArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private @Nullable @UnknownKeyFor @Initialized WindowedValue<InputT> currentElement;
        private @Nullable @UnknownKeyFor @Initialized BoundedWindow currentWindow;

        private PairWithRestrictionArgumentProvider() {
        }

        protected @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> getCurrentElementOrFail() {
            return (WindowedValue)Preconditions.checkStateNotNull(this.currentElement, (Object)"Attempt to access element outside element processing context.");
        }

        protected @UnknownKeyFor @NonNull @Initialized BoundedWindow getCurrentWindowOrFail() {
            return (BoundedWindow)Preconditions.checkStateNotNull((Object)this.currentWindow, (Object)"Attempt to access window outside element processing context.");
        }

        public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
            return "GetInitialRestriction";
        }

        public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.getCurrentElementOrFail().getValue();
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.getCurrentElementOrFail().getPaneInfo();
        }

        public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int index) {
            SerializableFunction converter = (SerializableFunction)SplittablePairWithRestrictionDoFnRunner.this.doFnSchemaInformation.getElementConverters().get(index);
            return converter.apply(this.getCurrentElementOrFail().getValue());
        }

        public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.getCurrentElementOrFail().getTimestamp();
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
            return SplittablePairWithRestrictionDoFnRunner.this.pipelineOptions;
        }
    }

    static class Factory
    implements PTransformRunnerFactory {
        Factory() {
        }

        @Override
        public final void addRunnerForPTransform(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.addRunnerForPairWithRestriction(context);
        }

        private void addRunnerForPairWithRestriction(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FnApiStateAccessor<Void> stateAccessor = FnApiStateAccessor.Factory.factoryForPTransformContext(context).create();
            SplittablePairWithRestrictionDoFnRunner runner = new SplittablePairWithRestrictionDoFnRunner(context.getPipelineOptions(), context.getPTransform(), context::getPCollectionConsumer, stateAccessor);
            stateAccessor.setKeyAndWindowContext(runner);
            context.addPCollectionConsumer(context.getPTransform().getInputsOrThrow(ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)context.getPTransform())), x$0 -> runner.processElement(x$0));
            context.addTearDownFunction(() -> runner.tearDown());
        }
    }

    @AutoService(value={PTransformRunnerFactory.Registrar.class})
    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory> getPTransformRunnerFactories() {
            Factory factory = new Factory();
            return ImmutableMap.builder().put((Object)"beam:transform:sdf_pair_with_restriction:v1", (Object)factory).build();
        }
    }
}

