/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.Pair;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class BigQueryFilter
implements BeamSqlTableFilter {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized SqlKind> SUPPORTED_OPS = ImmutableSet.builder().add((Object[])SqlKind.COMPARISON.toArray(new SqlKind[0])).add((Object[])new SqlKind[]{SqlKind.PLUS, SqlKind.MINUS, SqlKind.MOD, SqlKind.DIVIDE, SqlKind.TIMES, SqlKind.LIKE, SqlKind.BETWEEN, SqlKind.CAST, SqlKind.AND, SqlKind.OR}).build();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> supported = new ArrayList<RexNode>();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> unsupported = new ArrayList<RexNode>();

    public BigQueryFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> predicateCNF) {
        for (RexNode node : predicateCNF) {
            if (!node.getType().getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN)) {
                throw new IllegalArgumentException("Predicate node '" + node.getClass().getSimpleName() + "' should be a boolean expression, but was: " + node.getType().getSqlTypeName());
            }
            if (((Boolean)this.isSupported(node).getLeft()).booleanValue()) {
                this.supported.add(node);
                continue;
            }
            this.unsupported.add(node);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> getNotSupported() {
        return this.unsupported;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int numSupported() {
        return BeamSqlTableFilter.expressionsInFilter(this.supported);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> getSupported() {
        return this.supported;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String supStr = "supported{" + this.supported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        String unsupStr = "unsupported{" + this.unsupported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        return "[" + supStr + ", " + unsupStr + "]";
    }

    private @UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized Boolean, @UnknownKeyFor @NonNull @Initialized Integer> isSupported(@UnknownKeyFor @NonNull @Initialized RexNode node) {
        int numberOfInputRefs = 0;
        boolean isSupported = true;
        if (node instanceof RexCall) {
            RexCall compositeNode = (RexCall)node;
            if (!node.getKind().belongsTo(SUPPORTED_OPS)) {
                isSupported = false;
            } else {
                for (RexNode operand : compositeNode.getOperands()) {
                    Pair<Boolean, Integer> childSupported = this.isSupported(operand);
                    if (!node.getKind().belongsTo((Collection)ImmutableSet.of((Object)SqlKind.AND, (Object)SqlKind.OR))) {
                        numberOfInputRefs += ((Integer)childSupported.getRight()).intValue();
                    }
                    isSupported = numberOfInputRefs < 2 && (Boolean)childSupported.getLeft() != false;
                }
            }
        } else if (node instanceof RexInputRef) {
            numberOfInputRefs = 1;
        } else if (!(node instanceof RexLiteral)) {
            throw new UnsupportedOperationException("Encountered an unexpected node type: " + node.getClass().getSimpleName());
        }
        return Pair.of((Object)isSupported, (Object)numberOfInputRefs);
    }
}

