/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.catalog;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.catalog.InMemoryCatalog;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class EmptyCatalogManager
implements CatalogManager {
    private static final @UnknownKeyFor @NonNull @Initialized InMemoryCatalog EMPTY = new InMemoryCatalog("default", (Map<String, String>)ImmutableMap.of());

    @Override
    public void useCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
        if (!EMPTY.name().equalsIgnoreCase(name)) {
            throw new IllegalArgumentException("Catalog not found: " + name);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Catalog currentCatalog() {
        return EMPTY;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Catalog getCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.equalsIgnoreCase(EMPTY.name()) ? EMPTY : null;
    }

    @Override
    public void dropCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
        throw new UnsupportedOperationException("ReadOnlyCatalogManager does not support removing a catalog");
    }

    @Override
    public void registerTableProvider(@UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        throw new UnsupportedOperationException("ReadOnlyCatalogManager does not support registering a table provider");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> tableProviders() {
        return EmptyCatalogManager.EMPTY.tableProviders;
    }

    @Override
    public void createCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        throw new UnsupportedOperationException("ReadOnlyCatalogManager does not support catalog creation");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Catalog> catalogs() {
        return ImmutableSet.of((Object)EMPTY);
    }
}

