/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udf;

import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.sdk.extensions.sql.impl.udf.BeamBuiltinFunctionProvider;
import org.apache.beam.sdk.extensions.sql.impl.udf.UDF;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.function.Strict;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={BeamBuiltinFunctionProvider.class})
public class BuiltinStringFunctions
extends BeamBuiltinFunctionProvider {
    @UDF(funcName="ENDS_WITH", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized Boolean endsWith(@UnknownKeyFor @NonNull @Initialized String str1, @UnknownKeyFor @NonNull @Initialized String str2) {
        return str1.endsWith(str2);
    }

    @UDF(funcName="STARTS_WITH", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized Boolean startsWith(@UnknownKeyFor @NonNull @Initialized String str1, @UnknownKeyFor @NonNull @Initialized String str2) {
        return str1.startsWith(str2);
    }

    @UDF(funcName="LENGTH", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.INT64)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized Long lengthString(@UnknownKeyFor @NonNull @Initialized String str) {
        return str.length();
    }

    @UDF(funcName="LENGTH", parameterArray={Schema.TypeName.BYTES}, returnType=Schema.TypeName.INT64)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized Long lengthBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
        return bytes.length;
    }

    @UDF(funcName="REVERSE", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized String reverseString(@UnknownKeyFor @NonNull @Initialized String str) {
        return new StringBuilder(str).reverse().toString();
    }

    @UDF(funcName="REVERSE", parameterArray={Schema.TypeName.BYTES}, returnType=Schema.TypeName.BYTES)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] reverseBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
        byte[] ret = Arrays.copyOf(bytes, bytes.length);
        ArrayUtils.reverse((byte[])ret);
        return ret;
    }

    @UDF(funcName="FROM_HEX", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.BYTES)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] fromHex(@UnknownKeyFor @NonNull @Initialized String str) {
        try {
            return Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    @UDF(funcName="TO_HEX", parameterArray={Schema.TypeName.BYTES}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized String toHex(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized String lpad(@UnknownKeyFor @NonNull @Initialized String originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength) {
        return this.lpad(originalValue, returnLength, " ");
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64, Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized String lpad(@UnknownKeyFor @NonNull @Initialized String originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength, @UnknownKeyFor @NonNull @Initialized String pattern) {
        if (returnLength < -1L || pattern.isEmpty()) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        if ((long)originalValue.length() == returnLength) {
            return originalValue;
        }
        if ((long)originalValue.length() < returnLength) {
            return StringUtils.leftPad((String)originalValue, (int)Math.toIntExact(returnLength), (String)pattern);
        }
        return originalValue.substring(0, Math.toIntExact(returnLength));
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64}, returnType=Schema.TypeName.BYTES)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] lpad(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength) {
        return this.lpad(originalValue, returnLength, " ".getBytes(StandardCharsets.UTF_8));
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64, Schema.TypeName.BYTES}, returnType=Schema.TypeName.BYTES)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] lpad(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pattern) {
        if (returnLength < -1L || pattern.length == 0) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        int returnLengthInt = Math.toIntExact(returnLength);
        if (originalValue.length == returnLengthInt) {
            return originalValue;
        }
        if (originalValue.length < returnLengthInt) {
            byte[] ret = new byte[returnLengthInt];
            int paddingOff = 0;
            int paddingLeftBytes = returnLengthInt - originalValue.length;
            this.byteArrayPadding(ret, pattern, paddingOff, paddingLeftBytes);
            System.arraycopy(originalValue, 0, ret, returnLengthInt - originalValue.length, originalValue.length);
            return ret;
        }
        byte[] ret = new byte[returnLengthInt];
        System.arraycopy(originalValue, 0, ret, 0, returnLengthInt);
        return ret;
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized String rpad(@UnknownKeyFor @NonNull @Initialized String originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength) {
        return this.lpad(originalValue, returnLength, " ");
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64, Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized String rpad(@UnknownKeyFor @NonNull @Initialized String originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength, @UnknownKeyFor @NonNull @Initialized String pattern) {
        if (returnLength < -1L || pattern.isEmpty()) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        if ((long)originalValue.length() == returnLength) {
            return originalValue;
        }
        if ((long)originalValue.length() < returnLength) {
            return StringUtils.rightPad((String)originalValue, (int)Math.toIntExact(returnLength), (String)pattern);
        }
        return originalValue.substring(0, Math.toIntExact(returnLength));
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64}, returnType=Schema.TypeName.BYTES)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] rpad(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength) {
        return this.lpad(originalValue, returnLength, " ".getBytes(StandardCharsets.UTF_8));
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64, Schema.TypeName.BYTES}, returnType=Schema.TypeName.BYTES)
    @Strict
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] rpad(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] originalValue, @UnknownKeyFor @NonNull @Initialized Long returnLength, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pattern) {
        if (returnLength < -1L || pattern.length == 0) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        int returnLengthInt = Math.toIntExact(returnLength);
        if (originalValue.length == returnLengthInt) {
            return originalValue;
        }
        if (originalValue.length < returnLengthInt) {
            byte[] ret = new byte[returnLengthInt];
            System.arraycopy(originalValue, 0, ret, 0, originalValue.length);
            int paddingOff = originalValue.length;
            int paddingLeftBytes = returnLengthInt - originalValue.length;
            this.byteArrayPadding(ret, pattern, paddingOff, paddingLeftBytes);
            return ret;
        }
        byte[] ret = new byte[returnLengthInt];
        System.arraycopy(originalValue, 0, ret, 0, returnLengthInt);
        return ret;
    }

    private void byteArrayPadding(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dest, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pattern, @UnknownKeyFor @NonNull @Initialized int paddingOff, @UnknownKeyFor @NonNull @Initialized int paddingLeftBytes) {
        while (paddingLeftBytes > 0) {
            if (paddingLeftBytes >= pattern.length) {
                System.arraycopy(pattern, 0, dest, paddingOff, pattern.length);
                paddingLeftBytes -= pattern.length;
                paddingOff += pattern.length;
                continue;
            }
            System.arraycopy(pattern, 0, dest, paddingOff, paddingLeftBytes);
            paddingLeftBytes = 0;
        }
    }
}

