/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlCreate;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SqlCreateDatabase
extends SqlCreate
implements BeamSqlParser.ExecutableStatement {
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("CREATE DATABASE", SqlKind.OTHER_DDL);

    public SqlCreateDatabase(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean replace, @UnknownKeyFor @NonNull @Initialized boolean ifNotExists, @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.databaseName = databaseName;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        ImmutableList.Builder operands = ImmutableList.builder();
        operands.add((Object)this.databaseName);
        return operands.build();
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("DATABASE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        String catalogName;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.databaseName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        ArrayList components = Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)this.databaseName.toString()));
        String string = catalogName = components.size() > 1 ? (String)components.get(components.size() - 2) : null;
        if (!(schema instanceof CatalogManagerSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Attempting to create database '" + this.databaseName + "' with unexpected Calcite Schema of type " + schema.getClass()));
        }
        CatalogManagerSchema catalogManagerSchema = (CatalogManagerSchema)schema;
        CatalogSchema catalogSchema = catalogManagerSchema.getCurrentCatalogSchema();
        if (catalogName != null) {
            Schema overridden = (Schema)Preconditions.checkStateNotNull((Object)catalogManagerSchema.getSubSchema(catalogName), (String)"Could not find Calcite Schema for catalog '%s'.", (Object)catalogName);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)(overridden instanceof CatalogSchema), (String)"Catalog '%s' had unexpected Calcite Schema of type %s. Expected type: %s.", (Object)catalogName, overridden.getClass(), (Object)CatalogSchema.class.getSimpleName());
            catalogSchema = (CatalogSchema)overridden;
        }
        catalogSchema.createDatabase(this.databaseName, this.ifNotExists);
    }
}

