/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.value.AutoValue;
import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.AutoValue_TVFSlidingWindowFn;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDateTime;

@AutoValue
public abstract class TVFSlidingWindowFn
extends NonMergingWindowFn<Object, IntervalWindow> {
    public abstract @UnknownKeyFor @NonNull @Initialized Duration getSize();

    public abstract @UnknownKeyFor @NonNull @Initialized Duration getPeriod();

    public static @UnknownKeyFor @NonNull @Initialized TVFSlidingWindowFn of(@UnknownKeyFor @NonNull @Initialized Duration size, @UnknownKeyFor @NonNull @Initialized Duration period) {
        return new AutoValue_TVFSlidingWindowFn(size, period);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized IntervalWindow> assignWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Row curRow = (Row)c.element();
        ReadableDateTime windowStart = (ReadableDateTime)Preconditions.checkArgumentNotNull((Object)curRow.getDateTime("window_start"), (String)"When assigning a sliding window to row: %s cannot be null", (Object)"window_start");
        ReadableDateTime windowEnd = (ReadableDateTime)Preconditions.checkArgumentNotNull((Object)curRow.getDateTime("window_end"), (String)"When assigning a sliding window to row: %s is null", (Object)"window_end");
        return ImmutableList.of((Object)new IntervalWindow(windowStart.toInstant(), windowEnd.toInstant()));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
        return ((Object)((Object)this)).equals(other);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @NonNull @Initialized IntervalWindow> getDefaultWindowMappingFn() {
        throw new UnsupportedOperationException("TVFSlidingWindow does not support side input windows.");
    }
}

