/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.meta.SystemTables;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schemas;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSystemDbMetadataSchema
implements Schema {
    private final @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager;

    BeamSystemDbMetadataSchema(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String catalogName) {
        Catalog catalog = catalogName.equals("__current_catalog__") ? this.catalogManager.currentCatalog() : (Catalog)Preconditions.checkArgumentNotNull((Object)this.catalogManager.getCatalog(catalogName), (String)"Catalog '%s' does not exist.", (Object)catalogName);
        return BeamCalciteTable.of(SystemTables.databases(catalog, false));
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
        return this.catalogManager.catalogs().stream().map(Catalog::name).collect(Collectors.toSet());
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getSubSchema(@Nullable @UnknownKeyFor @Initialized String name) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
        return Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String s) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String s) {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@Nullable @UnknownKeyFor @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized String s) {
        return Schemas.subSchemaExpression((SchemaPlus)((SchemaPlus)Preconditions.checkStateNotNull((Object)schemaPlus)), (String)s, this.getClass());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion schemaVersion) {
        return this;
    }
}

