/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.SimpleTable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.CustomTableResolver;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TableResolution {
    public static @UnknownKeyFor @NonNull @Initialized Table resolveCalciteTable(@UnknownKeyFor @NonNull @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> tablePath) {
        SchemaPlus subSchema = schemaPlus;
        for (int i = 0; i < tablePath.size() - 1; ++i) {
            if ((subSchema = subSchema.getSubSchema(tablePath.get(i))) != null) continue;
            throw new IllegalStateException(String.format("While resolving table path %s, no sub-schema found for component %s (\"%s\")", tablePath, i, tablePath.get(i)));
        }
        return subSchema.getTable((String)Iterables.getLast(tablePath));
    }

    public static void registerTables(@UnknownKeyFor @NonNull @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> tables) {
        Schema defaultSchema = CalciteSchema.from((SchemaPlus)schemaPlus).schema;
        if (defaultSchema instanceof BeamCalciteSchema && ((BeamCalciteSchema)defaultSchema).getTableProvider() instanceof CustomTableResolver) {
            ((CustomTableResolver)((BeamCalciteSchema)defaultSchema).getTableProvider()).registerKnownTableNames(tables.stream().map(TableName::create).collect(Collectors.toList()));
        }
        for (String subSchemaName : schemaPlus.getSubSchemaNames()) {
            Schema subSchema = CalciteSchema.from((SchemaPlus)schemaPlus.getSubSchema((String)subSchemaName)).schema;
            if (!(subSchema instanceof BeamCalciteSchema) || !(((BeamCalciteSchema)subSchema).getTableProvider() instanceof CustomTableResolver)) continue;
            ((CustomTableResolver)((BeamCalciteSchema)subSchema).getTableProvider()).registerKnownTableNames(tables.stream().map(TableName::create).collect(Collectors.toList()));
        }
    }

    static class SimpleTableWithPath {
        @UnknownKeyFor @NonNull @Initialized SimpleTable table;
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> path;

        SimpleTableWithPath() {
        }

        static @UnknownKeyFor @NonNull @Initialized SimpleTableWithPath of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> path) {
            SimpleTableWithPath tableWithPath = new SimpleTableWithPath();
            tableWithPath.table = new SimpleTable((String)Iterables.getLast(path));
            tableWithPath.path = path;
            return tableWithPath;
        }

        @UnknownKeyFor @NonNull @Initialized SimpleTable getTable() {
            return this.table;
        }

        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPath() {
            return this.path;
        }
    }
}

