/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation.impl;

import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.function.Strict;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.SqlFunctions;

@Internal
public class StringFunctions {
    public static final String SUBSTR_PARAMETER_EXCEED_INTEGER = "SUBSTR function only allows: -2147483648 <= position or length <= 2147483647";
    private static final String JAVA_REGEX_SPECIALS = "[]()|^-+*?{}$\\.";

    @Strict
    public static Boolean startsWith(String str1, String str2) {
        return str1.startsWith(str2);
    }

    @Strict
    public static Boolean endsWith(String str1, String str2) {
        return str1.endsWith(str2);
    }

    @Strict
    public static String concat(String arg) {
        return arg;
    }

    @Strict
    public static String concat(String arg1, String arg2) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2);
    }

    @Strict
    public static String concat(String arg1, String arg2, String arg3) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2, arg3);
    }

    @Strict
    public static String concat(String arg1, String arg2, String arg3, String arg4) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2, arg3, arg4);
    }

    @Strict
    public static String concat(String arg1, String arg2, String arg3, String arg4, String arg5) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2, arg3, arg4, arg5);
    }

    @Strict
    private static String concatIfNotIncludeNull(String ... args) {
        return String.join((CharSequence)"", args);
    }

    @Strict
    public static String replace(String origin, String target, String replacement) {
        if (target.length() == 0) {
            return origin;
        }
        return origin.replace(target, replacement);
    }

    public static String trim(String str) {
        return StringFunctions.trim(str, " ");
    }

    @Strict
    public static String trim(String str, String seek) {
        return SqlFunctions.trim((boolean)true, (boolean)true, (String)seek, (String)str, (boolean)false);
    }

    public static String ltrim(String str) {
        return StringFunctions.ltrim(str, " ");
    }

    @Strict
    public static String ltrim(String str, String seek) {
        return SqlFunctions.trim((boolean)true, (boolean)false, (String)seek, (String)str, (boolean)false);
    }

    public static String rtrim(String str) {
        return StringFunctions.rtrim(str, " ");
    }

    @Strict
    public static String rtrim(String str, String seek) {
        return SqlFunctions.trim((boolean)false, (boolean)true, (String)seek, (String)str, (boolean)false);
    }

    public static String substr(String str, long from, long len) {
        if (from > Integer.MAX_VALUE || len > Integer.MAX_VALUE || from < Integer.MIN_VALUE || len < Integer.MIN_VALUE) {
            throw new RuntimeException(SUBSTR_PARAMETER_EXCEED_INTEGER);
        }
        return SqlFunctions.substring((String)str, (int)((int)from), (int)((int)len));
    }

    @Strict
    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    @Strict
    public static Long charLength(String str) {
        return str.length();
    }

    @Strict
    public static Boolean like(String s, String pattern) {
        String regex = StringFunctions.sqlToRegexLike(pattern, '\\');
        return Pattern.matches(regex, s);
    }

    private static String sqlToRegexLike(String sqlPattern, char escapeChar) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if (c == escapeChar) {
                char nextChar;
                if (i == sqlPattern.length() - 1) {
                    throw new IllegalArgumentException("LIKE pattern ends with a backslash");
                }
                if (JAVA_REGEX_SPECIALS.indexOf(nextChar = sqlPattern.charAt(++i)) >= 0) {
                    javaPattern.append('\\');
                }
                javaPattern.append(nextChar);
                continue;
            }
            if (c == '_') {
                javaPattern.append('.');
                continue;
            }
            if (c == '%') {
                javaPattern.append("(?s:.*)");
                continue;
            }
            if (JAVA_REGEX_SPECIALS.indexOf(c) >= 0) {
                javaPattern.append('\\');
            }
            javaPattern.append(c);
        }
        return javaPattern.toString();
    }
}

