/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.unnest;

import java.util.List;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Convention;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelInput;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.SingleRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.MapSqlType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;

public class ZetaSqlUnnest
extends SingleRel {
    public final boolean withOrdinality;

    public ZetaSqlUnnest(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean withOrdinality) {
        super(cluster, traitSet, input);
        this.withOrdinality = withOrdinality;
    }

    public ZetaSqlUnnest(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getBoolean("withOrdinality", false));
    }

    public static ZetaSqlUnnest create(RelTraitSet traitSet, RelNode input, boolean withOrdinality) {
        RelOptCluster cluster = input.getCluster();
        return new ZetaSqlUnnest(cluster, traitSet, input, withOrdinality);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("withOrdinality", (Object)this.withOrdinality, this.withOrdinality);
    }

    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, (RelNode)ZetaSqlUnnest.sole(inputs));
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        assert (traitSet.containsIfApplicable((RelTrait)Convention.NONE));
        return new ZetaSqlUnnest(this.getCluster(), traitSet, input, this.withOrdinality);
    }

    protected RelDataType deriveRowType() {
        return ZetaSqlUnnest.deriveUncollectRowType(this.input, this.withOrdinality);
    }

    public static RelDataType deriveUncollectRowType(RelNode rel, boolean withOrdinality) {
        RelDataType inputType = rel.getRowType();
        assert (inputType.isStruct()) : inputType + " is not a struct";
        List fields = inputType.getFieldList();
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        if (fields.size() == 1 && ((RelDataTypeField)fields.get(0)).getType().getSqlTypeName() == SqlTypeName.ANY) {
            return builder.add(((RelDataTypeField)fields.get(0)).getName(), SqlTypeName.ANY).nullable(true).build();
        }
        for (RelDataTypeField field : fields) {
            if (field.getType() instanceof MapSqlType) {
                builder.add("KEY", field.getType().getKeyType());
                builder.add("VALUE", field.getType().getValueType());
                continue;
            }
            RelDataType ret = field.getType().getComponentType();
            assert (null != ret);
            builder.add(SqlUtil.deriveAliasFromOrdinal((int)field.getIndex()), ret);
        }
        if (withOrdinality) {
            builder.add("ORDINALITY", SqlTypeName.INTEGER);
        }
        return builder.build();
    }
}

