/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.zetasql.Analyzer;
import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.Function;
import com.google.zetasql.FunctionArgumentType;
import com.google.zetasql.FunctionSignature;
import com.google.zetasql.ParseResumeLocation;
import com.google.zetasql.SimpleCatalog;
import com.google.zetasql.TVFRelation;
import com.google.zetasql.TableValuedFunction;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLBuiltinFunctionOptions;
import com.google.zetasql.ZetaSQLFunctions;
import com.google.zetasql.ZetaSQLOptions;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SupportedZetaSqlBuiltinFunctions;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlCalciteTranslationUtils;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SqlAnalyzer {
    public static final @UnknownKeyFor @NonNull @Initialized String PRE_DEFINED_WINDOW_FUNCTIONS = "pre_defined_window_functions";
    public static final @UnknownKeyFor @NonNull @Initialized String USER_DEFINED_FUNCTIONS = "user_defined_functions";
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ZetaSQLResolvedNodeKind.ResolvedNodeKind> SUPPORTED_STATEMENT_KINDS = ImmutableSet.of((Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_QUERY_STMT, (Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_FUNCTION_STMT, (Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_TABLE_FUNCTION_STMT);
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> FUNCTION_LIST = ImmutableList.of((Object)"CREATE FUNCTION TUMBLE(ts TIMESTAMP, window_size STRING) AS (1);", (Object)"CREATE FUNCTION TUMBLE_START(window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION TUMBLE_END(window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION HOP(ts TIMESTAMP, emit_frequency STRING, window_size STRING) AS (1);", (Object)"CREATE FUNCTION HOP_START(emit_frequency STRING, window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION HOP_END(emit_frequency STRING, window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION SESSION(ts TIMESTAMP, session_gap STRING) AS (1);", (Object)"CREATE FUNCTION SESSION_START(session_gap STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION SESSION_END(session_gap STRING) RETURNS TIMESTAMP AS (null);");
    private final @UnknownKeyFor @NonNull @Initialized QueryTrait queryTrait;
    private final @UnknownKeyFor @NonNull @Initialized SchemaPlus topLevelSchema;
    private final @UnknownKeyFor @NonNull @Initialized JavaTypeFactory typeFactory;

    SqlAnalyzer(@UnknownKeyFor @NonNull @Initialized QueryTrait queryTrait, @UnknownKeyFor @NonNull @Initialized SchemaPlus topLevelSchema, @UnknownKeyFor @NonNull @Initialized JavaTypeFactory typeFactory) {
        this.queryTrait = queryTrait;
        this.topLevelSchema = topLevelSchema;
        this.typeFactory = typeFactory;
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isEndOfInput(@UnknownKeyFor @NonNull @Initialized ParseResumeLocation parseResumeLocation) {
        return parseResumeLocation.getBytePosition() >= parseResumeLocation.getInput().getBytes(StandardCharsets.UTF_8).length;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> extractTableNames(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options) {
        ParseResumeLocation parseResumeLocation = new ParseResumeLocation(sql);
        ImmutableList.Builder tables = ImmutableList.builder();
        while (!SqlAnalyzer.isEndOfInput(parseResumeLocation)) {
            List statementTables = Analyzer.extractTableNamesFromNextStatement((ParseResumeLocation)parseResumeLocation, (AnalyzerOptions)options);
            tables.addAll((Iterable)statementTables);
        }
        return tables.build();
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedStatement analyzeNextStatement(@UnknownKeyFor @NonNull @Initialized ParseResumeLocation parseResumeLocation, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options, @UnknownKeyFor @NonNull @Initialized SimpleCatalog catalog) {
        ResolvedNodes.ResolvedStatement resolvedStatement = Analyzer.analyzeNextStatement((ParseResumeLocation)parseResumeLocation, (AnalyzerOptions)options, (SimpleCatalog)catalog);
        if (resolvedStatement.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_FUNCTION_STMT) {
            ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt = (ResolvedNodes.ResolvedCreateFunctionStmt)resolvedStatement;
            Function userFunction = new Function((List)createFunctionStmt.getNamePath(), USER_DEFINED_FUNCTIONS, ZetaSQLFunctions.FunctionEnums.Mode.SCALAR, (List)ImmutableList.of((Object)createFunctionStmt.getSignature()));
            try {
                catalog.addFunction(userFunction);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(String.format("Failed to define function %s", String.join((CharSequence)".", (Iterable<? extends CharSequence>)createFunctionStmt.getNamePath())), (Throwable)e);
            }
        } else if (resolvedStatement.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_TABLE_FUNCTION_STMT) {
            ResolvedNodes.ResolvedCreateTableFunctionStmt createTableFunctionStmt = (ResolvedNodes.ResolvedCreateTableFunctionStmt)resolvedStatement;
            catalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.FixedOutputSchemaTVF(createTableFunctionStmt.getNamePath(), createTableFunctionStmt.getSignature(), TVFRelation.createColumnBased(createTableFunctionStmt.getQuery().getColumnList().stream().map(c -> TVFRelation.Column.create((String)c.getName(), (Type)c.getType())).collect(Collectors.toList()))));
        } else if (!SUPPORTED_STATEMENT_KINDS.contains((Object)resolvedStatement.nodeKind())) {
            throw new UnsupportedOperationException("Unrecognized statement type " + resolvedStatement.nodeKindString());
        }
        return resolvedStatement;
    }

    static @UnknownKeyFor @NonNull @Initialized AnalyzerOptions baseAnalyzerOptions() {
        AnalyzerOptions options = new AnalyzerOptions();
        options.setErrorMessageMode(ZetaSQLOptions.ErrorMessageMode.ERROR_MESSAGE_MULTI_LINE_WITH_CARET);
        options.getLanguageOptions().setProductMode(ZetaSQLOptions.ProductMode.PRODUCT_EXTERNAL);
        options.getLanguageOptions().setEnabledLanguageFeatures(new HashSet<ZetaSQLOptions.LanguageFeature>(Arrays.asList(ZetaSQLOptions.LanguageFeature.FEATURE_NUMERIC_TYPE, ZetaSQLOptions.LanguageFeature.FEATURE_DISALLOW_GROUP_BY_FLOAT, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_2_CIVIL_TIME, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_1_SELECT_STAR_EXCEPT_REPLACE, ZetaSQLOptions.LanguageFeature.FEATURE_TABLE_VALUED_FUNCTIONS, ZetaSQLOptions.LanguageFeature.FEATURE_CREATE_TABLE_FUNCTION, ZetaSQLOptions.LanguageFeature.FEATURE_TEMPLATE_FUNCTIONS)));
        options.getLanguageOptions().setSupportedStatementKinds(SUPPORTED_STATEMENT_KINDS);
        return options;
    }

    static @UnknownKeyFor @NonNull @Initialized AnalyzerOptions getAnalyzerOptions(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParams, @UnknownKeyFor @NonNull @Initialized String defaultTimezone) {
        AnalyzerOptions options;
        block3: {
            block2: {
                options = SqlAnalyzer.baseAnalyzerOptions();
                options.setDefaultTimezone(defaultTimezone);
                if (queryParams.getKind() != QueryPlanner.QueryParameters.Kind.NAMED) break block2;
                options.setParameterMode(ZetaSQLOptions.ParameterMode.PARAMETER_NAMED);
                for (Map.Entry entry : queryParams.named().entrySet()) {
                    options.addQueryParameter((String)entry.getKey(), ((Value)entry.getValue()).getType());
                }
                break block3;
            }
            if (queryParams.getKind() != QueryPlanner.QueryParameters.Kind.POSITIONAL) break block3;
            options.setParameterMode(ZetaSQLOptions.ParameterMode.PARAMETER_POSITIONAL);
            for (Value param : queryParams.positional()) {
                options.addPositionalQueryParameter(param.getType());
            }
        }
        return options;
    }

    @UnknownKeyFor @NonNull @Initialized SimpleCatalog createPopulatedCatalog(@UnknownKeyFor @NonNull @Initialized String catalogName, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> tables) {
        SimpleCatalog catalog = new SimpleCatalog(catalogName);
        this.addBuiltinFunctionsToCatalog(catalog, options);
        tables.forEach(table -> this.addTableToLeafCatalog(this.queryTrait, catalog, (List<String>)table));
        return catalog;
    }

    private void addBuiltinFunctionsToCatalog(@UnknownKeyFor @NonNull @Initialized SimpleCatalog catalog, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options) {
        ZetaSQLBuiltinFunctionOptions zetasqlBuiltinFunctionOptions = new ZetaSQLBuiltinFunctionOptions(options.getLanguageOptions());
        SupportedZetaSqlBuiltinFunctions.ALLOWLIST.forEach(arg_0 -> ((ZetaSQLBuiltinFunctionOptions)zetasqlBuiltinFunctionOptions).includeFunctionSignatureId(arg_0));
        catalog.addZetaSQLFunctions(zetasqlBuiltinFunctionOptions);
        FUNCTION_LIST.stream().map(func -> (ResolvedNodes.ResolvedCreateFunctionStmt)Analyzer.analyzeStatement((String)func, (AnalyzerOptions)options, (SimpleCatalog)catalog)).map(resolvedFunc -> new Function(String.join((CharSequence)".", (Iterable<? extends CharSequence>)resolvedFunc.getNamePath()), PRE_DEFINED_WINDOW_FUNCTIONS, ZetaSQLFunctions.FunctionEnums.Mode.SCALAR, (List)ImmutableList.of((Object)resolvedFunc.getSignature()))).forEach(arg_0 -> ((SimpleCatalog)catalog).addFunction(arg_0));
        FunctionArgumentType retType = new FunctionArgumentType(ZetaSQLFunctions.SignatureArgumentKind.ARG_TYPE_RELATION);
        FunctionArgumentType inputTableType = new FunctionArgumentType(ZetaSQLFunctions.SignatureArgumentKind.ARG_TYPE_RELATION);
        FunctionArgumentType descriptorType = new FunctionArgumentType(ZetaSQLFunctions.SignatureArgumentKind.ARG_TYPE_DESCRIPTOR, FunctionArgumentType.FunctionArgumentTypeOptions.builder().setDescriptorResolutionTableOffset(Integer.valueOf(0)).build(), 1);
        FunctionArgumentType stringType = new FunctionArgumentType((Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING));
        catalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.ForwardInputSchemaToOutputSchemaWithAppendedColumnTVF(ImmutableList.of((Object)"TUMBLE"), new FunctionSignature(retType, (List)ImmutableList.of((Object)inputTableType, (Object)descriptorType, (Object)stringType), -1L), ImmutableList.of((Object)TVFRelation.Column.create((String)"window_start", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), (Object)TVFRelation.Column.create((String)"window_end", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP))), null, null));
        catalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.ForwardInputSchemaToOutputSchemaWithAppendedColumnTVF(ImmutableList.of((Object)"HOP"), new FunctionSignature(retType, (List)ImmutableList.of((Object)inputTableType, (Object)descriptorType, (Object)stringType, (Object)stringType), -1L), ImmutableList.of((Object)TVFRelation.Column.create((String)"window_start", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), (Object)TVFRelation.Column.create((String)"window_end", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP))), null, null));
        catalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.ForwardInputSchemaToOutputSchemaWithAppendedColumnTVF(ImmutableList.of((Object)"SESSION"), new FunctionSignature(retType, (List)ImmutableList.of((Object)inputTableType, (Object)descriptorType, (Object)descriptorType, (Object)stringType), -1L), ImmutableList.of((Object)TVFRelation.Column.create((String)"window_start", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), (Object)TVFRelation.Column.create((String)"window_end", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP))), null, null));
    }

    private void addTableToLeafCatalog(@UnknownKeyFor @NonNull @Initialized QueryTrait trait, @UnknownKeyFor @NonNull @Initialized SimpleCatalog topLevelCatalog, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> tablePath) {
        SimpleCatalog leafCatalog = this.createNestedCatalogs(topLevelCatalog, tablePath);
        Table calciteTable = TableResolution.resolveCalciteTable(this.topLevelSchema, tablePath);
        if (calciteTable == null) {
            throw new SqlConversionException("Wasn't able to resolve the path " + tablePath + " in schema: " + this.topLevelSchema.getName());
        }
        RelDataType rowType = calciteTable.getRowType((RelDataTypeFactory)this.typeFactory);
        TableResolution.SimpleTableWithPath tableWithPath = TableResolution.SimpleTableWithPath.of(tablePath);
        trait.addResolvedTable(tableWithPath);
        this.addFieldsToTable(tableWithPath, rowType);
        leafCatalog.addSimpleTable(tableWithPath.getTable());
    }

    private void addFieldsToTable(@UnknownKeyFor @NonNull @Initialized TableResolution.SimpleTableWithPath tableWithPath, @UnknownKeyFor @NonNull @Initialized RelDataType rowType) {
        for (RelDataTypeField field : rowType.getFieldList()) {
            tableWithPath.getTable().addSimpleColumn(field.getName(), ZetaSqlCalciteTranslationUtils.toZetaSqlType(field.getType()));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized SimpleCatalog createNestedCatalogs(@UnknownKeyFor @NonNull @Initialized SimpleCatalog catalog, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> tablePath) {
        SimpleCatalog currentCatalog = catalog;
        for (int i = 0; i < tablePath.size() - 1; ++i) {
            String nextCatalogName = tablePath.get(i);
            Optional<SimpleCatalog> existing = this.tryGetExisting(currentCatalog, nextCatalogName);
            currentCatalog = existing.isPresent() ? existing.get() : this.addNewCatalog(currentCatalog, nextCatalogName);
        }
        return currentCatalog;
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SimpleCatalog> tryGetExisting(@UnknownKeyFor @NonNull @Initialized SimpleCatalog currentCatalog, @UnknownKeyFor @NonNull @Initialized String nextCatalogName) {
        return currentCatalog.getCatalogList().stream().filter(c -> nextCatalogName.equals(c.getFullName())).findFirst();
    }

    private @UnknownKeyFor @NonNull @Initialized SimpleCatalog addNewCatalog(@UnknownKeyFor @NonNull @Initialized SimpleCatalog currentCatalog, @UnknownKeyFor @NonNull @Initialized String nextCatalogName) {
        SimpleCatalog nextCatalog = new SimpleCatalog(nextCatalogName);
        currentCatalog.addSimpleCatalog(nextCatalog);
        return nextCatalog;
    }
}

