/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedNodes;
import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalValues;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;

class SingleRowScanConverter
extends RelConverter<ResolvedNodes.ResolvedSingleRowScan> {
    SingleRowScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedSingleRowScan zetaNode) {
        return zetaNode.getColumnList() == null || zetaNode.getColumnList().isEmpty();
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedSingleRowScan zetaNode, List<RelNode> inputs) {
        return SingleRowScanConverter.createOneRow(this.getCluster());
    }

    private static LogicalValues createOneRow(RelOptCluster cluster) {
        RelDataType rowType = cluster.getTypeFactory().builder().add("ZERO", SqlTypeName.BIGINT).nullable(false).build();
        ImmutableList tuples = ImmutableList.of((Object)ImmutableList.of((Object)cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO, ((RelDataTypeField)rowType.getFieldList().get(0)).getType())));
        return LogicalValues.create((RelOptCluster)cluster, (RelDataType)rowType, (ImmutableList)tuples);
    }
}

