/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.JoinScanConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

class JoinScanWithRefConverter
extends RelConverter<ResolvedNodes.ResolvedJoinScan> {
    JoinScanWithRefConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedJoinScan zetaNode) {
        return zetaNode.getLeftScan() instanceof ResolvedNodes.ResolvedWithRefScan || zetaNode.getRightScan() instanceof ResolvedNodes.ResolvedWithRefScan;
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedJoinScan zetaNode) {
        return ImmutableList.of((Object)zetaNode.getLeftScan(), (Object)zetaNode.getRightScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedJoinScan zetaNode, List<RelNode> inputs) {
        RelNode calciteLeftInput = inputs.get(0);
        RelNode calciteRightInput = inputs.get(1);
        List<ResolvedColumn> zetaLeftColumnList = this.getColumnsForScan(zetaNode.getLeftScan());
        List<ResolvedColumn> zetaRightColumnList = this.getColumnsForScan(zetaNode.getRightScan());
        RexNode condition = this.getExpressionConverter().convertRexNodeFromResolvedExprWithRefScan(zetaNode.getJoinExpr(), (List<ResolvedColumn>)zetaNode.getLeftScan().getColumnList(), calciteLeftInput.getRowType().getFieldList(), zetaLeftColumnList, (List<ResolvedColumn>)zetaNode.getRightScan().getColumnList(), calciteRightInput.getRowType().getFieldList(), zetaRightColumnList);
        return LogicalJoin.create((RelNode)calciteLeftInput, (RelNode)calciteRightInput, (RexNode)condition, (Set)ImmutableSet.of(), (JoinRelType)JoinScanConverter.convertResolvedJoinType(zetaNode.getJoinType()));
    }

    private List<ResolvedColumn> getColumnsForScan(ResolvedNodes.ResolvedScan resolvedScan) {
        return resolvedScan instanceof ResolvedNodes.ResolvedWithRefScan ? this.getTrait().withEntries.get(((ResolvedNodes.ResolvedWithRefScan)resolvedScan).getWithQueryName()).getWithSubquery().getColumnList() : resolvedScan.getColumnList();
    }
}

