/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import java.util.Map;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolver;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Context;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.codehaus.commons.nullanalysis.Nullable;

class TableResolutionContext
implements Context {
    private final Map<String, TableResolver> resolvers;

    static TableResolutionContext of(String topLevelSchema, TableResolver resolver) {
        return new TableResolutionContext((Map<String, TableResolver>)ImmutableMap.of((Object)topLevelSchema, (Object)resolver));
    }

    static TableResolutionContext joinCompoundIds(String topLevelSchema) {
        return TableResolutionContext.of(topLevelSchema, TableResolver.JOIN_INTO_COMPOUND_ID);
    }

    TableResolutionContext with(String topLevelSchema, TableResolver resolver) {
        return new TableResolutionContext((Map<String, TableResolver>)ImmutableMap.builder().putAll(this.resolvers).put((Object)topLevelSchema, (Object)resolver).build());
    }

    boolean hasCustomResolutionFor(String schemaName) {
        return this.resolvers.containsKey(schemaName);
    }

    @Nullable
    TableResolver getTableResolver(String schemaName) {
        return this.resolvers.get(schemaName);
    }

    private TableResolutionContext(Map<String, TableResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public <T> T unwrap(Class<T> c) {
        return (T)(c.isAssignableFrom(TableResolutionContext.class) ? this : null);
    }
}

