/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AsJsons<@UnknownKeyFor InputT>
extends PTransform<PCollection<InputT>, PCollection<String>> {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends InputT> inputClass;
    private @UnknownKeyFor @NonNull @Initialized ObjectMapper customMapper;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized AsJsons<InputT> of(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends InputT> inputClass) {
        return new AsJsons<InputT>(inputClass);
    }

    private AsJsons(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends InputT> inputClass) {
        this.inputClass = inputClass;
    }

    public @UnknownKeyFor @NonNull @Initialized AsJsons<InputT> withMapper(@UnknownKeyFor @NonNull @Initialized ObjectMapper mapper) {
        AsJsons<? extends InputT> newTransform = new AsJsons<InputT>(this.inputClass);
        newTransform.customMapper = mapper;
        return newTransform;
    }

    public <NewFailureT> @UnknownKeyFor @NonNull @Initialized AsJsons. @UnknownKeyFor @NonNull @Initialized AsJsonsWithFailures<NewFailureT> exceptionsInto(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new AsJsonsWithFailures<NewFailureT>(null, failureTypeDescriptor);
    }

    public <FailureT> @UnknownKeyFor @NonNull @Initialized AsJsons. @UnknownKeyFor @NonNull @Initialized AsJsonsWithFailures<FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new AsJsonsWithFailures<FailureT>(exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AsJsons. @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized AsJsonsWithFailures<KV<InputT, Map<String, String>>> exceptionsVia() {
        DefaultExceptionAsMapHandler exceptionHandler = new DefaultExceptionAsMapHandler<InputT>(){};
        return new AsJsonsWithFailures<KV<InputT, Map<String, String>>>(exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    private @UnknownKeyFor @NonNull @Initialized String writeValue(InputT input) throws @UnknownKeyFor @NonNull @Initialized JsonProcessingException {
        ObjectMapper mapper = Optional.ofNullable(this.customMapper).orElse(DEFAULT_MAPPER);
        return mapper.writeValueAsString(input);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<InputT, String>(){

            public @UnknownKeyFor @NonNull @Initialized String apply(InputT input) {
                try {
                    return AsJsons.this.writeValue(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to serialize " + AsJsons.this.inputClass.getName() + " value: " + input, e);
                }
            }
        }));
    }

    private static class DefaultExceptionAsMapHandler<@UnknownKeyFor InputT>
    extends SimpleFunction<WithFailures.ExceptionElement<InputT>, KV<InputT, Map<String, String>>> {
        private DefaultExceptionAsMapHandler() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> apply(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT> f) throws @UnknownKeyFor @NonNull @Initialized RuntimeException {
            if (!(f.exception() instanceof JsonProcessingException)) {
                throw new RuntimeException(f.exception());
            }
            return KV.of((Object)f.element(), (Object)ImmutableMap.of((Object)"className", (Object)f.exception().getClass().getName(), (Object)"message", (Object)f.exception().getMessage(), (Object)"stackTrace", (Object)Arrays.toString(f.exception().getStackTrace())));
        }
    }

    public class AsJsonsWithFailures<@UnknownKeyFor FailureT>
    extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<String>, FailureT>> {
        private @Nullable @UnknownKeyFor @Initialized InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;
        private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<FailureT> failureType;

        AsJsonsWithFailures(@UnknownKeyFor @NonNull @Initialized InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, TypeDescriptor<FailureT> failureType) {
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public @UnknownKeyFor @NonNull @Initialized AsJsons. @UnknownKeyFor @NonNull @Initialized AsJsonsWithFailures<FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized ProcessFunction<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
            return new AsJsonsWithFailures<FailureT>(new InferableFunction<WithFailures.ExceptionElement<InputT>, FailureT>(exceptionHandler){}, this.failureType);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.Result<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>, FailureT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            return (WithFailures.Result)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(Contextful.fn((Contextful.Fn & Serializable)(input1, c) -> AsJsons.this.writeValue(input1), (Requirements)Requirements.empty())).exceptionsInto(this.failureType).exceptionsVia(this.exceptionHandler));
        }
    }
}

