/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.schemas.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.Division;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Multiplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.schemas.AvroRecordSchema;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroByteBuddyUtils;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroJavaTimeConversions;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroJodaTimeConversions;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.schemas.logicaltypes.FixedString;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.schemas.logicaltypes.VariableBytes;
import org.apache.beam.sdk.schemas.logicaltypes.VariableString;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.POJOUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class AvroUtils {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType BYTES = new TypeDescription.ForLoadedType(byte[].class);
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType JAVA_INSTANT = new TypeDescription.ForLoadedType(Instant.class);
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType JAVA_LOCALE_DATE = new TypeDescription.ForLoadedType(LocalDate.class);
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType JODA_READABLE_INSTANT = new TypeDescription.ForLoadedType(ReadableInstant.class);
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType JODA_INSTANT = new TypeDescription.ForLoadedType(org.joda.time.Instant.class);
    private static final @UnknownKeyFor @NonNull @Initialized GenericData GENERIC_DATA_WITH_DEFAULT_CONVERSIONS = new GenericData();

    public static void addLogicalTypeConversions(@UnknownKeyFor @NonNull @Initialized GenericData data) {
        data.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJodaTimeConversions.DateConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJodaTimeConversions.TimeConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJodaTimeConversions.TimeMicrosConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJodaTimeConversions.TimestampConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJodaTimeConversions.TimestampMicrosConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.DateConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.TimeMillisConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.TimeMicrosConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.TimestampMillisConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.TimestampMicrosConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.LocalTimestampMillisConversion());
        data.addLogicalTypeConversion((Conversion)new AvroJavaTimeConversions.LocalTimestampMicrosConversion());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field toBeamField(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        TypeWithNullability nullableType = new TypeWithNullability(field.schema());
        Schema.FieldType beamFieldType = AvroUtils.toFieldType(nullableType);
        return Schema.Field.of((String)field.name(), (Schema.FieldType)beamFieldType);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.Field toAvroField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized String namespace) {
        org.apache.avro.Schema fieldSchema = AvroUtils.getFieldSchema(field.getType(), field.getName(), namespace);
        return new Schema.Field(field.getName(), fieldSchema, field.getDescription(), null);
    }

    private AvroUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema toBeamSchema(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        ReflectData data = NullnessCheckerWorkarounds.newReflectData(clazz);
        return AvroUtils.toBeamSchema(data.getSchema(clazz));
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema toBeamSchema(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema) {
        Schema.Builder builder = Schema.builder();
        for (Schema.Field field : schema.getFields()) {
            Schema.Field beamField = AvroUtils.toBeamField(field);
            if (field.doc() != null) {
                beamField = beamField.withDescription(field.doc());
            }
            builder.addField(beamField);
        }
        return builder.build();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=false)
    private static @UnknownKeyFor @NonNull @Initialized boolean isNullOrEmpty(@Nullable @UnknownKeyFor @Initialized String str) {
        return str == null || str.isEmpty();
    }

    public static @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema toAvroSchema(@UnknownKeyFor @NonNull @Initialized Schema beamSchema, @Nullable @UnknownKeyFor @Initialized String name, @Nullable @UnknownKeyFor @Initialized String namespace) {
        String schemaName = AvroUtils.isNullOrEmpty(name) ? "topLevelRecord" : name;
        String schemaNamespace = namespace == null ? "" : namespace;
        String childNamespace = !"".equals(schemaNamespace) ? schemaNamespace + "." + schemaName : schemaName;
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : beamSchema.getFields()) {
            Schema.Field recordField = AvroUtils.toAvroField(field, childNamespace);
            fields.add(recordField);
        }
        return org.apache.avro.Schema.createRecord((String)schemaName, (String)"", (String)schemaNamespace, (boolean)false, (List)fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema toAvroSchema(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return AvroUtils.toAvroSchema(beamSchema, null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRowStrict(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @Nullable @UnknownKeyFor @Initialized Schema schema, @Nullable @UnknownKeyFor @Initialized GenericData genericData) {
        if (schema == null) {
            schema = AvroUtils.toBeamSchema(record.getSchema());
        }
        if (genericData == null) {
            genericData = record instanceof SpecificRecordBase ? AvroUtils.getGenericData((SpecificRecordBase)record) : GENERIC_DATA_WITH_DEFAULT_CONVERSIONS;
        }
        Row.Builder builder = Row.withSchema((Schema)schema);
        org.apache.avro.Schema avroSchema = record.getSchema();
        for (Schema.Field field : schema.getFields()) {
            Object value = record.get(field.getName());
            org.apache.avro.Schema fieldAvroSchema = avroSchema.getField(field.getName()).schema();
            builder.addValue(AvroUtils.convertAvroFieldStrict(value, fieldAvroSchema, field.getType(), genericData));
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRowStrict(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @Nullable @UnknownKeyFor @Initialized Schema schema) {
        return AvroUtils.toBeamRowStrict(record, schema, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized GenericRecord toGenericRecord(@UnknownKeyFor @NonNull @Initialized Row row) {
        return AvroUtils.toGenericRecord(row, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized GenericRecord toGenericRecord(@UnknownKeyFor @NonNull @Initialized Row row, @Nullable @UnknownKeyFor @Initialized org.apache.avro.Schema avroSchema) {
        Schema beamSchema = row.getSchema();
        if (avroSchema != null && avroSchema.getFields().size() != beamSchema.getFieldCount()) {
            throw new IllegalArgumentException("AVRO schema doesn't match row schema. Row schema " + beamSchema + ". AVRO schema + " + avroSchema);
        }
        if (avroSchema == null) {
            avroSchema = AvroUtils.toAvroSchema(beamSchema);
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(avroSchema);
        for (int i = 0; i < beamSchema.getFieldCount(); ++i) {
            Schema.Field field = beamSchema.getField(i);
            NullnessCheckerWorkarounds.builderSet(builder, field.getName(), AvroUtils.genericFromBeamField(field.getType(), avroSchema.getField(field.getName()).schema(), row.getValue(i)));
        }
        return builder.build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFunction(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema) {
        if (GenericRecord.class.equals(clazz)) {
            Schema beamSchema = AvroUtils.toBeamSchema(schema);
            return AvroUtils.getGenericRecordToRowFunction(beamSchema);
        }
        return new AvroRecordSchema().toRowFunction(TypeDescriptor.of(clazz));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFunction(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return GenericRecord.class.equals(clazz) ? AvroUtils.getRowToGenericRecordFunction(null) : new AvroRecordSchema().fromRowFunction(TypeDescriptor.of(clazz));
    }

    public static <T> @Nullable @UnknownKeyFor @Initialized Schema getSchema(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @Nullable @UnknownKeyFor @Initialized org.apache.avro.Schema schema) {
        if (schema != null) {
            return schema.getType().equals((Object)Schema.Type.RECORD) ? AvroUtils.toBeamSchema(schema) : null;
        }
        if (GenericRecord.class.equals(clazz)) {
            throw new IllegalArgumentException("No schema provided for getSchema(GenericRecord)");
        }
        return new AvroRecordSchema().schemaFor(TypeDescriptor.of(clazz));
    }

    public static @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> getAvroBytesToRowFunction(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return new AvroBytesToRowFn(beamSchema);
    }

    public static @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getRowToAvroBytesFunction(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return new RowToAvroBytesFn(beamSchema);
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, @UnknownKeyFor @NonNull @Initialized Row> getGenericRecordToRowFunction(@Nullable @UnknownKeyFor @Initialized Schema schema) {
        return new GenericRecordToRowFn(schema);
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized GenericRecord> getRowToGenericRecordFunction(@Nullable @UnknownKeyFor @Initialized org.apache.avro.Schema avroSchema) {
        return new RowToGenericRecordFn(avroSchema);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        Class clazz = type.getRawType();
        org.apache.avro.Schema avroSchema = NullnessCheckerWorkarounds.newReflectData(clazz).getSchema((Type)clazz);
        Schema beamSchema = AvroUtils.toBeamSchema(avroSchema);
        return SchemaCoder.of((Schema)beamSchema, type, AvroUtils.getToRowFunction(clazz, avroSchema), AvroUtils.getFromRowFunction(clazz));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return AvroUtils.schemaCoder(TypeDescriptor.of(clazz));
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaCoder<@UnknownKeyFor @NonNull @Initialized GenericRecord> schemaCoder(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema) {
        Schema beamSchema = AvroUtils.toBeamSchema(schema);
        return SchemaCoder.of((Schema)beamSchema, (TypeDescriptor)TypeDescriptor.of(GenericRecord.class), AvroUtils.getGenericRecordToRowFunction(beamSchema), AvroUtils.getRowToGenericRecordFunction(schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema) {
        return SchemaCoder.of((Schema)((Schema)Preconditions.checkNotNull((Object)AvroUtils.getSchema(clazz, schema))), (TypeDescriptor)TypeDescriptor.of(clazz), AvroUtils.getToRowFunction(clazz, schema), AvroUtils.getFromRowFunction(clazz));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder(@UnknownKeyFor @NonNull @Initialized AvroCoder<T> avroCoder) {
        return AvroUtils.schemaCoder(avroCoder.getType(), avroCoder.getSchema());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> getFieldTypes(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(SpecificRecord.class))) {
            return JavaBeanUtils.getFieldTypes(typeDescriptor, (Schema)schema, (FieldValueTypeSupplier)new AvroSpecificRecordFieldValueTypeSupplier());
        }
        return POJOUtils.getFieldTypes(typeDescriptor, (Schema)schema, (FieldValueTypeSupplier)new AvroPojoFieldValueTypeSupplier());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull T, @UnknownKeyFor @NonNull @Initialized Object>> getGetters(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(SpecificRecord.class))) {
            return JavaBeanUtils.getGetters(typeDescriptor, (Schema)schema, (FieldValueTypeSupplier)new AvroSpecificRecordFieldValueTypeSupplier(), (ByteBuddyUtils.TypeConversionsFactory)new AvroTypeConversionFactory());
        }
        return POJOUtils.getGetters(typeDescriptor, (Schema)schema, (FieldValueTypeSupplier)new AvroPojoFieldValueTypeSupplier(), (ByteBuddyUtils.TypeConversionsFactory)new AvroTypeConversionFactory());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator getCreator(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(SpecificRecord.class))) {
            return AvroByteBuddyUtils.getCreator(typeDescriptor.getRawType(), schema);
        }
        return POJOUtils.getSetFieldCreator(typeDescriptor, (Schema)schema, (FieldValueTypeSupplier)new AvroPojoFieldValueTypeSupplier(), (ByteBuddyUtils.TypeConversionsFactory)new AvroTypeConversionFactory());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType toFieldType(@UnknownKeyFor @NonNull @Initialized TypeWithNullability type) {
        Schema.FieldType fieldType = null;
        org.apache.avro.Schema avroSchema = type.type;
        LogicalType logicalType = LogicalTypes.fromSchema((org.apache.avro.Schema)avroSchema);
        if (logicalType != null) {
            if (logicalType instanceof LogicalTypes.Decimal) {
                fieldType = Schema.FieldType.DECIMAL;
            } else if (logicalType instanceof LogicalTypes.TimestampMillis) {
                fieldType = Schema.FieldType.DATETIME;
            } else if (logicalType instanceof LogicalTypes.Date) {
                fieldType = Schema.FieldType.DATETIME;
            }
        }
        if (fieldType == null) {
            switch (type.type.getType()) {
                case RECORD: {
                    fieldType = Schema.FieldType.row((Schema)AvroUtils.toBeamSchema(avroSchema));
                    break;
                }
                case ENUM: {
                    fieldType = Schema.FieldType.logicalType((Schema.LogicalType)EnumerationType.create((List)type.type.getEnumSymbols()));
                    break;
                }
                case ARRAY: {
                    Schema.FieldType elementType = AvroUtils.toFieldType(new TypeWithNullability(avroSchema.getElementType()));
                    fieldType = Schema.FieldType.array((Schema.FieldType)elementType);
                    break;
                }
                case MAP: {
                    fieldType = Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)AvroUtils.toFieldType(new TypeWithNullability(avroSchema.getValueType())));
                    break;
                }
                case FIXED: {
                    fieldType = ((FixedBytesField)Preconditions.checkNotNull((Object)FixedBytesField.fromAvroType(type.type))).toBeamType();
                    break;
                }
                case STRING: {
                    fieldType = Schema.FieldType.STRING;
                    break;
                }
                case BYTES: {
                    fieldType = Schema.FieldType.BYTES;
                    break;
                }
                case INT: {
                    fieldType = Schema.FieldType.INT32;
                    break;
                }
                case LONG: {
                    fieldType = Schema.FieldType.INT64;
                    break;
                }
                case FLOAT: {
                    fieldType = Schema.FieldType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    fieldType = Schema.FieldType.DOUBLE;
                    break;
                }
                case BOOLEAN: {
                    fieldType = Schema.FieldType.BOOLEAN;
                    break;
                }
                case UNION: {
                    fieldType = Schema.FieldType.logicalType((Schema.LogicalType)OneOfType.create(avroSchema.getTypes().stream().map(x -> Schema.Field.of((String)x.getName(), (Schema.FieldType)AvroUtils.toFieldType(new TypeWithNullability((org.apache.avro.Schema)x)))).collect(Collectors.toList())));
                    break;
                }
                case NULL: {
                    throw new IllegalArgumentException("Can't convert 'null' to FieldType");
                }
                default: {
                    throw new AssertionError((Object)("Unexpected AVRO Schema.Type: " + avroSchema.getType()));
                }
            }
        }
        fieldType = fieldType.withNullable(type.nullable);
        return fieldType;
    }

    private static @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema getFieldSchema(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized String namespace) {
        org.apache.avro.Schema baseType;
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case INT64: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case DECIMAL: {
                baseType = LogicalTypes.decimal((int)Integer.MAX_VALUE).addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES));
                break;
            }
            case FLOAT: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case DOUBLE: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case STRING: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case DATETIME: {
                baseType = LogicalTypes.timestampMillis().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
                break;
            }
            case BOOLEAN: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case BYTES: {
                baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES);
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = (Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType());
                String identifier = logicalType.getIdentifier();
                if (FixedBytes.IDENTIFIER.equals(identifier)) {
                    FixedBytesField fixedBytesField = (FixedBytesField)Preconditions.checkNotNull((Object)FixedBytesField.fromBeamFieldType(fieldType));
                    baseType = fixedBytesField.toAvroType("fixed", namespace + "." + fieldName);
                    break;
                }
                if (VariableBytes.IDENTIFIER.equals(identifier)) {
                    baseType = org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES);
                    break;
                }
                if (FixedString.IDENTIFIER.equals(identifier) || "CHAR".equals(identifier) || "NCHAR".equals(identifier)) {
                    baseType = AvroUtils.buildHiveLogicalTypeSchema("char", (Integer)Preconditions.checkNotNull((Object)((Integer)logicalType.getArgument())));
                    break;
                }
                if (VariableString.IDENTIFIER.equals(identifier) || "NVARCHAR".equals(identifier) || "VARCHAR".equals(identifier) || "LONGNVARCHAR".equals(identifier) || "LONGVARCHAR".equals(identifier)) {
                    baseType = AvroUtils.buildHiveLogicalTypeSchema("varchar", (Integer)Preconditions.checkNotNull((Object)((Integer)logicalType.getArgument())));
                    break;
                }
                if ("Enum".equals(identifier)) {
                    EnumerationType enumerationType = (EnumerationType)fieldType.getLogicalType(EnumerationType.class);
                    baseType = org.apache.avro.Schema.createEnum((String)fieldName, (String)"", (String)"", (List)enumerationType.getValues());
                    break;
                }
                if ("OneOf".equals(identifier)) {
                    OneOfType oneOfType = (OneOfType)fieldType.getLogicalType(OneOfType.class);
                    baseType = org.apache.avro.Schema.createUnion(oneOfType.getOneOfSchema().getFields().stream().map(x -> AvroUtils.getFieldSchema(x.getType(), x.getName(), namespace)).collect(Collectors.toList()));
                    break;
                }
                if ("DATE".equals(identifier) || SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    baseType = LogicalTypes.date().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                    break;
                }
                if ("TIME".equals(identifier)) {
                    baseType = LogicalTypes.timeMillis().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                    break;
                }
                throw new RuntimeException("Unhandled logical type " + ((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier());
            }
            case ARRAY: 
            case ITERABLE: {
                baseType = org.apache.avro.Schema.createArray((org.apache.avro.Schema)AvroUtils.getFieldSchema((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getCollectionElementType()), fieldName, namespace));
                break;
            }
            case MAP: {
                if (((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapKeyType())).getTypeName().isStringType()) {
                    baseType = org.apache.avro.Schema.createMap((org.apache.avro.Schema)AvroUtils.getFieldSchema((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapValueType()), fieldName, namespace));
                    break;
                }
                throw new IllegalArgumentException("Avro only supports maps with string keys");
            }
            case ROW: {
                baseType = AvroUtils.toAvroSchema((Schema)Preconditions.checkNotNull((Object)fieldType.getRowSchema()), fieldName, namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type " + fieldType);
            }
        }
        return fieldType.getNullable() != false ? ReflectData.makeNullable((org.apache.avro.Schema)baseType) : baseType;
    }

    private static @Nullable @UnknownKeyFor @Initialized Object genericFromBeamField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema, @Nullable @UnknownKeyFor @Initialized Object value) {
        TypeWithNullability typeWithNullability = new TypeWithNullability(avroSchema);
        if (!fieldType.getNullable().equals(typeWithNullability.nullable)) {
            throw new IllegalArgumentException("FieldType " + fieldType + " and AVRO schema " + avroSchema + " don't have matching nullability");
        }
        if (value == null) {
            return value;
        }
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return value;
            }
            case STRING: {
                return new Utf8((String)value);
            }
            case DECIMAL: {
                BigDecimal decimal = (BigDecimal)value;
                LogicalType logicalType = typeWithNullability.type.getLogicalType();
                ByteBuffer result = new Conversions.DecimalConversion().toBytes(decimal, null, logicalType);
                return result;
            }
            case DATETIME: {
                if (typeWithNullability.type.getType() == Schema.Type.INT) {
                    ReadableInstant instant = (ReadableInstant)value;
                    return Days.daysBetween((ReadableInstant)org.joda.time.Instant.EPOCH, (ReadableInstant)instant).getDays();
                }
                if (typeWithNullability.type.getType() == Schema.Type.LONG) {
                    ReadableInstant instant = (ReadableInstant)value;
                    return instant.getMillis();
                }
                throw new IllegalArgumentException("Can't represent " + fieldType + " as " + typeWithNullability.type.getType());
            }
            case BYTES: {
                return ByteBuffer.wrap((byte[])value);
            }
            case LOGICAL_TYPE: {
                String identifier = ((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier();
                if (FixedBytes.IDENTIFIER.equals(identifier)) {
                    byte[] byteArray = (byte[])value;
                    FixedBytesField fixedBytesField = (FixedBytesField)Preconditions.checkNotNull((Object)FixedBytesField.fromBeamFieldType(fieldType));
                    if (byteArray.length != fixedBytesField.getSize()) {
                        throw new IllegalArgumentException("Incorrectly sized byte array.");
                    }
                    return NullnessCheckerWorkarounds.createFixed(null, (byte[])value, typeWithNullability.type);
                }
                if (VariableBytes.IDENTIFIER.equals(identifier)) {
                    return NullnessCheckerWorkarounds.createFixed(null, (byte[])value, typeWithNullability.type);
                }
                if (FixedString.IDENTIFIER.equals(identifier) || "CHAR".equals(identifier) || "NCHAR".equals(identifier)) {
                    return new Utf8((String)value);
                }
                if (VariableString.IDENTIFIER.equals(identifier) || "NVARCHAR".equals(identifier) || "VARCHAR".equals(identifier) || "LONGNVARCHAR".equals(identifier) || "LONGVARCHAR".equals(identifier)) {
                    return new Utf8((String)value);
                }
                if ("Enum".equals(identifier)) {
                    EnumerationType enumerationType = (EnumerationType)fieldType.getLogicalType(EnumerationType.class);
                    return GenericData.get().createEnum(enumerationType.toString((EnumerationType.Value)value), typeWithNullability.type);
                }
                if ("OneOf".equals(identifier)) {
                    OneOfType oneOfType = (OneOfType)fieldType.getLogicalType(OneOfType.class);
                    OneOfType.Value oneOfValue = (OneOfType.Value)value;
                    Schema.FieldType innerFieldType = oneOfType.getFieldType(oneOfValue);
                    if (typeWithNullability.nullable && oneOfValue.getValue() == null) {
                        return null;
                    }
                    return AvroUtils.genericFromBeamField(innerFieldType.withNullable(false), (org.apache.avro.Schema)typeWithNullability.type.getTypes().get(oneOfValue.getCaseType().getValue()), oneOfValue.getValue());
                }
                if ("DATE".equals(identifier)) {
                    return Days.daysBetween((ReadableInstant)org.joda.time.Instant.EPOCH, (ReadableInstant)((org.joda.time.Instant)value)).getDays();
                }
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return ((LocalDate)value).toEpochDay();
                }
                if ("TIME".equals(identifier)) {
                    return (int)((org.joda.time.Instant)value).getMillis();
                }
                throw new RuntimeException("Unhandled logical type " + identifier);
            }
            case ARRAY: 
            case ITERABLE: {
                Iterable iterable = (Iterable)value;
                ArrayList translatedArray = Lists.newArrayListWithExpectedSize((int)Iterables.size((Iterable)iterable));
                for (Object arrayElement : iterable) {
                    translatedArray.add(AvroUtils.genericFromBeamField((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getCollectionElementType()), typeWithNullability.type.getElementType(), arrayElement));
                }
                return translatedArray;
            }
            case MAP: {
                HashMap map = Maps.newHashMap();
                Map valueMap = (Map)value;
                for (Map.Entry entry : valueMap.entrySet()) {
                    Utf8 key = new Utf8((String)Preconditions.checkNotNull(entry.getKey()));
                    map.put(key, AvroUtils.genericFromBeamField((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapValueType()), typeWithNullability.type.getValueType(), entry.getValue()));
                }
                return map;
            }
            case ROW: {
                return AvroUtils.toGenericRecord((Row)value, typeWithNullability.type);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + fieldType);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertLogicalType(@PolyNull @UnknownKeyFor @Initialized Object value, @Nonnull @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema, @Nonnull // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @Nonnull @UnknownKeyFor @NonNull @Initialized GenericData genericData) {
        TypeWithNullability type = new TypeWithNullability(avroSchema);
        LogicalType logicalType = LogicalTypes.fromSchema((org.apache.avro.Schema)type.type);
        if (logicalType == null) {
            return null;
        }
        Object rawType = value;
        Conversion conversion = genericData.getConversionByClass(value.getClass(), logicalType);
        Class convertedType = null;
        if (conversion != null && (convertedType = conversion.getConvertedType()).isInstance(value)) {
            rawType = Conversions.convertToRawType((Object)value, (org.apache.avro.Schema)avroSchema, (LogicalType)logicalType, (Conversion)conversion);
        }
        switch (logicalType.getName()) {
            case "date": {
                return AvroUtils.convertDateStrict(AvroUtils.checkRawType(Integer.class, value, logicalType, rawType, conversion, convertedType), fieldType);
            }
            case "time-millis": {
                return AvroUtils.checkRawType(Integer.class, value, logicalType, rawType, conversion, convertedType);
            }
            case "time-micros": 
            case "timestamp-micros": 
            case "local-timestamp-millis": 
            case "local-timestamp-micros": {
                return AvroUtils.checkRawType(Long.class, value, logicalType, rawType, conversion, convertedType);
            }
            case "timestamp-millis": {
                return AvroUtils.convertDateTimeStrict(AvroUtils.checkRawType(Long.class, value, logicalType, rawType, conversion, convertedType), fieldType);
            }
            case "decimal": {
                if (rawType instanceof GenericFixed) {
                    rawType = ByteBuffer.wrap(((GenericFixed)rawType).bytes());
                }
                ByteBuffer byteBuffer = AvroUtils.checkRawType(ByteBuffer.class, value, logicalType, rawType, conversion, convertedType);
                Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
                BigDecimal bigDecimal = (BigDecimal)decimalConversion.fromBytes(byteBuffer.duplicate(), type.type, logicalType);
                return AvroUtils.convertDecimal(bigDecimal, fieldType);
            }
            case "uuid": {
                return UUID.fromString(rawType.toString()).toString();
            }
        }
        return null;
    }

    public static @PolyNull @UnknownKeyFor @Initialized Object convertAvroFieldStrict(@PolyNull @UnknownKeyFor @Initialized Object value, @Nonnull @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema, @Nonnull // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @Nonnull @UnknownKeyFor @NonNull @Initialized GenericData genericData) {
        if (value == null) {
            return null;
        }
        Object convertedLogicalType = AvroUtils.convertLogicalType(value, avroSchema, fieldType, genericData);
        if (convertedLogicalType != null) {
            return convertedLogicalType;
        }
        TypeWithNullability type = new TypeWithNullability(avroSchema);
        switch (type.type.getType()) {
            case FIXED: {
                return AvroUtils.convertFixedStrict((GenericFixed)value, fieldType);
            }
            case BYTES: {
                return AvroUtils.convertBytesStrict((ByteBuffer)value, fieldType);
            }
            case STRING: {
                return AvroUtils.convertStringStrict((CharSequence)value, fieldType);
            }
            case INT: {
                return AvroUtils.convertIntStrict((Integer)value, fieldType);
            }
            case LONG: {
                return AvroUtils.convertLongStrict((Long)value, fieldType);
            }
            case FLOAT: {
                return AvroUtils.convertFloatStrict((Float)value, fieldType);
            }
            case DOUBLE: {
                return AvroUtils.convertDoubleStrict((Double)value, fieldType);
            }
            case BOOLEAN: {
                return AvroUtils.convertBooleanStrict((Boolean)value, fieldType);
            }
            case RECORD: {
                return AvroUtils.convertRecordStrict((GenericRecord)value, fieldType);
            }
            case ENUM: {
                return AvroUtils.convertEnumStrict(value, fieldType);
            }
            case ARRAY: {
                return AvroUtils.convertArrayStrict((List)value, type.type.getElementType(), fieldType, genericData);
            }
            case MAP: {
                return AvroUtils.convertMapStrict((Map)value, type.type.getValueType(), fieldType, genericData);
            }
            case UNION: {
                return AvroUtils.convertUnionStrict(value, type.type, fieldType, genericData);
            }
            case NULL: {
                throw new IllegalArgumentException("Can't convert 'null' to non-nullable field");
            }
        }
        throw new AssertionError((Object)("Unexpected AVRO Schema.Type: " + type.type.getType()));
    }

    public static @PolyNull @UnknownKeyFor @Initialized Object convertAvroFieldStrict(@PolyNull @UnknownKeyFor @Initialized Object value, @Nonnull @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema, @Nonnull // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        return AvroUtils.convertAvroFieldStrict(value, avroSchema, fieldType, GENERIC_DATA_WITH_DEFAULT_CONVERSIONS);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertRecordStrict(@UnknownKeyFor @NonNull @Initialized GenericRecord record, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.ROW, "record");
        return AvroUtils.toBeamRowStrict(record, fieldType.getRowSchema());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertBytesStrict(@UnknownKeyFor @NonNull @Initialized ByteBuffer bb, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.BYTES, "bytes");
        byte[] bytes = new byte[bb.remaining()];
        bb.duplicate().get(bytes);
        return bytes;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertFixedStrict(@UnknownKeyFor @NonNull @Initialized GenericFixed fixed, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.LOGICAL_TYPE, "fixed");
        Preconditions.checkArgument((boolean)FixedBytes.IDENTIFIER.equals(((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier()));
        return fixed.bytes().clone();
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertStringStrict(@UnknownKeyFor @NonNull @Initialized CharSequence value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.STRING, "string");
        return value.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertIntStrict(@UnknownKeyFor @NonNull @Initialized Integer value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.INT32, "int");
        return value;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertLongStrict(@UnknownKeyFor @NonNull @Initialized Long value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.INT64, "long");
        return value;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertDecimal(@UnknownKeyFor @NonNull @Initialized BigDecimal value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DECIMAL, "decimal");
        return value;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertDateStrict(@UnknownKeyFor @NonNull @Initialized Integer epochDays, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DATETIME, "date");
        return org.joda.time.Instant.EPOCH.plus((ReadableDuration)Duration.standardDays((long)epochDays.intValue()));
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertDateTimeStrict(@UnknownKeyFor @NonNull @Initialized Long value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DATETIME, "dateTime");
        return new org.joda.time.Instant((Object)value);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertFloatStrict(@UnknownKeyFor @NonNull @Initialized Float value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.FLOAT, "float");
        return value;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertDoubleStrict(@UnknownKeyFor @NonNull @Initialized Double value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DOUBLE, "double");
        return value;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertBooleanStrict(@UnknownKeyFor @NonNull @Initialized Boolean value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.BOOLEAN, "boolean");
        return value;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertEnumStrict(@UnknownKeyFor @NonNull @Initialized Object value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.LOGICAL_TYPE, "enum");
        Preconditions.checkArgument((boolean)((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier().equals("Enum"));
        EnumerationType enumerationType = (EnumerationType)fieldType.getLogicalType(EnumerationType.class);
        return enumerationType.valueOf(value.toString());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertUnionStrict(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema unionAvroSchema, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized GenericData genericData) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.LOGICAL_TYPE, "oneOfType");
        Preconditions.checkArgument((boolean)((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier().equals("OneOf"));
        OneOfType oneOfType = (OneOfType)fieldType.getLogicalType(OneOfType.class);
        int fieldNumber = GenericData.get().resolveUnion(unionAvroSchema, value);
        Schema.FieldType baseFieldType = oneOfType.getOneOfSchema().getField(fieldNumber).getType();
        Object convertedValue = AvroUtils.convertAvroFieldStrict(value, (org.apache.avro.Schema)unionAvroSchema.getTypes().get(fieldNumber), baseFieldType, genericData);
        return oneOfType.createValue(fieldNumber, convertedValue);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertArrayStrict(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema elemAvroSchema, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized GenericData genericData) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.ARRAY, "array");
        ArrayList<Object> ret = new ArrayList<Object>(values.size());
        Schema.FieldType elemFieldType = fieldType.getCollectionElementType();
        for (Object value : values) {
            ret.add(AvroUtils.convertAvroFieldStrict(value, elemAvroSchema, (Schema.FieldType)Preconditions.checkNotNull((Object)elemFieldType), genericData));
        }
        return ret;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertMapStrict(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized CharSequence, @UnknownKeyFor @NonNull @Initialized Object> values, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema valueAvroSchema, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized GenericData genericData) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.MAP, "map");
        Schema.FieldType mapKeyType = (Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapKeyType());
        Schema.FieldType mapValueType = (Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapValueType());
        if (!Schema.FieldType.STRING.equals((Object)fieldType.getMapKeyType())) {
            throw new IllegalArgumentException("Can't convert 'string' map keys to " + fieldType.getMapKeyType());
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (Map.Entry<CharSequence, Object> value : values.entrySet()) {
            ret.put(AvroUtils.convertStringStrict(value.getKey(), mapKeyType), AvroUtils.convertAvroFieldStrict(value.getValue(), valueAvroSchema, mapValueType, genericData));
        }
        return ret;
    }

    private static void checkTypeName(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName got, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName expected, @UnknownKeyFor @NonNull @Initialized String label) {
        Preconditions.checkArgument((boolean)got.equals((Object)expected), (String)"Can't convert '%s' to %s, expected: %s", (Object)label, (Object)got, (Object)expected);
    }

    private static @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema buildHiveLogicalTypeSchema(@UnknownKeyFor @NonNull @Initialized String hiveLogicalType, @UnknownKeyFor @NonNull @Initialized int size) {
        String schemaJson = String.format("{\"type\": \"string\", \"logicalType\": \"%s\", \"maxLength\": %s}", hiveLogicalType, size);
        return new Schema.Parser().parse(schemaJson);
    }

    static @UnknownKeyFor @NonNull @Initialized GenericData getGenericData(@UnknownKeyFor @NonNull @Initialized SpecificRecordBase record) {
        try {
            return record.getSpecificData();
        }
        catch (NoSuchMethodError e) {
            try {
                return (GenericData)FieldUtils.readStaticField(record.getClass(), (String)"MODEL$", (boolean)true);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Unable to access MODEL$ field in SpecificRecordBase class", ex);
            }
        }
    }

    private static <T> T checkRawType(@UnknownKeyFor @NonNull @Initialized Class<T> desiredRawType, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized LogicalType logicalType, @UnknownKeyFor @NonNull @Initialized Object rawType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Conversion<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> conversion, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> convertedType) {
        String msg = String.format("Value %s of class %s is not a supported type for logical type %s (%s). Underlying avro built-in raw type should be instance of %s. However it is instance of %s and has value %s .Generic data has conversion %s, convertedType %s", value, value.getClass(), logicalType.getName(), logicalType, desiredRawType, rawType.getClass(), rawType, conversion, convertedType);
        if (!desiredRawType.isInstance(rawType)) {
            throw new IllegalArgumentException(msg);
        }
        return (T)rawType;
    }

    static {
        AvroUtils.addLogicalTypeConversions(GENERIC_DATA_WITH_DEFAULT_CONVERSIONS);
        GENERIC_DATA_WITH_DEFAULT_CONVERSIONS.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
    }

    private static final class AvroPojoFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private AvroPojoFieldValueTypeSupplier() {
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
            List classFields = ReflectUtils.getFields((Class)typeDescriptor.getRawType());
            HashMap types = Maps.newHashMap();
            for (int i = 0; i < classFields.size(); ++i) {
                Field f = (Field)classFields.get(i);
                if (f.isAnnotationPresent(AvroIgnore.class)) continue;
                FieldValueTypeInformation typeInformation = FieldValueTypeInformation.forField(typeDescriptor, (Field)f, (int)i);
                AvroName avroname = f.getAnnotation(AvroName.class);
                if (avroname != null) {
                    typeInformation = typeInformation.withName(avroname.value());
                }
                types.put(typeInformation.getName(), typeInformation);
            }
            return Lists.newArrayList(types.values());
        }
    }

    private static final class AvroSpecificRecordFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private AvroSpecificRecordFieldValueTypeSupplier() {
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
            throw new RuntimeException("Unexpected call.");
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            Map<String, String> mapping = this.getMapping(schema);
            List methods = ReflectUtils.getMethods((Class)typeDescriptor.getRawType());
            ArrayList types = Lists.newArrayList();
            for (int i = 0; i < methods.size(); ++i) {
                FieldValueTypeInformation fieldValueTypeInformation;
                String name;
                Method method = (Method)methods.get(i);
                if (!ReflectUtils.isGetter((Method)method) || (name = mapping.get((fieldValueTypeInformation = FieldValueTypeInformation.forGetter(typeDescriptor, (Method)method, (int)i)).getName())) == null) continue;
                types.add(fieldValueTypeInformation.withName(name));
            }
            return StaticSchemaInference.sortBySchema((List)types, (Schema)schema);
        }

        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getMapping(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            HashMap mapping = Maps.newHashMap();
            for (Schema.Field field : schema.getFields()) {
                String fieldName = field.getName();
                String getter = fieldName.contains("_") ? (Character.isLowerCase(fieldName.charAt(0)) ? CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName) : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, fieldName.replace("_", ""))) : (Character.isUpperCase(fieldName.charAt(0)) ? CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, fieldName) : fieldName);
                mapping.put(getter, fieldName);
                mapping.put(getter + "$", fieldName);
            }
            return mapping;
        }
    }

    private static class RowToGenericRecordFn
    implements SerializableFunction<Row, GenericRecord> {
        private transient @Nullable @UnknownKeyFor @Initialized org.apache.avro.Schema avroSchema;

        RowToGenericRecordFn(@Nullable @UnknownKeyFor @Initialized org.apache.avro.Schema avroSchema) {
            this.avroSchema = avroSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized GenericRecord apply(@UnknownKeyFor @NonNull @Initialized Row input) {
            return AvroUtils.toGenericRecord(input, this.avroSchema);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RowToGenericRecordFn that = (RowToGenericRecordFn)other;
            return Objects.equals(this.avroSchema, that.avroSchema);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.avroSchema);
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String avroSchemaAsString = this.avroSchema == null ? null : this.avroSchema.toString();
            out.writeObject(avroSchemaAsString);
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            String avroSchemaAsString = (String)in.readObject();
            this.avroSchema = avroSchemaAsString == null ? null : new Schema.Parser().parse(avroSchemaAsString);
        }
    }

    private static class GenericRecordToRowFn
    implements SerializableFunction<GenericRecord, Row> {
        private final @Nullable @UnknownKeyFor @Initialized Schema schema;

        GenericRecordToRowFn(@Nullable @UnknownKeyFor @Initialized Schema schema) {
            this.schema = schema;
        }

        public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized GenericRecord input) {
            return AvroUtils.toBeamRowStrict(input, this.schema);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            GenericRecordToRowFn that = (GenericRecordToRowFn)other;
            return Objects.equals(this.schema, that.schema);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.schema);
        }
    }

    private static class RowToAvroBytesFn
    extends SimpleFunction<Row, byte[]> {
        private final @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema;
        private final @UnknownKeyFor @NonNull @Initialized AvroCoder<@UnknownKeyFor @NonNull @Initialized GenericRecord> coder;

        RowToAvroBytesFn(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
            this.avroSchema = AvroUtils.toAvroSchema(beamSchema);
            this.coder = AvroCoder.of(this.avroSchema);
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            try {
                GenericRecord record = AvroUtils.toGenericRecord(row, this.avroSchema);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.coder.encode(record, outputStream);
                return outputStream.toByteArray();
            }
            catch (Exception e) {
                throw new AvroRuntimeException(String.format("Could not encode avro from given row: %s", row), (Throwable)e);
            }
        }
    }

    private static class AvroBytesToRowFn
    extends SimpleFunction<byte[], Row> {
        private final @UnknownKeyFor @NonNull @Initialized AvroCoder<@UnknownKeyFor @NonNull @Initialized GenericRecord> coder;
        private final @UnknownKeyFor @NonNull @Initialized Schema beamSchema;

        AvroBytesToRowFn(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
            org.apache.avro.Schema avroSchema = AvroUtils.toAvroSchema(beamSchema);
            this.coder = AvroCoder.of(avroSchema);
            this.beamSchema = beamSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                GenericRecord record = this.coder.decode(inputStream);
                return AvroUtils.toBeamRowStrict(record, this.beamSchema);
            }
            catch (Exception e) {
                throw new AvroRuntimeException("Could not decode avro record from given bytes " + new String(bytes, StandardCharsets.UTF_8), (Throwable)e);
            }
        }
    }

    static class AvroTypeConversionFactory
    implements ByteBuddyUtils.TypeConversionsFactory {
        AvroTypeConversionFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversion<@UnknownKeyFor @NonNull @Initialized Type> createTypeConversion(@UnknownKeyFor @NonNull @Initialized boolean returnRawTypes) {
            return new AvroConvertType(returnRawTypes);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversion<@UnknownKeyFor @NonNull @Initialized StackManipulation> createGetterConversions(@UnknownKeyFor @NonNull @Initialized StackManipulation readValue) {
            return new AvroConvertValueForGetter(readValue);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversion<@UnknownKeyFor @NonNull @Initialized StackManipulation> createSetterConversions(@UnknownKeyFor @NonNull @Initialized StackManipulation readValue) {
            return new AvroConvertValueForSetter(readValue);
        }
    }

    public static class AvroConvertValueForSetter
    extends ByteBuddyUtils.ConvertValueForSetter {
        AvroConvertValueForSetter(@UnknownKeyFor @NonNull @Initialized StackManipulation readValue) {
            super(readValue);
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory getFactory() {
            return new AvroTypeConversionFactory();
        }

        protected @UnknownKeyFor @NonNull @Initialized StackManipulation convertDefault(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
                return new StackManipulation.Compound(new StackManipulation[]{TypeCreation.of((TypeDescription)loadedType), Duplication.SINGLE, this.readValue, TypeCasting.to((TypeDefinition)BYTES), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((TypeDescription[])new TypeDescription[]{BYTES})))).getOnly()))});
            }
            if (Instant.class.isAssignableFrom(type.getRawType())) {
                StackManipulation.Compound onNotNull = new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JODA_READABLE_INSTANT.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"getMillis"))).getOnly())), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JAVA_INSTANT.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.named((String)"ofEpochMilli")))).getOnly()))});
                return this.shortCircuitReturnNull(this.readValue, (StackManipulation)onNotNull);
            }
            if (LocalDate.class.isAssignableFrom(type.getRawType())) {
                StackManipulation.Compound onNotNull = new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JODA_READABLE_INSTANT.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"getMillis"))).getOnly())), LongConstant.forValue((long)TimeUnit.DAYS.toMillis(1L)), Division.LONG, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JAVA_LOCALE_DATE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.named((String)"ofEpochDay")))).getOnly()))});
                return this.shortCircuitReturnNull(this.readValue, (StackManipulation)onNotNull);
            }
            return super.convertDefault(type);
        }
    }

    public static class AvroConvertValueForGetter
    extends ByteBuddyUtils.ConvertValueForGetter {
        AvroConvertValueForGetter(@UnknownKeyFor @NonNull @Initialized StackManipulation readValue) {
            super(readValue);
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory getFactory() {
            return new AvroTypeConversionFactory();
        }

        protected @UnknownKeyFor @NonNull @Initialized StackManipulation convertDefault(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(GenericFixed.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"bytes").and((ElementMatcher)ElementMatchers.returns((TypeDescription)BYTES)))).getOnly()))});
            }
            if (Instant.class.isAssignableFrom(type.getRawType())) {
                StackManipulation.Compound onNotNull = new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JAVA_INSTANT.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toEpochMilli"))).getOnly())), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JODA_INSTANT.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.named((String)"ofEpochMilli")))).getOnly()))});
                return this.shortCircuitReturnNull(this.readValue, (StackManipulation)onNotNull);
            }
            if (LocalDate.class.isAssignableFrom(type.getRawType())) {
                StackManipulation.Compound onNotNull = new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JAVA_LOCALE_DATE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toEpochDay"))).getOnly())), LongConstant.forValue((long)TimeUnit.DAYS.toMillis(1L)), Multiplication.LONG, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)JODA_INSTANT.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.named((String)"ofEpochMilli")))).getOnly()))});
                return this.shortCircuitReturnNull(this.readValue, (StackManipulation)onNotNull);
            }
            return super.convertDefault(type);
        }
    }

    public static class AvroConvertType
    extends ByteBuddyUtils.ConvertType {
        public AvroConvertType(@UnknownKeyFor @NonNull @Initialized boolean returnRawType) {
            super(returnRawType);
        }

        protected @UnknownKeyFor @NonNull @Initialized Type convertDefault(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(Instant.class)) || type.isSubtypeOf(TypeDescriptor.of(LocalDate.class))) {
                return this.convertDateTime(type);
            }
            if (type.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                return byte[].class;
            }
            return super.convertDefault(type);
        }
    }

    public static class FixedBytesField {
        private final @UnknownKeyFor @NonNull @Initialized int size;

        private FixedBytesField(@UnknownKeyFor @NonNull @Initialized int size) {
            this.size = size;
        }

        public static @UnknownKeyFor @NonNull @Initialized FixedBytesField withSize(@UnknownKeyFor @NonNull @Initialized int size) {
            return new FixedBytesField(size);
        }

        public static @Nullable @UnknownKeyFor @Initialized FixedBytesField fromBeamFieldType(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            if (fieldType.getTypeName().isLogicalType() && ((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier().equals(FixedBytes.IDENTIFIER)) {
                int length = ((FixedBytes)fieldType.getLogicalType(FixedBytes.class)).getLength();
                return new FixedBytesField(length);
            }
            return null;
        }

        public static @Nullable @UnknownKeyFor @Initialized FixedBytesField fromAvroType(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema type) {
            if (type.getType().equals((Object)Schema.Type.FIXED)) {
                return new FixedBytesField(type.getFixedSize());
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized int getSize() {
            return this.size;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType toBeamType() {
            return Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((int)this.size));
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema toAvroType(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String namespace) {
            return org.apache.avro.Schema.createFixed((String)name, (String)"", (String)namespace, (int)this.size);
        }
    }

    public static class TypeWithNullability {
        public final @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema type;
        public final @UnknownKeyFor @NonNull @Initialized boolean nullable;

        public static @UnknownKeyFor @NonNull @Initialized TypeWithNullability create(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema) {
            return new TypeWithNullability(avroSchema);
        }

        TypeWithNullability(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema) {
            if (avroSchema.getType() == Schema.Type.UNION) {
                List types = avroSchema.getTypes();
                List nonNullTypes = types.stream().filter(x -> x.getType() != Schema.Type.NULL).collect(Collectors.toList());
                if (nonNullTypes.size() == types.size() || nonNullTypes.isEmpty()) {
                    this.type = avroSchema;
                    this.nullable = false;
                } else if (nonNullTypes.size() > 1) {
                    this.type = org.apache.avro.Schema.createUnion(nonNullTypes);
                    this.nullable = true;
                } else {
                    this.type = (org.apache.avro.Schema)nonNullTypes.get(0);
                    this.nullable = true;
                }
            } else {
                this.type = avroSchema;
                this.nullable = false;
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Boolean isNullable() {
            return this.nullable;
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema getType() {
            return this.type;
        }
    }

    private static class NullnessCheckerWorkarounds {
        private NullnessCheckerWorkarounds() {
        }

        private static @UnknownKeyFor @NonNull @Initialized ReflectData newReflectData(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            @NonNull ClassLoader classLoader = clazz.getClassLoader();
            return new ReflectData(classLoader);
        }

        private static void builderSet(@UnknownKeyFor @NonNull @Initialized GenericRecordBuilder builder, @UnknownKeyFor @NonNull @Initialized String fieldName, @Nullable @UnknownKeyFor @Initialized Object value) {
            builder.set(fieldName, NullnessCheckerWorkarounds.castToNonNull(value));
        }

        private static @UnknownKeyFor @NonNull @Initialized Object createFixed(@Nullable @UnknownKeyFor @Initialized Object old, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema) {
            return GenericData.get().createFixed(NullnessCheckerWorkarounds.castToNonNull(old), bytes, schema);
        }

        private static <T> @NonNull T castToNonNull(@Nullable T value) {
            return value;
        }
    }
}

