/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SparkSessionFactory {
    public static @UnknownKeyFor @NonNull @Initialized SparkSession getOrCreateSession(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        if (options.getUseActiveSparkSession()) {
            return SparkSession.active();
        }
        return SparkSessionFactory.sessionBuilder(options.getSparkMaster(), options.getAppName(), options.getFilesToStage()).getOrCreate();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SparkSession.Builder sessionBuilder(@UnknownKeyFor @NonNull @Initialized String master) {
        return SparkSessionFactory.sessionBuilder(master, null, null);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SparkSession.Builder sessionBuilder(@UnknownKeyFor @NonNull @Initialized String master, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String appName, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> jars) {
        int numPartitions;
        SparkConf sparkConf = new SparkConf();
        sparkConf.setMaster(master);
        if (appName != null) {
            sparkConf.setAppName(appName);
        }
        if (jars != null && !jars.isEmpty()) {
            sparkConf.setJars(jars.toArray(new String[0]));
        }
        if (master != null && master.startsWith("local[") && System.getProperty("spark.sql.shuffle.partitions") == null && (numPartitions = Integer.parseInt(master.substring("local[".length(), master.length() - 1))) > 0) {
            sparkConf.set("spark.sql.shuffle.partitions", String.valueOf(numPartitions));
        }
        return SparkSession.builder().config(sparkConf);
    }
}

