/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.metrics.MetricsPusher;
import org.apache.beam.runners.spark.SparkCommonPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineResult;
import org.apache.beam.runners.spark.structuredstreaming.aggregators.AggregatorsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.metrics.AggregatorMetricSource;
import org.apache.beam.runners.spark.structuredstreaming.metrics.CompositeSource;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.metrics.SparkBeamMetricSource;
import org.apache.beam.runners.spark.structuredstreaming.translation.AbstractTranslationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.PipelineTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.streaming.PipelineTranslatorStreaming;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.source.Source;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkStructuredStreamingRunner
extends PipelineRunner<SparkStructuredStreamingPipelineResult> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkStructuredStreamingRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options;

    public static @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingRunner create() {
        SparkStructuredStreamingPipelineOptions options = (SparkStructuredStreamingPipelineOptions)PipelineOptionsFactory.as(SparkStructuredStreamingPipelineOptions.class);
        options.setRunner(SparkStructuredStreamingRunner.class);
        return new SparkStructuredStreamingRunner(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingRunner create(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        return new SparkStructuredStreamingRunner(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new SparkStructuredStreamingRunner((SparkStructuredStreamingPipelineOptions)PipelineOptionsValidator.validate(SparkStructuredStreamingPipelineOptions.class, (PipelineOptions)options));
    }

    private SparkStructuredStreamingRunner(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        MetricsEnvironment.setMetricsSupported((boolean)true);
        LOG.info("*** SparkStructuredStreamingRunner is based on spark structured streaming framework and is no more \n based on RDD/DStream API. See\n https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html\n It is still experimental, its coverage of the Beam model is partial. ***");
        LOG.warn("Support for Spark 2 is deprecated, this runner will be removed in a few releases.\nSpark 2 is reaching its EOL, consider migrating to Spark 3.");
        AggregatorsAccumulator.clear();
        MetricsAccumulator.clear();
        AbstractTranslationContext translationContext = this.translatePipeline(pipeline);
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LocalSpark-thread").build());
        Future<?> submissionFuture = executorService.submit(() -> translationContext.startPipeline());
        executorService.shutdown();
        Runnable onTerminalState = this.options.getUseActiveSparkSession() ? () -> {} : () -> translationContext.getSparkSession().stop();
        SparkStructuredStreamingPipelineResult result = new SparkStructuredStreamingPipelineResult(submissionFuture, onTerminalState);
        if (this.options.getEnableSparkMetricSinks().booleanValue()) {
            this.registerMetricsSource(this.options.getAppName());
        }
        MetricsPusher metricsPusher = new MetricsPusher(MetricsAccumulator.getInstance().value(), (MetricsOptions)this.options.as(MetricsOptions.class), (PipelineResult)result);
        metricsPusher.start();
        if (this.options.getTestMode()) {
            result.waitUntilFinish();
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized AbstractTranslationContext translatePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        PipelineTranslator.detectTranslationMode(pipeline, this.options);
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"beam_fn_api")) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary((Pipeline)pipeline);
        }
        PipelineTranslator.replaceTransforms(pipeline, this.options);
        SparkCommonPipelineOptions.prepareFilesToStage(this.options);
        PipelineTranslator pipelineTranslator = this.options.isStreaming() ? new PipelineTranslatorStreaming(this.options) : new PipelineTranslatorBatch(this.options);
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)pipelineTranslator.getTranslationContext().getSparkSession().sparkContext());
        SparkStructuredStreamingRunner.initAccumulators(this.options, jsc);
        pipelineTranslator.translate(pipeline);
        return pipelineTranslator.getTranslationContext();
    }

    private void registerMetricsSource(@UnknownKeyFor @NonNull @Initialized String appName) {
        MetricsSystem metricsSystem = SparkEnv$.MODULE$.get().metricsSystem();
        AggregatorMetricSource aggregatorMetricSource = new AggregatorMetricSource(null, AggregatorsAccumulator.getInstance().value());
        SparkBeamMetricSource metricsSource = new SparkBeamMetricSource(null);
        CompositeSource compositeSource = new CompositeSource(appName + ".Beam", metricsSource.metricRegistry(), aggregatorMetricSource.metricRegistry());
        metricsSystem.removeSource((Source)compositeSource);
        metricsSystem.registerSource((Source)compositeSource);
    }

    public static void initAccumulators(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions opts, @UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc) {
        MetricsAccumulator.init(jsc);
        AggregatorsAccumulator.init(jsc);
    }
}

