/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class SparkNativePipelineVisitor
extends SparkRunner.Evaluator {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NativeTransform> transforms;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> knownCompositesPackages = Lists.newArrayList((Object[])new String[]{"org.apache.beam.sdk.transforms", "org.apache.beam.runners.spark.examples"});

    SparkNativePipelineVisitor(@UnknownKeyFor @NonNull @Initialized SparkPipelineTranslator translator, @UnknownKeyFor @NonNull @Initialized EvaluationContext ctxt) {
        super(translator, ctxt);
        this.transforms = new ArrayList<NativeTransform>();
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        Pipeline.PipelineVisitor.CompositeBehavior compositeBehavior = super.enterCompositeTransform(node);
        PTransform transform = node.getTransform();
        if (transform != null) {
            Class<PTransform<?, ?>> transformClass = transform.getClass();
            if (compositeBehavior == Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM && !this.knownComposite(transformClass) && this.shouldDebug(node)) {
                this.transforms.add(new NativeTransform(node, null, transform, true));
            }
        }
        return compositeBehavior;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean knownComposite(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> transform) {
        String transformPackage = transform.getPackage().getName();
        for (String knownCompositePackage : this.knownCompositesPackages) {
            if (!transformPackage.startsWith(knownCompositePackage)) continue;
            return true;
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldDebug(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        return node == null || this.transforms.stream().noneMatch(debugTransform -> debugTransform.getNode().equals(node) && debugTransform.isComposite()) && this.shouldDebug(node.getEnclosingNode());
    }

    @Override
    <TransformT extends PTransform<? super PInput, POutput>> void doVisitTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        PTransform transform = node.getTransform();
        TransformEvaluator<PTransform> evaluator = this.translate(node, transform);
        if (this.shouldDebug(node)) {
            this.transforms.add(new NativeTransform(node, evaluator, transform, false));
        }
    }

    @UnknownKeyFor @NonNull @Initialized String getDebugString() {
        return Joiner.on((String)"\n").join(this.transforms);
    }

    private static class NativeTransform {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?> transformEvaluator;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform;
        private final @UnknownKeyFor @NonNull @Initialized boolean composite;

        NativeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?> transformEvaluator, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized boolean composite) {
            this.node = node;
            this.transformEvaluator = transformEvaluator;
            this.transform = transform;
            this.composite = composite;
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node getNode() {
            return this.node;
        }

        @UnknownKeyFor @NonNull @Initialized boolean isComposite() {
            return this.composite;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            try {
                Class<?> transformClass = this.transform.getClass();
                if ("KafkaIO.Read".equals(this.node.getFullName())) {
                    return "KafkaUtils.createDirectStream(...)";
                }
                if (this.composite) {
                    return "_.<" + transformClass.getName() + ">";
                }
                String transformString = this.transformEvaluator.toNativeString();
                if (transformString.contains("<fn>")) {
                    transformString = this.replaceFnString(transformClass, transformString, "fn");
                } else if (transformString.contains("<windowFn>")) {
                    transformString = this.replaceFnString(transformClass, transformString, "windowFn");
                } else if (transformString.contains("<source>")) {
                    String sourceName = "...";
                    if (this.transform instanceof SplittableParDo.PrimitiveBoundedRead) {
                        sourceName = ((SplittableParDo.PrimitiveBoundedRead)this.transform).getSource().getClass().getName();
                    } else if (this.transform instanceof SplittableParDo.PrimitiveUnboundedRead) {
                        sourceName = ((SplittableParDo.PrimitiveUnboundedRead)this.transform).getSource().getClass().getName();
                    }
                    transformString = transformString.replace("<source>", sourceName);
                }
                if (transformString.startsWith("sparkContext") || transformString.startsWith("streamingContext")) {
                    return transformString;
                }
                return "_." + transformString;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                return "<FailedTranslation>";
            }
        }

        private @UnknownKeyFor @NonNull @Initialized String replaceFnString(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform> transformClass, @UnknownKeyFor @NonNull @Initialized String transformString, @UnknownKeyFor @NonNull @Initialized String fnFieldName) throws @UnknownKeyFor @NonNull @Initialized IllegalAccessException, @UnknownKeyFor @NonNull @Initialized InvocationTargetException, @UnknownKeyFor @NonNull @Initialized NoSuchMethodException, @UnknownKeyFor @NonNull @Initialized NoSuchFieldException {
            String doFnName;
            Object fn = transformClass.getMethod("get" + StringUtils.capitalize((String)fnFieldName), new Class[0]).invoke(this.transform, new Object[0]);
            Class<?> fnClass = fn.getClass();
            Class<?> enclosingClass = fnClass.getEnclosingClass();
            if (enclosingClass != null && enclosingClass.equals(MapElements.class)) {
                Field parent = fnClass.getDeclaredField("this$0");
                parent.setAccessible(true);
                Field fnField = enclosingClass.getDeclaredField(fnFieldName);
                fnField.setAccessible(true);
                doFnName = fnField.get(parent.get(fn)).getClass().getName();
            } else {
                doFnName = fnClass.getName();
            }
            transformString = transformString.replace("<" + fnFieldName + ">", doFnName);
            return transformString;
        }
    }
}

