/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.metrics;

import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.metrics.SparkMetricsContainerStepMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.AccumulatorV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsAccumulator.class);
    private static final String ACCUMULATOR_NAME = "Beam.Metrics";
    private static volatile MetricsContainerStepMapAccumulator instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(JavaSparkContext jsc) {
        if (instance == null) {
            Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
            synchronized (MetricsAccumulator.class) {
                if (instance == null) {
                    SparkMetricsContainerStepMap metricsContainerStepMap = new SparkMetricsContainerStepMap();
                    MetricsContainerStepMapAccumulator accumulator = new MetricsContainerStepMapAccumulator(metricsContainerStepMap);
                    jsc.sc().register((AccumulatorV2)accumulator, ACCUMULATOR_NAME);
                    instance = accumulator;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                LOG.info("Instantiated metrics accumulator: {}", (Object)instance.value());
            }
        } else {
            instance.reset();
        }
    }

    public static MetricsContainerStepMapAccumulator getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Metrics accumulator has not been instantiated");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clear() {
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

