/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import org.apache.beam.runners.spark.SparkContextOptions;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.SparkRunnerKryoRegistrator;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkContextFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkContextFactory.class);
    public static final @UnknownKeyFor @NonNull @Initialized String TEST_REUSE_SPARK_CONTEXT = "beam.spark.test.reuseSparkContext";
    private static @UnknownKeyFor @NonNull @Initialized JavaSparkContext sparkContext;
    private static @UnknownKeyFor @NonNull @Initialized String sparkMaster;
    private static @UnknownKeyFor @NonNull @Initialized boolean usesProvidedSparkContext;

    private SparkContextFactory() {
    }

    public static synchronized @UnknownKeyFor @NonNull @Initialized JavaSparkContext getSparkContext(@UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options) {
        SparkContextOptions contextOptions = (SparkContextOptions)options.as(SparkContextOptions.class);
        usesProvidedSparkContext = contextOptions.getUsesProvidedSparkContext();
        if (Boolean.getBoolean(TEST_REUSE_SPARK_CONTEXT) && !usesProvidedSparkContext) {
            if (sparkContext == null || sparkContext.sc().isStopped()) {
                sparkContext = SparkContextFactory.createSparkContext(contextOptions);
                sparkMaster = options.getSparkMaster();
            } else if (!options.getSparkMaster().equals(sparkMaster)) {
                throw new IllegalArgumentException(String.format("Cannot reuse spark context with different spark master URL. Existing: %s, requested: %s.", sparkMaster, options.getSparkMaster()));
            }
            return sparkContext;
        }
        return SparkContextFactory.createSparkContext(contextOptions);
    }

    public static synchronized void stopSparkContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext context) {
        if (!Boolean.getBoolean(TEST_REUSE_SPARK_CONTEXT) && !usesProvidedSparkContext) {
            context.stop();
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized JavaSparkContext createSparkContext(@UnknownKeyFor @NonNull @Initialized SparkContextOptions contextOptions) {
        if (usesProvidedSparkContext) {
            LOG.info("Using a provided Spark Context");
            JavaSparkContext jsc = contextOptions.getProvidedSparkContext();
            if (jsc == null || jsc.sc().isStopped()) {
                LOG.error("The provided Spark context " + jsc + " was not created or was stopped");
                throw new RuntimeException("The provided Spark context was not created or was stopped");
            }
            return jsc;
        }
        LOG.info("Creating a brand new Spark Context.");
        SparkConf conf = new SparkConf();
        if (!conf.contains("spark.master")) {
            conf.setMaster(contextOptions.getSparkMaster());
        }
        if (contextOptions.getFilesToStage() != null && !contextOptions.getFilesToStage().isEmpty()) {
            conf.setJars(contextOptions.getFilesToStage().toArray(new String[0]));
        }
        conf.setAppName(contextOptions.getAppName());
        conf.set("spark.kryo.registrator", SparkRunnerKryoRegistrator.class.getName());
        return new JavaSparkContext(conf);
    }
}

