/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ProcessContext<@UnknownKeyFor FnInputT, @UnknownKeyFor FnOutputT, @UnknownKeyFor OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFn<FnInputT, FnOutputT> doFn;
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner;
    private final @UnknownKeyFor @NonNull @Initialized ProcessOutputManager<OutputT> outputManager;
    private final @UnknownKeyFor @NonNull @Initialized Iterator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerDataIterator;

    ProcessContext(@UnknownKeyFor @NonNull @Initialized DoFn<FnInputT, FnOutputT> doFn, @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner, @UnknownKeyFor @NonNull @Initialized ProcessOutputManager<OutputT> outputManager, @UnknownKeyFor @NonNull @Initialized Iterator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerDataIterator) {
        this.doFn = doFn;
        this.doFnRunner = doFnRunner;
        this.outputManager = outputManager;
        this.timerDataIterator = timerDataIterator;
    }

    @UnknownKeyFor @NonNull @Initialized Iterable<OutputT> processPartition(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> partition) {
        if (!partition.hasNext()) {
            return new ArrayList();
        }
        return this.getOutputIterable(partition, this.doFnRunner);
    }

    private void clearOutput() {
        this.outputManager.clear();
    }

    private @UnknownKeyFor @NonNull @Initialized Iterator<OutputT> getOutputIterator() {
        return this.outputManager.iterator();
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<OutputT> getOutputIterable(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> iter, @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
        return () -> new ProcCtxtIterator(iter, doFnRunner);
    }

    private class ProcCtxtIterator
    extends AbstractIterator<OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> inputIterator;
        private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<FnInputT, FnOutputT> doFnRunner;
        private @UnknownKeyFor @NonNull @Initialized Iterator<OutputT> outputIterator;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleStarted;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleFinished;

        ProcCtxtIterator(@UnknownKeyFor @NonNull @Initialized Iterator<WindowedValue<FnInputT>> iterator, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
            this.inputIterator = iterator;
            this.doFnRunner = doFnRunner;
            this.outputIterator = ProcessContext.this.getOutputIterator();
        }

        protected OutputT computeNext() {
            try {
                if (!this.isBundleStarted) {
                    this.isBundleStarted = true;
                    this.doFnRunner.startBundle();
                }
                while (true) {
                    if (this.outputIterator.hasNext()) {
                        return this.outputIterator.next();
                    }
                    ProcessContext.this.clearOutput();
                    if (this.inputIterator.hasNext()) {
                        this.doFnRunner.processElement(this.inputIterator.next());
                        this.outputIterator = ProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (ProcessContext.this.timerDataIterator.hasNext()) {
                        this.outputIterator = ProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.doFnRunner.finishBundle();
                    this.outputIterator = ProcessContext.this.getOutputIterator();
                }
                DoFnInvokers.invokerFor((DoFn)ProcessContext.this.doFn).invokeTeardown();
                return this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor((DoFn)ProcessContext.this.doFn).invokeTeardown();
                throw re;
            }
        }
    }

    static interface ProcessOutputManager<@UnknownKeyFor T>
    extends DoFnRunners.OutputManager,
    Iterable<T> {
        public void clear();
    }
}

