/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

class DoFnRunnerWithMetrics<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final DoFnRunner<InputT, OutputT> delegate;
    private final String stepName;
    private final MetricsContainerStepMapAccumulator metricsAccum;

    DoFnRunnerWithMetrics(String stepName, DoFnRunner<InputT, OutputT> delegate, MetricsContainerStepMapAccumulator metricsAccum) {
        this.delegate = delegate;
        this.stepName = stepName;
        this.metricsAccum = metricsAccum;
    }

    public DoFn<InputT, OutputT> getFn() {
        return this.delegate.getFn();
    }

    public void startBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.startBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processElement(WindowedValue<InputT> elem) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.processElement(elem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onTimer(String timerId, String timerFamilyId, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.onTimer(timerId, timerFamilyId, window, timestamp, outputTimestamp, timeDomain);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.finishBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MetricsContainer metricsContainer() {
        return this.metricsAccum.value().getContainer(this.stepName);
    }
}

