/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.function.MapFunction;
import org.joda.time.Instant;

public final class WindowingHelpers {
    public static <T, W extends BoundedWindow> boolean skipAssignWindows(Window.Assign<T> transform, TranslationContext context) {
        WindowFn windowFnToApply = transform.getWindowFn();
        PCollection input = (PCollection)context.getInput();
        WindowFn windowFnOfInput = input.getWindowingStrategy().getWindowFn();
        return windowFnToApply == null || windowFnOfInput instanceof GlobalWindows && windowFnToApply instanceof GlobalWindows;
    }

    public static <T, W extends BoundedWindow> MapFunction<WindowedValue<T>, WindowedValue<T>> assignWindowsMapFunction(WindowFn<T, W> windowFn) {
        return (MapFunction & Serializable)windowedValue -> {
            final BoundedWindow boundedWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)windowedValue.getWindows());
            final Object element = windowedValue.getValue();
            final Instant timestamp = windowedValue.getTimestamp();
            WindowFn windowFn2 = windowFn;
            Objects.requireNonNull(windowFn2);
            Collection windows = windowFn.assignWindows(new WindowFn.AssignContext(windowFn2){

                public T element() {
                    return element;
                }

                public Instant timestamp() {
                    return timestamp;
                }

                public BoundedWindow window() {
                    return boundedWindow;
                }
            });
            return WindowedValue.of((Object)element, (Instant)timestamp, (Collection)windows, (PaneInfo)windowedValue.getPane());
        };
    }
}

