/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.PipelineResources;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkTransformOverrides;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineTranslator
extends Pipeline.PipelineVisitor.Defaults {
    private int depth = 0;
    private static final Logger LOG = LoggerFactory.getLogger(PipelineTranslator.class);
    protected TranslationContext translationContext;

    public static void prepareFilesToStageForRemoteClusterExecution(SparkStructuredStreamingPipelineOptions options) {
        if (!options.getSparkMaster().matches("local\\[?\\d*]?")) {
            options.setFilesToStage(PipelineResources.prepareFilesForStaging(options.getFilesToStage(), (String)options.getTempLocation()));
        }
    }

    public static void replaceTransforms(Pipeline pipeline, StreamingOptions options) {
        pipeline.replaceAll(SparkTransformOverrides.getDefaultOverrides(options.isStreaming()));
    }

    public static void detectTranslationMode(Pipeline pipeline, StreamingOptions options) {
        TranslationModeDetector detector = new TranslationModeDetector();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)detector);
        if (detector.getTranslationMode().equals((Object)TranslationMode.STREAMING)) {
            options.setStreaming(true);
        }
    }

    private static String genSpaces(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("|   ");
        }
        return builder.toString();
    }

    protected abstract TransformTranslator<?> getTransformTranslator(TransformHierarchy.Node var1);

    private <T extends PTransform<?, ?>> void applyTransformTranslator(TransformHierarchy.Node node, TransformTranslator<?> transformTranslator) {
        this.translationContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        PTransform typedTransform = node.getTransform();
        TransformTranslator<?> typedTransformTranslator = transformTranslator;
        typedTransformTranslator.translateTransform(typedTransform, this.translationContext);
    }

    public void translate(Pipeline pipeline) {
        LOG.debug("starting translation of the pipeline using {}", (Object)((Object)((Object)this)).getClass().getName());
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)this);
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        LOG.debug("{} enterCompositeTransform- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        ++this.depth;
        TransformTranslator<?> transformTranslator = this.getTransformTranslator(node);
        if (transformTranslator != null) {
            this.applyTransformTranslator(node, transformTranslator);
            LOG.debug("{} translated- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        --this.depth;
        LOG.debug("{} leaveCompositeTransform- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        LOG.debug("{} visitPrimitiveTransform- {}", (Object)PipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        TransformTranslator<?> transformTranslator = this.getTransformTranslator(node);
        if (transformTranslator == null) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)node.getTransform());
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.applyTransformTranslator(node, transformTranslator);
    }

    public TranslationContext getTranslationContext() {
        return this.translationContext;
    }

    private static class TranslationModeDetector
    extends Pipeline.PipelineVisitor.Defaults {
        private static final Logger LOG = LoggerFactory.getLogger(TranslationModeDetector.class);
        private TranslationMode translationMode;

        TranslationModeDetector(TranslationMode defaultMode) {
            this.translationMode = defaultMode;
        }

        TranslationModeDetector() {
            this(TranslationMode.BATCH);
        }

        TranslationMode getTranslationMode() {
            return this.translationMode;
        }

        public void visitValue(PValue value, TransformHierarchy.Node producer) {
            if (this.translationMode.equals((Object)TranslationMode.BATCH) && value instanceof PCollection && ((PCollection)value).isBounded() == PCollection.IsBounded.UNBOUNDED) {
                LOG.info("Found unbounded PCollection {}. Switching to streaming execution.", (Object)value.getName());
                this.translationMode = TranslationMode.STREAMING;
            }
        }
    }

    private static enum TranslationMode {
        BATCH,
        STREAMING;

    }
}

