/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.DoFnRunnerWithMetrics;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.runners.spark.util.CachedSideInputReader;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.SparkSideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.LinkedListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import scala.Tuple2;

public class MultiDoFnFunction<InputT, OutputT>
implements PairFlatMapFunction<Iterator<WindowedValue<InputT>>, TupleTag<?>, WindowedValue<?>> {
    private final MetricsContainerStepMapAccumulator metricsAccum;
    private final String stepName;
    private final DoFn<InputT, OutputT> doFn;
    private transient boolean wasSetupCalled;
    private final SerializablePipelineOptions options;
    private final TupleTag<OutputT> mainOutputTag;
    private final List<TupleTag<?>> additionalOutputTags;
    private final Coder<InputT> inputCoder;
    private final Map<TupleTag<?>, Coder<?>> outputCoders;
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final boolean stateful;
    private final DoFnSchemaInformation doFnSchemaInformation;

    public MultiDoFnFunction(MetricsContainerStepMapAccumulator metricsAccum, String stepName, DoFn<InputT, OutputT> doFn, SerializablePipelineOptions options, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, Coder<InputT> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy, boolean stateful, DoFnSchemaInformation doFnSchemaInformation) {
        this.metricsAccum = metricsAccum;
        this.stepName = stepName;
        this.doFn = (DoFn)SerializableUtils.clone(doFn);
        this.options = options;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.inputCoder = inputCoder;
        this.outputCoders = outputCoders;
        this.sideInputs = sideInputs;
        this.windowingStrategy = windowingStrategy;
        this.stateful = stateful;
        this.doFnSchemaInformation = doFnSchemaInformation;
    }

    public Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> call(Iterator<WindowedValue<InputT>> iter) throws Exception {
        SparkProcessContext.NoOpStepContext context;
        InMemoryTimerInternals timerInternals;
        if (!this.wasSetupCalled && iter.hasNext()) {
            DoFnInvokers.tryInvokeSetupFor(this.doFn);
            this.wasSetupCalled = true;
        }
        DoFnOutputManager outputManager = new DoFnOutputManager();
        if (this.stateful) {
            Object key = null;
            if (iter.hasNext()) {
                WindowedValue<InputT> currentValue = iter.next();
                key = ((KV)currentValue.getValue()).getKey();
                iter = Iterators.concat((Iterator)Iterators.singletonIterator(currentValue), iter);
            }
            final InMemoryStateInternals stateInternals = InMemoryStateInternals.forKey(key);
            timerInternals = new InMemoryTimerInternals();
            context = new StepContext(){

                public StateInternals stateInternals() {
                    return stateInternals;
                }

                public TimerInternals timerInternals() {
                    return timerInternals;
                }
            };
        } else {
            timerInternals = null;
            context = new SparkProcessContext.NoOpStepContext();
        }
        DoFnRunner doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.options.get(), this.doFn, (SideInputReader)CachedSideInputReader.of(new SparkSideInputReader(this.sideInputs)), (DoFnRunners.OutputManager)outputManager, this.mainOutputTag, this.additionalOutputTags, (StepContext)context, this.inputCoder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation);
        DoFnRunnerWithMetrics doFnRunnerWithMetrics = new DoFnRunnerWithMetrics(this.stepName, doFnRunner, this.metricsAccum);
        return new SparkProcessContext(this.doFn, doFnRunnerWithMetrics, outputManager, this.stateful ? new TimerDataIterator(timerInternals) : Collections.emptyIterator()).processPartition(iter).iterator();
    }

    private class DoFnOutputManager
    implements SparkProcessContext.SparkOutputManager<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final Multimap<TupleTag<?>, WindowedValue<?>> outputs = LinkedListMultimap.create();

        private DoFnOutputManager() {
        }

        @Override
        public void clear() {
            this.outputs.clear();
        }

        @Override
        public Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> iterator() {
            Iterator entryIter = this.outputs.entries().iterator();
            return Iterators.transform(entryIter, this.entryToTupleFn());
        }

        private <K, V> Function<Map.Entry<K, V>, Tuple2<K, V>> entryToTupleFn() {
            return en -> new Tuple2(en.getKey(), en.getValue());
        }

        public synchronized <T> void output(TupleTag<T> tag, WindowedValue<T> output) {
            this.outputs.put(tag, output);
        }
    }

    private static class TimerDataIterator
    implements Iterator<TimerInternals.TimerData> {
        private final InMemoryTimerInternals timerInternals;
        private boolean hasAdvance;
        private TimerInternals.TimerData timerData;

        TimerDataIterator(InMemoryTimerInternals timerInternals) {
            this.timerInternals = timerInternals;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasAdvance) {
                try {
                    this.timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    this.timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    this.timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.hasAdvance = true;
            }
            return (this.timerData = this.timerInternals.removeNextEventTimer()) != null || (this.timerData = this.timerInternals.removeNextProcessingTimer()) != null || (this.timerData = this.timerInternals.removeNextSynchronizedProcessingTimer()) != null;
        }

        @Override
        public TimerInternals.TimerData next() {
            if (this.timerData == null) {
                throw new NoSuchElementException();
            }
            return this.timerData;
        }

        @Override
        public void remove() {
            throw new RuntimeException("TimerDataIterator not support remove!");
        }
    }
}

