/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineResources;
import org.apache.beam.runners.core.construction.graph.GreedyPipelineFuser;
import org.apache.beam.runners.core.construction.graph.PipelineTrimmer;
import org.apache.beam.runners.core.metrics.MetricsPusher;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineResult;
import org.apache.beam.runners.spark.aggregators.AggregatorsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.translation.SparkBatchPortablePipelineTranslator;
import org.apache.beam.runners.spark.translation.SparkContextFactory;
import org.apache.beam.runners.spark.translation.SparkTranslationContext;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPipelineRunner
implements PortablePipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SparkPipelineRunner.class);
    private final SparkPipelineOptions pipelineOptions;

    public SparkPipelineRunner(SparkPipelineOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public SparkPipelineResult run(RunnerApi.Pipeline pipeline, JobInfo jobInfo) {
        RunnerApi.Pipeline fusedPipeline;
        SparkBatchPortablePipelineTranslator translator = new SparkBatchPortablePipelineTranslator();
        RunnerApi.Pipeline trimmedPipeline = PipelineTrimmer.trim((RunnerApi.Pipeline)pipeline, translator.knownUrns());
        RunnerApi.Pipeline pipeline2 = fusedPipeline = trimmedPipeline.getComponents().getTransformsMap().values().stream().anyMatch(proto -> "beam:runner:executable_stage:v1".equals(proto.getSpec().getUrn())) ? trimmedPipeline : GreedyPipelineFuser.fuse((RunnerApi.Pipeline)trimmedPipeline).toPipeline();
        if (this.pipelineOptions.getFilesToStage() == null) {
            this.pipelineOptions.setFilesToStage(PipelineResources.detectClassPathResourcesToStage((ClassLoader)SparkPipelineRunner.class.getClassLoader()));
            LOG.info("PipelineOptions.filesToStage was not specified. Defaulting to files from the classpath");
        }
        SparkPipelineOptions.prepareFilesToStage(this.pipelineOptions);
        LOG.info("Will stage {} files. (Enable logging at DEBUG level to see which files will be staged.)", (Object)this.pipelineOptions.getFilesToStage().size());
        LOG.debug("Staging files: {}", this.pipelineOptions.getFilesToStage());
        JavaSparkContext jsc = SparkContextFactory.getSparkContext(this.pipelineOptions);
        LOG.info(String.format("Running job %s on Spark master %s", jobInfo.jobId(), jsc.master()));
        AggregatorsAccumulator.init(this.pipelineOptions, jsc);
        MetricsEnvironment.setMetricsSupported((boolean)false);
        MetricsAccumulator.init(this.pipelineOptions, jsc);
        SparkTranslationContext context = new SparkTranslationContext(jsc, this.pipelineOptions, jobInfo);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<?> submissionFuture = executorService.submit(() -> {
            translator.translate(fusedPipeline, context);
            LOG.info(String.format("Job %s: Pipeline translated successfully. Computing outputs", jobInfo.jobId()));
            context.computeOutputs();
            LOG.info(String.format("Job %s finished.", jobInfo.jobId()));
        });
        SparkPipelineResult.BatchMode result = new SparkPipelineResult.BatchMode(submissionFuture, jsc);
        MetricsPusher metricsPusher = new MetricsPusher(MetricsAccumulator.getInstance().value(), (MetricsOptions)this.pipelineOptions.as(MetricsOptions.class), (PipelineResult)result);
        metricsPusher.start();
        result.waitUntilFinish();
        executorService.shutdown();
        return result;
    }
}

