/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.aggregators;

import java.io.IOException;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.aggregators.NamedAggregatorsAccumulator;
import org.apache.beam.runners.spark.translation.streaming.Checkpoint;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingListener;
import org.apache.spark.streaming.api.java.JavaStreamingListenerBatchCompleted;
import org.apache.spark.util.AccumulatorV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorsAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorsAccumulator.class);
    private static final String ACCUMULATOR_NAME = "Beam.Aggregators";
    private static final String ACCUMULATOR_CHECKPOINT_FILENAME = "aggregators";
    private static volatile NamedAggregatorsAccumulator instance = null;
    private static volatile FileSystem fileSystem;
    private static volatile Path checkpointFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(SparkPipelineOptions opts, JavaSparkContext jsc) {
        if (instance != null) return;
        Class<AggregatorsAccumulator> clazz = AggregatorsAccumulator.class;
        synchronized (AggregatorsAccumulator.class) {
            if (instance == null) {
                Optional<NamedAggregators> maybeRecoveredValue;
                Optional maybeCheckpointDir = opts.isStreaming() ? Optional.of((Object)new Checkpoint.CheckpointDir(opts.getCheckpointDir())) : Optional.absent();
                NamedAggregators namedAggregators = new NamedAggregators();
                NamedAggregatorsAccumulator accumulator = new NamedAggregatorsAccumulator(namedAggregators);
                jsc.sc().register((AccumulatorV2)accumulator, ACCUMULATOR_NAME);
                if (maybeCheckpointDir.isPresent() && (maybeRecoveredValue = AggregatorsAccumulator.recoverValueFromCheckpoint(jsc, (Checkpoint.CheckpointDir)maybeCheckpointDir.get())).isPresent()) {
                    accumulator = new NamedAggregatorsAccumulator((NamedAggregators)maybeRecoveredValue.get());
                }
                instance = accumulator;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            LOG.info("Instantiated aggregators accumulator: " + instance.value());
            return;
        }
    }

    public static NamedAggregatorsAccumulator getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Aggregrators accumulator has not been instantiated");
        }
        return instance;
    }

    private static Optional<NamedAggregators> recoverValueFromCheckpoint(JavaSparkContext jsc, Checkpoint.CheckpointDir checkpointDir) {
        try {
            Path beamCheckpointPath = checkpointDir.getBeamCheckpointDir();
            checkpointFilePath = new Path(beamCheckpointPath, ACCUMULATOR_CHECKPOINT_FILENAME);
            fileSystem = checkpointFilePath.getFileSystem(jsc.hadoopConfiguration());
            NamedAggregators recoveredValue = (NamedAggregators)Checkpoint.readObject(fileSystem, checkpointFilePath);
            if (recoveredValue != null) {
                LOG.info("Recovered aggregators from checkpoint");
                return Optional.of((Object)recoveredValue);
            }
            LOG.info("No accumulator checkpoint found.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure while reading accumulator checkpoint.", e);
        }
        return Optional.absent();
    }

    private static void checkpoint() throws IOException {
        if (checkpointFilePath != null) {
            Checkpoint.writeObject(fileSystem, checkpointFilePath, instance.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clear() {
        Class<AggregatorsAccumulator> clazz = AggregatorsAccumulator.class;
        synchronized (AggregatorsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static class AccumulatorCheckpointingSparkListener
    extends JavaStreamingListener {
        public void onBatchCompleted(JavaStreamingListenerBatchCompleted batchCompleted) {
            try {
                AggregatorsAccumulator.checkpoint();
            }
            catch (IOException e) {
                LOG.error("Failed to checkpoint accumulator singleton.", (Throwable)e);
            }
        }
    }
}

