/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.util.IOChannelUtils;
import org.apache.spark.Accumulator;

public class SparkRuntimeContext
implements Serializable {
    private final String serializedPipelineOptions;
    private transient CoderRegistry coderRegistry;
    private final Map<String, Aggregator<?, ?>> aggregators = new HashMap();

    SparkRuntimeContext(Pipeline pipeline) {
        this.serializedPipelineOptions = this.serializePipelineOptions(pipeline.getOptions());
    }

    private String serializePipelineOptions(PipelineOptions pipelineOptions) {
        try {
            return new ObjectMapper().writeValueAsString((Object)pipelineOptions);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize the pipeline options.", e);
        }
    }

    private static PipelineOptions deserializePipelineOptions(String serializedPipelineOptions) {
        try {
            return (PipelineOptions)new ObjectMapper().readValue(serializedPipelineOptions, PipelineOptions.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize the pipeline options.", e);
        }
    }

    public PipelineOptions getPipelineOptions() {
        return PipelineOptionsHolder.getOrInit(this.serializedPipelineOptions);
    }

    public synchronized <InputT, InterT, OutputT> Aggregator<InputT, OutputT> createAggregator(Accumulator<NamedAggregators> accum, String named, Combine.CombineFn<? super InputT, InterT, OutputT> combineFn) {
        Aggregator<?, ?> aggregator = this.aggregators.get(named);
        try {
            if (aggregator == null) {
                NamedAggregators.CombineFunctionState<? super InputT, InterT, OutputT> state = new NamedAggregators.CombineFunctionState<InputT, InterT, OutputT>(combineFn, this.getCoderRegistry().getCoder(combineFn.getOutputType()), this);
                accum.add((Object)new NamedAggregators(named, state));
                aggregator = new SparkAggregator(named, state);
                this.aggregators.put(named, aggregator);
            }
            return aggregator;
        }
        catch (CannotProvideCoderException e) {
            throw new RuntimeException(String.format("Unable to create an aggregator named: [%s]", named), e);
        }
    }

    public CoderRegistry getCoderRegistry() {
        if (this.coderRegistry == null) {
            this.coderRegistry = new CoderRegistry();
            this.coderRegistry.registerStandardCoders();
        }
        return this.coderRegistry;
    }

    private static class SparkAggregator<InputT, OutputT>
    implements Aggregator<InputT, OutputT>,
    Serializable {
        private final String name;
        private final NamedAggregators.State<InputT, ?, OutputT> state;

        SparkAggregator(String name, NamedAggregators.State<InputT, ?, OutputT> state) {
            this.name = name;
            this.state = state;
        }

        public String getName() {
            return this.name;
        }

        public void addValue(InputT elem) {
            this.state.update(elem);
        }

        public Combine.CombineFn<InputT, ?, OutputT> getCombineFn() {
            return this.state.getCombineFn();
        }
    }

    private static class PipelineOptionsHolder {
        private static volatile transient PipelineOptions pipelineOptions = null;

        private PipelineOptionsHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static PipelineOptions getOrInit(String serializedPipelineOptions) {
            if (pipelineOptions != null) return pipelineOptions;
            Class<PipelineOptionsHolder> clazz = PipelineOptionsHolder.class;
            synchronized (PipelineOptionsHolder.class) {
                if (pipelineOptions == null) {
                    pipelineOptions = SparkRuntimeContext.deserializePipelineOptions(serializedPipelineOptions);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                IOChannelUtils.registerIOFactoriesAllowOverride((PipelineOptions)pipelineOptions);
                return pipelineOptions;
            }
        }
    }
}

