/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.IOException;
import java.util.Iterator;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.ExecutionContext;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.spark.repackaged.com.google.common.collect.AbstractIterator;
import org.apache.beam.spark.repackaged.com.google.common.collect.Lists;

class SparkProcessContext<FnInputT, FnOutputT, OutputT> {
    private final DoFn<FnInputT, FnOutputT> doFn;
    private final DoFnRunner<FnInputT, FnOutputT> doFnRunner;
    private final SparkOutputManager<OutputT> outputManager;

    SparkProcessContext(DoFn<FnInputT, FnOutputT> doFn, DoFnRunner<FnInputT, FnOutputT> doFnRunner, SparkOutputManager<OutputT> outputManager) {
        this.doFn = doFn;
        this.doFnRunner = doFnRunner;
        this.outputManager = outputManager;
    }

    Iterable<OutputT> processPartition(Iterator<WindowedValue<FnInputT>> partition) throws Exception {
        DoFnInvokers.invokerFor(this.doFn).invokeSetup();
        if (!partition.hasNext()) {
            DoFnInvokers.invokerFor(this.doFn).invokeTeardown();
            return Lists.newArrayList();
        }
        this.doFnRunner.startBundle();
        return this.getOutputIterable(partition, this.doFnRunner);
    }

    private void clearOutput() {
        this.outputManager.clear();
    }

    private Iterator<OutputT> getOutputIterator() {
        return this.outputManager.iterator();
    }

    private Iterable<OutputT> getOutputIterable(final Iterator<WindowedValue<FnInputT>> iter, final DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
        return new Iterable<OutputT>(){

            @Override
            public Iterator<OutputT> iterator() {
                return new ProcCtxtIterator(iter, doFnRunner);
            }
        };
    }

    private class ProcCtxtIterator
    extends AbstractIterator<OutputT> {
        private final Iterator<WindowedValue<FnInputT>> inputIterator;
        private final DoFnRunner<FnInputT, FnOutputT> doFnRunner;
        private Iterator<OutputT> outputIterator;
        private boolean calledFinish;

        ProcCtxtIterator(Iterator<WindowedValue<FnInputT>> iterator, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
            this.inputIterator = iterator;
            this.doFnRunner = doFnRunner;
            this.outputIterator = SparkProcessContext.this.getOutputIterator();
        }

        @Override
        protected OutputT computeNext() {
            while (true) {
                if (this.outputIterator.hasNext()) {
                    return this.outputIterator.next();
                }
                if (this.inputIterator.hasNext()) {
                    SparkProcessContext.this.clearOutput();
                    this.doFnRunner.processElement(this.inputIterator.next());
                    this.outputIterator = SparkProcessContext.this.getOutputIterator();
                    continue;
                }
                if (this.calledFinish) break;
                SparkProcessContext.this.clearOutput();
                this.calledFinish = true;
                this.doFnRunner.finishBundle();
                DoFnInvokers.invokerFor((DoFn)SparkProcessContext.this.doFn).invokeTeardown();
                this.outputIterator = SparkProcessContext.this.getOutputIterator();
            }
            return this.endOfData();
        }
    }

    static class NoOpStepContext
    implements ExecutionContext.StepContext {
        NoOpStepContext() {
        }

        public String getStepName() {
            return null;
        }

        public String getTransformName() {
            return null;
        }

        public void noteOutput(WindowedValue<?> output) {
        }

        public void noteSideOutput(TupleTag<?> tag, WindowedValue<?> output) {
        }

        public <T, W extends BoundedWindow> void writePCollectionViewData(TupleTag<?> tag, Iterable<WindowedValue<T>> data, Coder<Iterable<WindowedValue<T>>> dataCoder, W window, Coder<W> windowCoder) throws IOException {
        }

        public StateInternals<?> stateInternals() {
            return null;
        }

        public TimerInternals timerInternals() {
            return null;
        }
    }

    static interface SparkOutputManager<T>
    extends DoFnRunners.OutputManager,
    Iterable<T> {
        public void clear();
    }
}

