/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.ReifyTimestampsAndWindowsFunction;
import org.apache.beam.runners.spark.translation.SparkGlobalCombineFn;
import org.apache.beam.runners.spark.translation.SparkKeyedCombineFn;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.spark.repackaged.com.google.common.base.Preconditions;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;

public class GroupCombineFunctions {
    public static <K, V> JavaRDD<WindowedValue<KV<K, Iterable<WindowedValue<V>>>>> groupByKeyOnly(JavaRDD<WindowedValue<KV<K, V>>> rdd, Coder<K> keyCoder, WindowedValue.WindowedValueCoder<V> wvCoder) {
        return rdd.map(new ReifyTimestampsAndWindowsFunction()).map(WindowingHelpers.unwindowFunction()).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunction(keyCoder, wvCoder)).groupByKey().mapToPair(CoderHelpers.fromByteFunctionIterable(keyCoder, wvCoder)).map(TranslationUtils.fromPairFunction()).map(WindowingHelpers.windowFunction());
    }

    public static <InputT, AccumT> Iterable<WindowedValue<AccumT>> combineGlobally(JavaRDD<WindowedValue<InputT>> rdd, final SparkGlobalCombineFn<InputT, AccumT, ?> sparkCombineFn, Coder<InputT> iCoder, Coder<AccumT> aCoder, WindowingStrategy<?, ?> windowingStrategy) {
        Preconditions.checkArgument(!rdd.isEmpty(), "CombineGlobally computation should be skipped for empty RDDs.");
        final WindowedValue.FullWindowedValueCoder wviCoder = WindowedValue.FullWindowedValueCoder.of(iCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
        WindowedValue.FullWindowedValueCoder wvaCoder = WindowedValue.FullWindowedValueCoder.of(aCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
        final IterableCoder iterAccumCoder = IterableCoder.of((Coder)wvaCoder);
        JavaRDD inputRDDBytes = rdd.map(CoderHelpers.toByteFunction(wviCoder));
        byte[] accumulatedBytes = (byte[])inputRDDBytes.aggregate((Object)CoderHelpers.toByteArray(sparkCombineFn.zeroValue(), iterAccumCoder), (Function2)new Function2<byte[], byte[], byte[]>(){

            public byte[] call(byte[] ab, byte[] ib) throws Exception {
                Iterable a = (Iterable)CoderHelpers.fromByteArray(ab, iterAccumCoder);
                WindowedValue i = (WindowedValue)CoderHelpers.fromByteArray(ib, wviCoder);
                return CoderHelpers.toByteArray(sparkCombineFn.seqOp(a, i), iterAccumCoder);
            }
        }, (Function2)new Function2<byte[], byte[], byte[]>(){

            public byte[] call(byte[] a1b, byte[] a2b) throws Exception {
                Iterable a1 = (Iterable)CoderHelpers.fromByteArray(a1b, iterAccumCoder);
                Iterable a2 = (Iterable)CoderHelpers.fromByteArray(a2b, iterAccumCoder);
                Iterable merged = sparkCombineFn.combOp(a1, a2);
                return CoderHelpers.toByteArray(merged, iterAccumCoder);
            }
        });
        return (Iterable)CoderHelpers.fromByteArray(accumulatedBytes, iterAccumCoder);
    }

    public static <K, InputT, AccumT> JavaPairRDD<K, Iterable<WindowedValue<KV<K, AccumT>>>> combinePerKey(JavaRDD<WindowedValue<KV<K, InputT>>> rdd, final SparkKeyedCombineFn<K, InputT, AccumT, ?> sparkCombineFn, Coder<K> keyCoder, Coder<InputT> iCoder, Coder<AccumT> aCoder, WindowingStrategy<?, ?> windowingStrategy) {
        final WindowedValue.FullWindowedValueCoder wkviCoder = WindowedValue.FullWindowedValueCoder.of((Coder)KvCoder.of(keyCoder, iCoder), (Coder)windowingStrategy.getWindowFn().windowCoder());
        WindowedValue.FullWindowedValueCoder wkvaCoder = WindowedValue.FullWindowedValueCoder.of((Coder)KvCoder.of(keyCoder, aCoder), (Coder)windowingStrategy.getWindowFn().windowCoder());
        final IterableCoder iterAccumCoder = IterableCoder.of((Coder)wkvaCoder);
        JavaPairRDD inRddDuplicatedKeyPair = rdd.mapToPair(TranslationUtils.toPairByKeyInWindowedValue());
        JavaPairRDD inRddDuplicatedKeyPairBytes = inRddDuplicatedKeyPair.mapToPair(CoderHelpers.toByteFunction(keyCoder, wkviCoder));
        JavaPairRDD accumulatedBytes = inRddDuplicatedKeyPairBytes.combineByKey((Function)new Function<byte[], byte[]>(){

            public byte[] call(byte[] input) {
                WindowedValue wkvi = (WindowedValue)CoderHelpers.fromByteArray(input, wkviCoder);
                return CoderHelpers.toByteArray(sparkCombineFn.createCombiner(wkvi), iterAccumCoder);
            }
        }, (Function2)new Function2<byte[], byte[], byte[]>(){

            public byte[] call(byte[] acc, byte[] input) {
                Iterable wkvas = (Iterable)CoderHelpers.fromByteArray(acc, iterAccumCoder);
                WindowedValue wkvi = (WindowedValue)CoderHelpers.fromByteArray(input, wkviCoder);
                return CoderHelpers.toByteArray(sparkCombineFn.mergeValue(wkvi, wkvas), iterAccumCoder);
            }
        }, (Function2)new Function2<byte[], byte[], byte[]>(){

            public byte[] call(byte[] acc1, byte[] acc2) {
                Iterable wkvas1 = (Iterable)CoderHelpers.fromByteArray(acc1, iterAccumCoder);
                Iterable wkvas2 = (Iterable)CoderHelpers.fromByteArray(acc2, iterAccumCoder);
                return CoderHelpers.toByteArray(sparkCombineFn.mergeCombiners(wkvas1, wkvas2), iterAccumCoder);
            }
        });
        return accumulatedBytes.mapToPair(CoderHelpers.fromByteFunction(keyCoder, iterAccumCoder));
    }

    public static <K, V> JavaRDD<WindowedValue<KV<K, V>>> reshuffle(JavaRDD<WindowedValue<KV<K, V>>> rdd, Coder<K> keyCoder, WindowedValue.WindowedValueCoder<V> wvCoder) {
        return rdd.map(new ReifyTimestampsAndWindowsFunction()).map(WindowingHelpers.unwindowFunction()).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunction(keyCoder, wvCoder)).repartition(rdd.getNumPartitions()).mapToPair(CoderHelpers.fromByteFunction(keyCoder, wvCoder)).map(TranslationUtils.fromPairFunction()).map(TranslationUtils.toKVByWindowInValue());
    }
}

