/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.spark.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.spark.repackaged.com.google.common.collect.Iterables;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingContext;

public class EvaluationContext {
    private final JavaSparkContext jsc;
    private JavaStreamingContext jssc;
    private final SparkRuntimeContext runtime;
    private final Pipeline pipeline;
    private final Map<PValue, Dataset> datasets = new LinkedHashMap<PValue, Dataset>();
    private final Map<PValue, Dataset> pcollections = new LinkedHashMap<PValue, Dataset>();
    private final Set<Dataset> leaves = new LinkedHashSet<Dataset>();
    private final Set<PValue> multiReads = new LinkedHashSet<PValue>();
    private final Map<PValue, Object> pobjects = new LinkedHashMap<PValue, Object>();
    private AppliedPTransform<?, ?, ?> currentTransform;
    private final SparkPCollectionView pviews = new SparkPCollectionView();

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline) {
        this.jsc = jsc;
        this.pipeline = pipeline;
        this.runtime = new SparkRuntimeContext(pipeline);
    }

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline, JavaStreamingContext jssc) {
        this(jsc, pipeline);
        this.jssc = jssc;
    }

    public JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    public JavaStreamingContext getStreamingContext() {
        return this.jssc;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public SparkRuntimeContext getRuntimeContext() {
        return this.runtime;
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> transform) {
        this.currentTransform = transform;
    }

    public AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public <T extends PValue> T getInput(PTransform<T, ?> transform) {
        PValue input = Iterables.getOnlyElement(this.getInputs(transform)).getValue();
        return (T)input;
    }

    public <T> List<TaggedPValue> getInputs(PTransform<?, ?> transform) {
        Preconditions.checkArgument(this.currentTransform != null && this.currentTransform.getTransform() == transform, "can only be called with current transform");
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getOutput(PTransform<?, T> transform) {
        PValue output = Iterables.getOnlyElement(this.getOutputs(transform)).getValue();
        return (T)output;
    }

    public List<TaggedPValue> getOutputs(PTransform<?, ?> transform) {
        Preconditions.checkArgument(this.currentTransform != null && this.currentTransform.getTransform() == transform, "can only be called with current transform");
        return this.currentTransform.getOutputs();
    }

    public void putDataset(PTransform<?, ? extends PValue> transform, Dataset dataset) {
        this.putDataset(this.getOutput(transform), dataset);
    }

    public void putDataset(PValue pvalue, Dataset dataset) {
        try {
            dataset.setName(pvalue.getName());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.datasets.put(pvalue, dataset);
        this.leaves.add(dataset);
    }

    <T> void putBoundedDatasetFromValues(PTransform<?, ? extends PValue> transform, Iterable<T> values, Coder<T> coder) {
        this.datasets.put(this.getOutput(transform), new BoundedDataset<T>(values, this.jsc, coder));
    }

    public Dataset borrowDataset(PTransform<? extends PValue, ?> transform) {
        return this.borrowDataset(this.getInput(transform));
    }

    public Dataset borrowDataset(PValue pvalue) {
        Dataset dataset = this.datasets.get(pvalue);
        this.leaves.remove(dataset);
        if (this.multiReads.contains(pvalue)) {
            dataset.cache(this.storageLevel());
        } else {
            this.multiReads.add(pvalue);
        }
        return dataset;
    }

    public void computeOutputs() {
        for (Dataset dataset : this.leaves) {
            dataset.cache(this.storageLevel());
            dataset.action();
        }
    }

    public <T> T get(PValue value) {
        if (this.pobjects.containsKey(value)) {
            Object result = this.pobjects.get(value);
            return (T)result;
        }
        if (this.pcollections.containsKey(value)) {
            JavaRDD rdd = ((BoundedDataset)this.pcollections.get(value)).getRDD();
            Object res = Iterables.getOnlyElement(rdd.collect());
            this.pobjects.put(value, res);
            return res;
        }
        throw new IllegalStateException("Cannot resolve un-known PObject: " + value);
    }

    <T> Iterable<T> get(PCollection<T> pcollection) {
        Iterable<WindowedValue<T>> windowedValues = this.getWindowedValues(pcollection);
        return Iterables.transform(windowedValues, WindowingHelpers.unwindowValueFunction());
    }

    public SparkPCollectionView getPViews() {
        return this.pviews;
    }

    public void putPView(PCollectionView<?> view, Iterable<WindowedValue<?>> value, Coder<Iterable<WindowedValue<?>>> coder) {
        this.pviews.putPView(view, value, coder);
    }

    <T> Iterable<WindowedValue<T>> getWindowedValues(PCollection<T> pcollection) {
        BoundedDataset boundedDataset = (BoundedDataset)this.datasets.get(pcollection);
        this.leaves.remove(boundedDataset);
        return boundedDataset.getValues(pcollection);
    }

    private String storageLevel() {
        return ((SparkPipelineOptions)this.runtime.getPipelineOptions().as(SparkPipelineOptions.class)).getStorageLevel();
    }
}

