/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import java.util.Set;
import org.apache.beam.runners.spark.metrics.SparkMetricsContainer;
import org.apache.beam.sdk.metrics.DistributionData;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricUpdates;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.spark.repackaged.com.google.common.base.Function;
import org.apache.beam.spark.repackaged.com.google.common.base.Objects;
import org.apache.beam.spark.repackaged.com.google.common.base.Predicate;
import org.apache.beam.spark.repackaged.com.google.common.collect.FluentIterable;

public class SparkMetricResults
extends MetricResults {
    private static final Function<MetricUpdates.MetricUpdate<DistributionData>, MetricResult<DistributionResult>> TO_DISTRIBUTION_RESULT = new Function<MetricUpdates.MetricUpdate<DistributionData>, MetricResult<DistributionResult>>(){

        @Override
        public MetricResult<DistributionResult> apply(MetricUpdates.MetricUpdate<DistributionData> metricResult) {
            if (metricResult != null) {
                MetricKey key = metricResult.getKey();
                return new SparkMetricResult<DistributionResult>(key.metricName(), key.stepName(), ((DistributionData)metricResult.getUpdate()).extractResult());
            }
            return null;
        }
    };
    private static final Function<MetricUpdates.MetricUpdate<Long>, MetricResult<Long>> TO_COUNTER_RESULT = new Function<MetricUpdates.MetricUpdate<Long>, MetricResult<Long>>(){

        @Override
        public MetricResult<Long> apply(MetricUpdates.MetricUpdate<Long> metricResult) {
            if (metricResult != null) {
                MetricKey key = metricResult.getKey();
                return new SparkMetricResult<Object>(key.metricName(), key.stepName(), metricResult.getUpdate());
            }
            return null;
        }
    };

    public MetricQueryResults queryMetrics(MetricsFilter filter) {
        return new SparkMetricQueryResults(filter);
    }

    private static class SparkMetricResult<T>
    implements MetricResult<T> {
        private final MetricName name;
        private final String step;
        private final T result;

        SparkMetricResult(MetricName name, String step, T result) {
            this.name = name;
            this.step = step;
            this.result = result;
        }

        public MetricName name() {
            return this.name;
        }

        public String step() {
            return this.step;
        }

        public T committed() {
            throw new UnsupportedOperationException("Spark runner does not currently support committed metrics results. Please use 'attempted' instead.");
        }

        public T attempted() {
            return this.result;
        }
    }

    private static class SparkMetricQueryResults
    implements MetricQueryResults {
        private final MetricsFilter filter;

        SparkMetricQueryResults(MetricsFilter filter) {
            this.filter = filter;
        }

        public Iterable<MetricResult<Long>> counters() {
            return FluentIterable.from(SparkMetricsContainer.getCounters()).filter(this.matchesFilter(this.filter)).transform(TO_COUNTER_RESULT).toList();
        }

        public Iterable<MetricResult<DistributionResult>> distributions() {
            return FluentIterable.from(SparkMetricsContainer.getDistributions()).filter(this.matchesFilter(this.filter)).transform(TO_DISTRIBUTION_RESULT).toList();
        }

        private Predicate<MetricUpdates.MetricUpdate<?>> matchesFilter(final MetricsFilter filter) {
            return new Predicate<MetricUpdates.MetricUpdate<?>>(){

                @Override
                public boolean apply(MetricUpdates.MetricUpdate<?> metricResult) {
                    return SparkMetricQueryResults.this.matches(filter, metricResult.getKey());
                }
            };
        }

        private boolean matches(MetricsFilter filter, MetricKey key) {
            return this.matchesName(key.metricName(), filter.names()) && this.matchesScope(key.stepName(), filter.steps());
        }

        private boolean matchesName(MetricName metricName, Set<MetricNameFilter> nameFilters) {
            if (nameFilters.isEmpty()) {
                return true;
            }
            for (MetricNameFilter nameFilter : nameFilters) {
                if (nameFilter.getName() != null && !nameFilter.getName().equals(metricName.name()) || !Objects.equal(metricName.namespace(), nameFilter.getNamespace())) continue;
                return true;
            }
            return false;
        }

        private boolean matchesScope(String actualScope, Set<String> scopes) {
            if (scopes.isEmpty() || scopes.contains(actualScope)) {
                return true;
            }
            for (String scope : scopes) {
                if (!actualScope.startsWith(scope)) continue;
                return true;
            }
            return false;
        }
    }
}

