/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import java.io.IOException;
import org.apache.beam.runners.spark.metrics.MetricsAccumulatorParam;
import org.apache.beam.runners.spark.metrics.SparkMetricsContainer;
import org.apache.beam.runners.spark.translation.streaming.Checkpoint;
import org.apache.beam.spark.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.spark.repackaged.com.google.common.base.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingListener;
import org.apache.spark.streaming.api.java.JavaStreamingListenerBatchCompleted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsAccumulator.class);
    private static final String ACCUMULATOR_CHECKPOINT_FILENAME = "metrics";
    private static volatile Accumulator<SparkMetricsContainer> instance = null;
    private static volatile FileSystem fileSystem;
    private static volatile Path checkpointFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(JavaSparkContext jsc, Optional<Checkpoint.CheckpointDir> checkpointDir) {
        if (instance != null) return;
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            if (instance != null) return;
            SparkMetricsContainer initialValue = new SparkMetricsContainer();
            instance = jsc.sc().accumulator((Object)initialValue, "Beam.Metrics", (AccumulatorParam)new MetricsAccumulatorParam());
            if (!checkpointDir.isPresent()) return;
            MetricsAccumulator.recoverValueFromCheckpoint(jsc, checkpointDir.get());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Accumulator<SparkMetricsContainer> getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Metrics accumulator has not been instantiated");
        }
        return instance;
    }

    private static void recoverValueFromCheckpoint(JavaSparkContext jsc, Checkpoint.CheckpointDir checkpointDir) {
        try {
            Path beamCheckpointPath = checkpointDir.getBeamCheckpointDir();
            checkpointFilePath = new Path(beamCheckpointPath, ACCUMULATOR_CHECKPOINT_FILENAME);
            fileSystem = checkpointFilePath.getFileSystem(jsc.hadoopConfiguration());
            SparkMetricsContainer recoveredValue = (SparkMetricsContainer)Checkpoint.readObject(fileSystem, checkpointFilePath);
            if (recoveredValue != null) {
                LOG.info("Recovered metrics from checkpoint: " + recoveredValue);
                instance.setValue((Object)recoveredValue);
            } else {
                LOG.info("No metrics checkpoint found.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failure while reading metrics checkpoint.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clear() {
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void checkpoint() throws IOException {
        if (checkpointFilePath != null) {
            Checkpoint.writeObject(fileSystem, checkpointFilePath, instance.value());
        }
    }

    public static class AccumulatorCheckpointingSparkListener
    extends JavaStreamingListener {
        public void onBatchCompleted(JavaStreamingListenerBatchCompleted batchCompleted) {
            try {
                MetricsAccumulator.checkpoint();
            }
            catch (IOException e) {
                LOG.error("Failed to checkpoint metrics singleton.", (Throwable)e);
            }
        }
    }
}

