/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BroadcastHelper<T>
implements Serializable {
    public static final String DIRECT_BROADCAST = "dataflow.spark.directBroadcast";
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastHelper.class);

    public static <T> BroadcastHelper<T> create(T value, Coder<T> coder) {
        if (Boolean.parseBoolean(System.getProperty(DIRECT_BROADCAST, "false"))) {
            return new DirectBroadcastHelper<T>(value);
        }
        return new CodedBroadcastHelper<T>(value, coder);
    }

    public abstract T getValue();

    public abstract void broadcast(JavaSparkContext var1);

    static class CodedBroadcastHelper<T>
    extends BroadcastHelper<T> {
        private Broadcast<byte[]> bcast;
        private final Coder<T> coder;
        private transient T value;

        CodedBroadcastHelper(T value, Coder<T> coder) {
            this.value = value;
            this.coder = coder;
        }

        @Override
        public synchronized T getValue() {
            if (this.value == null) {
                this.value = this.deserialize();
            }
            return this.value;
        }

        @Override
        public void broadcast(JavaSparkContext jsc) {
            this.bcast = jsc.broadcast((Object)CoderHelpers.toByteArray(this.value, this.coder));
        }

        private T deserialize() {
            Object val;
            try {
                val = this.coder.decode((InputStream)new ByteArrayInputStream((byte[])this.bcast.value()), new Coder.Context(true));
            }
            catch (IOException ioe) {
                LOG.warn(ioe.getMessage());
                val = null;
            }
            return (T)val;
        }
    }

    static class DirectBroadcastHelper<T>
    extends BroadcastHelper<T> {
        private Broadcast<T> bcast;
        private transient T value;

        DirectBroadcastHelper(T value) {
            this.value = value;
        }

        @Override
        public synchronized T getValue() {
            if (this.value == null) {
                this.value = this.bcast.getValue();
            }
            return this.value;
        }

        @Override
        public void broadcast(JavaSparkContext jsc) {
            this.bcast = jsc.broadcast(this.value);
        }
    }
}

