/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.sdk.runners.TransformTreeNode;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;

public final class SparkPipelineEvaluator
extends SparkRunner.Evaluator {
    private final EvaluationContext ctxt;

    public SparkPipelineEvaluator(EvaluationContext ctxt, SparkPipelineTranslator translator) {
        super(translator);
        this.ctxt = ctxt;
    }

    @Override
    protected <TransformT extends PTransform<? super PInput, POutput>> void doVisitTransform(TransformTreeNode node) {
        PTransform transform = node.getTransform();
        Class<?> transformClass = transform.getClass();
        TransformEvaluator<?> evaluator = this.translator.translate(transformClass);
        LOG.info("Evaluating {}", (Object)transform);
        AppliedPTransform appliedTransform = AppliedPTransform.of((String)node.getFullName(), (PInput)node.getInput(), (POutput)node.getOutput(), (PTransform)transform);
        this.ctxt.setCurrentTransform(appliedTransform);
        evaluator.evaluate(transform, this.ctxt);
        this.ctxt.setCurrentTransform(null);
    }
}

